<?php 
    //leslie man oliva
    /*  ID's Categorias
     *  Income = 11
     *  Other Income = 12
     *  Cost of Goods Solds = 13
     *  Expenses = 14
     *  Other Expenses = 15
     * 
     *  P&L Form
     *  (Income - Cost of Goods Sold) - Expenses = Net Operating Income
     *  Net Operating Income - (Other Income - Other Expenses) = Net Income
     */
    class PL{
        private $_categorias = array(
            '11'=>array('nombre'=>'Income','total'=>0),
            '12'=>array('nombre'=>'Other Income','total'=>0),
            '13'=>array('nombre'=>'Cost of Goods Solds','total'=>0),
            '14'=>array('nombre'=>'Expenses','total'=>0),
            '15'=>array('nombre'=>'Other Expenses','total'=>0)
            );
        private $_translator = null;
        private $_cuentas = array();
        private $_cuentasParent = array();
        private $_subcuentas = array();
         private $_repoCatalogoCuentas = null;
        
        private $_stringPrintCuentas = '';
        private $_totalCuenta = 0;
        private $_netOperatingIncome = 0;
        
        private $_printTotalCuenta = null;
        private $_paddingCuenta = 1;
        private $_ultimoPaddingCuenta = 1;
        private $_countSubAccount = 0;
        
        private $_options = array(
            'reporte'=>null,
            'fechaInicio'=>null,
            'fechaFin'=>null,
            'output'=>null
        );
        
        public function setOptions($data){
            foreach ($this->_options as $option => $value){
                if(isset($data[$option])){
                  $this->_options[$option] = $data[$option];
                }
            }
        }
        
        public function getOptions(){
            return $this->_options;
        }
        
        public function getURLToBack(){
            $options = $this->getOptions();
            return urlencode(serialize($options));
        }
        
        public function getButtonToBack($data){
            $array = unserialize(urldecode($_GET['btnback']));
            
            $queryString = "";
            foreach($array as $key => $value){
                $queryString .= $key."=$value&"; 
            }
           
            return "<a href='?".trim($queryString,"&")."'>Back</a>";
        }
        
        private function _getTranslation($string){
            if(!$this->_translator instanceof Translator){
                $this->_translator = new Translator();
            }
            return $this->_translator->_getTranslation($string);
        }
        
        private function getFechaInicio(){
            return $this->_options['fechaInicio'];
        }
        
        private function getFechaFin(){
            return $this->_options['fechaFin'];
        }
        
        private function setNetOperatingIncome($income){
            $this->_netOperatingIncome = $income;
        }
        
        private function getNetOperatingIncome(){
            return $this->_netOperatingIncome;
        }
        
        public function setData($data){
           $this->setIndexCuentas($data);
           
           $this->setCuentasParent();
           $this->setSubcuentas();
        }
        
        private function setIndexCuentas($data){
            /* Indexar cuentasContables */
            foreach($data as $cuenta){
                $this->_cuentas[$cuenta['idCuenta']] = $cuenta;
            }
        }
        
        private function setSubcuentas(){
            /* Arreglo con Subcuentas */
            foreach($this->_cuentas as $row){
                if($row['subCuentaDe']!=0){
                    $this->_subcuentas[$row['idCuenta']] = $row['subCuentaDe'];                    
                }
            }
           // echo "<pre>";print_r($this->_subcuentas);echo "</pre>";exit;
        }
        
       private function setCuentasParent(){
            $this->_cuentasParent = $this->_cuentas;
            foreach($this->_cuentasParent as $key => $cuenta){
                if($cuenta['subCuentaDe']!='0'){
                    /*Si es subcuenta la elimino*/                    
                    unset($this->_cuentasParent[$cuenta['idCuenta']]);                    
                    /* Si cuentaParent de subcuenta no existe, la agrego manual*/
                    /* La agrego para que las subcuentas aparezcan debajo de la cuenta Parent*/
                    if(!array_key_exists($cuenta['subCuentaDe'], $this->_cuentas)){ //Debe ser $this->_cuentas, no _cuentasParen
                        /* Obtengo la informacion de la cuenta Parent */
                        $subCuentaData = $this->getSubCuentaDe($cuenta['subCuentaDe']);
                        
                        /* Si la cuenta Parent es subCuenta de otra cuenta, se debe agregar al array Cuentas*/
                        /* Esto para que al momento de que utilice setSubcuentas la agregue como subcuenta*/
                        /* En esta caso no se agrega como Parent, porque es subCuenta de otra.*/
                        /* $this->_cuentasParent deben ser cuentas que no son subcuentas de otras. */
                        if($subCuentaData && $subCuentaData['subAccountOf'] != 0){ 
                            $this->_cuentas[$cuenta['subCuentaDe']]['idCuenta'] = $cuenta['subCuentaDe'];                        
                            $this->_cuentas[$cuenta['subCuentaDe']]['cuenta'] = $subCuentaData['nombre'];
                            $this->_cuentas[$cuenta['subCuentaDe']]['subCuentaDe'] = $subCuentaData['subAccountOf'];
                            $this->_cuentas[$cuenta['subCuentaDe']]['idCategoria'] = $cuenta['idCategoria'];
                            $this->_cuentas[$cuenta['subCuentaDe']]['creditBalance'] = '';
                            $this->_cuentas[$cuenta['subCuentaDe']]['debitBalance'] = '';
                        }else{
                          /* Si la cuenta Parent no es subCuenta de otra, se agrega a $this->_cuentasParent */
                          $cuenta['idCuenta'] = $cuenta['subCuentaDe'];
                          $cuenta['cuenta'] = $cuenta['subCuentaDeNombre'];         
                          $cuenta['creditBalance'] = '';
                          $cuenta['debitBalance'] = '';
                          $this->_cuentasParent[$cuenta['idCuenta']] = $cuenta;  
                        }                      
                    }  
                }
            }
           // echo "<pre>";print_r($this->_cuentasParent);echo "</pre>";exit;
        }
        
        public function getRepoCatalogoCuentas(){
            if($this->_repoCatalogoCuentas === null){
                $this->_repoCatalogoCuentas = new CatalogoCuentaRepository();  
            }
            return $this->_repoCatalogoCuentas;
        }
        
        public function getSubCuentaDe($idCuenta){
            $repo = $this->getRepoCatalogoCuentas();
            $dataCuenta = $repo->getById($idCuenta);
            
            return $dataCuenta;
        }
        
        public function printCategoria($idCategoria){
            $nombreCategoria = $this->_categorias[$idCategoria]['nombre'];
            $this->_stringPrintCuentas = "";           
            $this->_stringPrintCuentas  = "<tr><td class='pl-nombreCategoria'>$nombreCategoria</td></tr>";
         
            foreach($this->_cuentasParent as $cuenta){
                if($cuenta['idCategoria'] == $idCategoria){
                    $this->printCuentas($cuenta);                    
                }
                $this->_categorias[$idCategoria]['total'] += $this->_totalCuenta;
                $this->printTotalCuenta($cuenta);
            }       
            
            $categoria = $this->_categorias[$idCategoria];
            $this->printTotalCategoria($idCategoria);
            
            if(trim($categoria['total']) != 0){
                return $this->_stringPrintCuentas;
            }            
        }       
        
        public function printCuentas($cuenta){ 
            $this->_stringPrintCuentas .= ""
                    . "<tr>"
                    . "<td style='padding-left:".$this->_paddingCuenta."px'>{$cuenta['cuenta']}</td>"
                    . "<td class='pl-totales'><a href='?reporte=pl_details&type=account&id={$cuenta['idCuenta']}&sd={$this->getFechaInicio()}&ed={$this->getFechaFin()}&output=pantalla&btnback={$this->getURLToBack()}'>{$this->printTotalFormat((double)$cuenta['balance'])}</a></td>"
                    . "</tr>"; 
              
            $this->_totalCuenta += (double)$cuenta['balance'];
            
            if($subcuentas = array_keys($this->_subcuentas, $cuenta['idCuenta'])){ 
                $this->_countSubAccount = count($subcuentas);
                $this->_ultimoPaddingCuenta = $this->_paddingCuenta;                             
                $this->_paddingCuenta+=15;
                foreach ($subcuentas as $key => $value){        
                   $this->_printTotalCuenta = true;                       
                   $this->printCuentas($this->_cuentas[$value]);
                   $this->_countSubAccount--;
               }               
            }            
              if($this->_countSubAccount == 0){
                $this->_paddingCuenta = $this->_ultimoPaddingCuenta;
              }
              return;
        }
        
        private function printTotalCuenta ($cuenta){
            if($this->_printTotalCuenta){
                $this->_stringPrintCuentas .= ""
                        . "<tr>"
                        . "<td class='pl-nombre-totales-cuentas'>Total ".$cuenta['cuenta']."</td>"
                        . "<td class='pl-totales pl-totales-cuentas'><a href='?reporte=pl_details&type=accSubacc&id={$cuenta['idCuenta']}&sd={$this->getFechaInicio()}&ed={$this->getFechaFin()}&output=pantalla&btnback={$this->getURLToBack()}'>{$this->printTotalFormat($this->_totalCuenta)}</a></td>"
                        . "</tr>";
                $this->_printTotalCuenta = null;
            }
            $this->_totalCuenta = 0;
        }
        
        private function printTotalCategoria($idCategoria){
            $categoria = $this->_categorias[$idCategoria];            
            $this->_stringPrintCuentas .= ""
                        . "<tr>"
                        . "<td class='pl-nombre-totales-cuentas'>Total ".$categoria['nombre']."</td>"
                        . "<td class='pl-totales pl-totales-cuentas'><a href='?reporte=pl_details&type=category&id={$idCategoria}&sd={$this->getFechaInicio()}&ed={$this->getFechaFin()}&output=pantalla&btnback={$this->getURLToBack()}'>{$this->printTotalFormat($categoria['total'])}</a></td>"
                        . "</tr>";
        }
        
        public function printGrossProfit($todetails = null){
            $income = $this->getTotalCategoria(11);
            $cogs = $this->getTotalCategoria(13);
            if($income == 0 && $cogs == 0){return null;}
            
            $grossProfit = (double)$income - (double)$cogs;
            
            if($todetails){
                $string = "<tr>"
                    . "<td colspan='4' class='pl-nombre-totales-cuentas'>Gross Profit</td>"
                    . "<td class='pl-totales pl-totales-cuentas'>{$this->printTotalFormat($grossProfit)}</a></td>"
                    . "</tr>";
                    
                return $string;
            }
            
            $string = "<tr>"
                    . "<td class='pl-nombre-totales-cuentas'>Gross Profit</td>"
                    . "<td class='pl-totales pl-totales-cuentas'><a href='?reporte=pl_details&type=grossProfit&sd={$this->getFechaInicio()}&ed={$this->getFechaFin()}&output=pantalla&btnback={$this->getURLToBack()}'>{$this->printTotalFormat($grossProfit)}</a></td>"
                    . "</tr>";
                    
            return $string;
        }
        
        public function printNetOperatingIncome($todetails = null){
            $income = $this->getTotalCategoria(11);
            $cogs = $this->getTotalCategoria(13);
            $expenses = $this->getTotalCategoria(14);
            if($income == 0 && $cogs == 0 && $expenses == 0){return null;}
            
            $netOperatingIncome = ((double)$income - (double)$cogs) - (double)$expenses;
            $this->setNetOperatingIncome($netOperatingIncome);
            
            if($todetails){
                $string = "<tr>"
                    . "<td colspan='4' class='pl-nombre-totales-cuentas'>Net Operating Income</td>"
                    . "<td class='pl-totales pl-totales-cuentas'>{$this->printTotalFormat($netOperatingIncome)}</td>"
                    . "</tr>";
                    
                return $string; 
            }
            
            $string = "<tr>"
                    . "<td class='pl-nombre-totales-cuentas'>Net Operating Income</td>"
                    . "<td class='pl-totales pl-totales-cuentas'><a href='?reporte=pl_details&type=netOperatingIncome&sd={$this->getFechaInicio()}&ed={$this->getFechaFin()}&output=pantalla&btnback={$this->getURLToBack()}'>{$this->printTotalFormat($netOperatingIncome)}</a></td>"
                    . "</tr>";
                    
            return $string;
        }
        
        public function printNetOtherIncome($todetails = null){
            $otherIncome = $this->getTotalCategoria(12);
            $otherExpenses = $this->getTotalCategoria(15); 
            if($otherIncome == 0 && $otherExpenses == 0){return null;}
            
            $netOtherIncome = (double)$otherIncome - (double)$otherExpenses;               
            
            if($todetails){
                $string = "<tr>"
                    . "<td colspan='4' class='pl-nombre-totales-cuentas'>Net Other Income</td>"
                    . "<td class='pl-totales pl-totales-cuentas'>{$this->printTotalFormat($netOtherIncome)}</td>"
                    . "</tr>";
                    
                return $string;
            }
            
            $string = "<tr>"
                    . "<td class='pl-nombre-totales-cuentas'>Net Other Income</td>"
                    . "<td class='pl-totales pl-totales-cuentas'><a href='?reporte=pl_details&type=netOtherIncome&sd={$this->getFechaInicio()}&ed={$this->getFechaFin()}&output=pantalla&btnback={$this->getURLToBack()}'>{$this->printTotalFormat($netOtherIncome)}</a></td>"
                    . "</tr>";
                    
            return $string;
        }
        
        public function printNetIncome($todetails = null){
            $otherIncome = $this->getTotalCategoria(12);
            $otherExpenses = $this->getTotalCategoria(15);
            $netOperatingIncome = $this->getNetOperatingIncome();
            if($otherIncome == 0 && $otherExpenses == 0 && $netOperatingIncome == 0){return null;}
            
            $netOtherIncome = (double)$otherIncome - (double)$otherExpenses;
            $netIncome = (double)$netOperatingIncome + (double)$netOtherIncome;
            
            if($todetails){
                $string = "<tr>"
                        . "<td colspan='4' class='pl-nombre-totales-cuentas'>Net Income</td>"
                        . "<td class='pl-totales pl-totales-cuentas'>{$this->printTotalFormat($netIncome)}</td>"
                        . "</tr>";

                return $string;
            }
            
            $string = "<tr>"
                    . "<td class='pl-nombre-totales-cuentas'>Net Income</td>"
                    . "<td class='pl-totales pl-totales-cuentas'><a href='?reporte=pl_details&type=netIncome&sd={$this->getFechaInicio()}&ed={$this->getFechaFin()}&output=pantalla&btnback={$this->getURLToBack()}'>{$this->printTotalFormat($netIncome)}</a></td>"
                    . "</tr>";
                    
            return $string;
        }
        
        private function getTotalCategoria($categoria){
            return $this->_categorias[$categoria]['total'];
        }       
        
        private $_optionsToListDetails = array(
            'sd'=>null,
            'ed'=>null,
            'type'=>null,
            'id'=>null,
        );
        
        private $_detalles = null;
        private $_dataGroupByIdCuenta = array();
        private $_sumarTotalCuentas = null;
        private $_totalCategoria = 0;        
        
        public function setOptionsToListDetails($data){
            foreach ($this->_optionsToListDetails as $option => $value){
                if(isset($data[$option])){
                  $this->_optionsToListDetails[$option] = $data[$option];
                }
            }
        }
        
        public function setDataToLisDetails($data){
            $this->_detalles = $data;
        }
        
        public function getDataDetails(){
            return $this->_detalles;
        }
        
        public function getSD(){
            return $this->_optionsToListDetails['sd'];
        }
        
         public function getED(){
            return  $this->_optionsToListDetails['ed'];
        }
        
        public function printReportTitle(){
            $empresa = new EmpresaRepository();
            $empresa = $empresa->getById(1);
            $tools = new Tools();            
            
            $startDate = $this->getFechaInicio();
            $endDate = $this->getFechaFin();            
            
            $dates = $this->getDatesToPrint($startDate,$endDate);
            $startDate = $dates['startDate'];
            $endDate = $dates['endDate'];

            $string = "<div class='rpt-nombre-empresa'>{$empresa['nombre']}</div>";
            $string .= "<div class='rpt-nombre-reporte'>". ucfirst($this->_getTranslation('PERDIDAS Y GANANCIAS'))."</div>";
            $string .= "<div class='rpt-fecha' style='margin-bottom:20px'>".$startDate." - ".$endDate."</div>";           
            return $string;
        }
        
        public function printDetailsTitle(){
            $empresa = new EmpresaRepository();
            $empresa = $empresa->getById(1);

            $startDate = $this->getSD();
            $endDate = $this->getED();
            
            $dates = $this->getDatesToPrint($startDate,$endDate);
            $startDate = $dates['startDate'];
            $endDate = $dates['endDate'];
                        
            $string = "<div class='rpt-nombre-empresa'>{$empresa['nombre']}</div>";
            $string .= "<div class='rpt-nombre-reporte'>".ucfirst($this->_getTranslation('REPORTE DE OPERACIONES'))."</div>";
            $string .= "<div class='rpt-fecha'>".$startDate." - ".$endDate."</div>";
            
            
            return $string;
        }
        
        public function printDetails(){
            switch($this->_optionsToListDetails['type']){
                case 'account':
                    return $this->printDetailsAcount();                
                case 'accSubacc':
                    $data = $this->getDataDetails();
                    $this->setData($data);
                    $return = $this->printHeaderDetails();  
                    $return .= $this->printDetailsAccSubAcc($data[0]['idCategoria']);
                    $return .= $this->printCloseTable();
                    
                    return $return;
                case 'category':
                    $data = $this->getDataDetails();
                    $this->setData($data);
                    $return = $this->printHeaderDetails();
                    $return .= $this->printDetailsAccSubAcc($data[0]['idCategoria'],true);
                    $return .= $this->printCloseTable();
                    
                    return $return;
                case 'grossProfit':
                    $data = $this->getDataDetails();
                    $this->setData($data);
                    $return = $this->printHeaderDetails();
                    $return .= $this->printDetailsAccSubAcc(11,true); 
                    $return .= $this->printDetailsAccSubAcc(13,true);
                    $return .= $this->printGrossProfit(true);
                    $return .= $this->printCloseTable();
                    
                    return $return;
                case 'netOperatingIncome':
                    $data = $this->getDataDetails();
                    $this->setData($data);
                    $return = $this->printHeaderDetails();
                    $return .= $this->printDetailsAccSubAcc(11,true); 
                    $return .= $this->printDetailsAccSubAcc(13,true);
                    $return .= $this->printGrossProfit(true);
                    $return .= $this->printDetailsAccSubAcc(14,true);
                    $return .= $this->printNetOperatingIncome(true);
                    $return .= $this->printCloseTable();
                    
                    return $return;
                    
                case 'netOtherIncome':
                    $data = $this->getDataDetails();
                    $this->setData($data);
                    $return = $this->printHeaderDetails();
                    $return .= $this->printDetailsAccSubAcc(12,true); 
                    $return .= $this->printDetailsAccSubAcc(15,true);
                    $return .= $this->printNetOtherIncome(true);
                    $return .= $this->printCloseTable();
                    
                    return $return;
                    
                case 'netIncome':
                    $data = $this->getDataDetails();
                    $this->setData($data);
                    $return = $this->printHeaderDetails();
                    $return .= $this->printDetailsAccSubAcc(11,true); 
                    $return .= $this->printDetailsAccSubAcc(13,true);
                    $return .= $this->printGrossProfit(true);
                    $return .= $this->printDetailsAccSubAcc(14,true);
                    $return .= $this->printNetOperatingIncome(true);
                    $return .= $this->printDetailsAccSubAcc(12,true);
                    $return .= $this->printDetailsAccSubAcc(15,true);
                    $return .= $this->printNetOtherIncome(true);
                    $return .= $this->printNetIncome(true);
                    $return .= $this->printCloseTable();       
                    
                    return $return;
            }
        }
        
        private function printHeaderDetails(){           
            return $string = "<table class='rpt-list-details'>"
                    . "<thead>"
                    . "<th>Fecha</th>"
                    . "<th>Operacion</th>"
                    . "<th>Numero</th>"
                    . "<th>Cuenta</th>"
                    . "<th>Monto</th>"
                    . "<th>Balance</th>"
                    . "</thead>";
        }
        
        private function printCloseTable(){
            return "</table>";
        }
        
        private function printTotalCategoriaDetalles($idCategoria){
            $total = $this->_totalCategoria;
            $this->_categorias[$idCategoria]['total'] = $total;
            $this->_totalCategoria = 0;
            $this->_stringPrintCuentas .= "<tr>"
                                    . "<td colspan='4' class='subheader-table'>Total {$this->_categorias[$idCategoria]['nombre']}</td>"
                                    . "<td class='pl-totales pl-totales-cuentas width-totales'>{$this->printTotalFormat($total)}</td><td></td></tr>";          
        }
        
        private function printDetailsAccSubAcc($idCategoria,$printTitleCategoria = null){            
            foreach ($this->_cuentasParent as $cuenta){
                $this->_dataGroupByIdCuenta[$cuenta['idCuenta']] = array(
                    'cuentaNombre'=>$cuenta['cuenta'],
                    'data'=>array(),
                );
            }           
             
            foreach($this->_detalles as $cuenta){
                $this->_dataGroupByIdCuenta[$cuenta['idCuenta']]['cuentaNombre'] = $cuenta['cuenta'];
                $this->_dataGroupByIdCuenta[$cuenta['idCuenta']]['data'][] = $cuenta;
            }                        
             
            $this->_stringPrintCuentas = '';
            if($printTitleCategoria){
               $categoriaName = $this->_categorias[$idCategoria]['nombre'];    
               $this->_stringPrintCuentas .="<tr><td colspan='6' class='subheader-table'>{$categoriaName}</td></tr>";
            }
            
            foreach($this->_cuentasParent as $cuenta){ 
                if($cuenta['idCategoria'] == $idCategoria){
                    $this->printDetailsRecursive($cuenta['idCuenta']);
                }
            }                          
            
            if($printTitleCategoria){
                $this->printTotalCategoriaDetalles($idCategoria);
                $categoria = $this->_categorias[$idCategoria];

                if($categoria['total'] != 0){
                     return $this->_stringPrintCuentas;
                }
                return;
            }            
           return $this->_stringPrintCuentas;                       
        }
        
        private function printDetailsRecursive($idCuenta){            
            if(isset($this->_dataGroupByIdCuenta[$idCuenta])){
                $cuenta = $this->_dataGroupByIdCuenta[$idCuenta];                
                $this->_stringPrintCuentas .= "<tr><td colspan='6' class='subheader-table'>{$cuenta['cuentaNombre']}</td></tr>";
                $balance = 0;
                $this->_totalCuentaTemp = 0;
                if(count($cuenta['data']) > 0){                    
                    foreach($cuenta['data'] as $key => $data){
                        $balance += $data['balance'];
                        $this->_stringPrintCuentas .= "<tr class='a-cursor-pointer' onclick=\"window.open('/Controller/{$data['controller']}', 'Operation', 'location=yes,resizable=yes,scrollbars=yes,status=yes')\">";
                        $this->_stringPrintCuentas .= "<td>{$data['fecha']}</td>";
                        $this->_stringPrintCuentas .= "<td>{$data['transaccion']}</td>";
                        $this->_stringPrintCuentas .= "<td>{$data['idTransaccion']}</td>";
                        $this->_stringPrintCuentas .= "<td>{$data['cuenta']}</td>";
                        $this->_stringPrintCuentas .= "<td class='pl-totales width-totales'>{$this->printTotalFormat($data['balance'])}</td>";
                        $this->_stringPrintCuentas .= "<td class='pl-totales width-totales'>{$this->printTotalFormat($balance)}</td>";
                        $this->_stringPrintCuentas .= "</tr>";
                    }

                    $this->_stringPrintCuentas .= "<tr>"
                            . "<td colspan='4' class='subheader-table'>Total {$cuenta['cuentaNombre']}</td>"
                            . "<td class='pl-totales pl-totales-cuentas width-totales'>{$this->printTotalFormat($balance)}</td><td></td></tr>";          
                } 
                
                if($this->_sumarTotalCuentas){$this->_totalAccSubAcc += $balance;}
                $this->_totalCategoria += $balance; 
            }
            
            if($subCuentas = array_keys($this->_subcuentas, $idCuenta)){                
                $this->_totalAccSubAcc += $balance;
                $this->_sumarTotalCuentas = true;
                $cuentaParent = "Total {$cuenta['cuentaNombre']} and subAccount";
                foreach($subCuentas as $key => $value){
                    $this->printDetailsRecursive($value);
                }
                $this->_sumarTotalCuentas = null;
                $this->_stringPrintCuentas .= "<tr>"
                            . "<td colspan='4' class='subheader-table'>$cuentaParent</td>"
                            . "<td class='pl-totales pl-totales-cuentas width-totales'>{$this->printTotalFormat($this->_totalAccSubAcc)}</td><td></td></tr>";                
                $this->_totalAccSubAcc = 0;                       
            } 
           
            return $this->_stringPrintCuentas;
        }
        
        private function printDetailsAcount(){
            $data = $this->getDataDetails();
            
            $string = "<table class='rpt-list-details'>"
                    . "<thead>"
                    . "<th>Fecha</th>"
                    . "<th>Operacion</th>"
                    . "<th>Numero</th>"
                    . "<th>Cuenta</th>"
                    . "<th>Monto</th>"
                    . "<th>Balance</th>"
                    . "</thead>";
            
            $balance = 0;
            $row = $data[0];
            $cuentaNombre = $row['cuenta'];
            $string .= "<tr><td colspan='6' class='subheader-table'>{$row['cuenta']}</td></tr>";
            
            foreach($data as $row){
                $balance += $row['balance'];
                $string .= "<tr class='a-cursor-pointer' onclick=\"window.open('/Controller/{$row['controller']}', 'Operation', 'location=yes,resizable=yes,scrollbars=yes,status=yes')\">";
                $string .= "<td>{$row['fecha']}</td>";
                $string .= "<td>{$row['transaccion']}</td>";
                $string .= "<td>{$row['idTransaccion']}</td>";
                $string .= "<td>{$row['cuenta']}</td>";
                $string .= "<td class='pl-totales width-totales'>{$this->printTotalFormat($row['balance'])}</td>";
                $string .= "<td class='pl-totales width-totales'>{$this->printTotalFormat($balance)}</td>";
                $string .= "</tr>";
            }
            $string .= "<tr>"
                    . "<td colspan='4' class='subheader-table'>Total {$cuentaNombre}</td>"
                    . "<td class='pl-totales pl-totales-cuentas width-totales'>{$this->printTotalFormat($balance)}</td><td></td></tr>";
                 
            $string .= "</table>";
            
            return $string;
        }   
        
        public function getNetIncome(){
            $this->printCategoria(11);
            $this->printCategoria(13);
            $this->printGrossProfit();
            $this->printCategoria(14);
            $this->printNetOperatingIncome();
            $this->printCategoria(12);
            $this->printCategoria(15);
            $this->printNetOtherIncome();
            $this->printNetIncome();            
             
            $otherIncome = $this->getTotalCategoria(12);
            $otherExpenses = $this->getTotalCategoria(15);
            $netOperatingIncome = $this->getNetOperatingIncome();
            if($otherIncome == 0 && $otherExpenses == 0 && $netOperatingIncome == 0){return null;}
            
            $netOtherIncome = (double)$otherIncome - (double)$otherExpenses;
            $netIncome = (double)$netOperatingIncome + (double)$netOtherIncome;    
            
            return $netIncome;            
        }
        
        private function printTotalFormat($total = null){
            if(is_null($total)){return null;}
            if(is_double($total) || is_scalar($total)){
                return number_format($total,2);
            }
        }
        
                
        public function getDatesToPrint($startDate,$endDate){
            $tools = new Tools();
            $datesAreText = null;
            if(trim($startDate)=='' && trim($endDate)==''){
                $startDate = $this->_getTranslation("Desde el inicio de los tiempos");
                $endDate = strftime('%B %d, %Y',strtotime('now'));
                $datesAreText = true;
            }elseif(trim($startDate)=='' && trim($endDate)!=''){
                $startDate = $endDate;
            }elseif(trim($startDate)!='' && trim($endDate)==''){
                $endDate = $startDate;
            }
            
            if($datesAreText===null){
                $startDate = $tools->setFormatDateToDB($startDate);
                $startDate = strftime('%B %d, %Y',strtotime($startDate));
                $endDate = $tools->setFormatDateToDB($endDate);
                $endDate = strftime('%B %d, %Y',strtotime($endDate));
            }
            
            return array('startDate'=>$startDate,'endDate'=>$endDate);
        }
    }