<?php $controller = 'Pos';
    $action = 'print';
    include $_SERVER["DOCUMENT_ROOT"].'/app/include/bootstrap.php';?>
<!DOCTYPE html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width,initial-scale=1.0,minimum-scale=1.0,maximum-scale=1.0,user-scalable=no">
    <link href="<?php echo ROOT_HOST?>/public/bootstrap/css/bootstrap.min.css" rel="stylesheet">     
</head>
<body>
    
    <?php
    # INFORMACION EMPRESA
    $empresa = new EmpresaEntity();
    $empresa->setOptions($empresa->getById(1)); 
    
    $nombreEmpresa  = $empresa->getNombre();
    $direccion      = $empresa->getDireccion();
    $ciudadEstadoZC = $empresa->getCiudad().', '.$empresa->getEstado().' '.$empresa->getCodigoPostal();
    $telefono       = $empresa->getTelefono();  
    $paginaWeb      = $empresa->getPaginaWeb();
    
    # INFORMACION VENTA
    $entityVenta = new VentaEntity();
    
    if(isset($_GET['id'])){
        $idVenta = $_GET['id'];    
    }
    
    
    
    $options = $entityVenta->getById($idVenta);
    if($options == null){ 
        $entityVenta->flashmessenger->addMessage(array('danger'=>'Uppss. Venta no registrada.'));
        $msg = $entityVenta->flashmessenger->getMessageString();
        echo "<script>window.parent.$('#flashmessenger').html(\"{$msg}\");fadeOutAlert();</script>";
        exit;
    }
       
    $entityVenta->setOptions($options);
    $entityVenta->setId($idVenta);    
    $numVenta = $entityVenta->getNumVenta();
    
    $SucursalRepository = new SucursalRepository();
    $SucursalRepository->setOptions($SucursalRepository->getById($options['idSucursal']));
    
    $nombreSucursal = $SucursalRepository->getNombre();
    $direccion      = $SucursalRepository->getDireccion();
    $ciudadEstadoZC = $SucursalRepository->getCiudad().', '.$SucursalRepository->getEstado().' '.$SucursalRepository->getCodigoPostal();
    $telefono       = $SucursalRepository->getTelefono();  
    
    /* PARA OBTENER BALANCE DE SpecialRequisition*/
    $isSpecialRequisition = null;
    $specialRequisitionId = $entityVenta->getSpecialRequisitionId();
    if($specialRequisitionId != null & $specialRequisitionId != '0'){
       $isSpecialRequisition = true;
       $repoSR = new SpecialRequisitionRepository();
       $repoSR->setOptions($repoSR->getById($specialRequisitionId));
       $repoSR->setId($specialRequisitionId);
       $balance = "Saldo pendiente: $". number_format($repoSR->getBalance(),2);
       $cliente = $repoSR->getCustomerName();
       $deliveryDate = $repoSR->getFormatDeliveryDate();
    }
    
    $ventaData = $entityVenta->getOptions();
    $cajero = $entityVenta->getUsuarioName();
    $fechaCreacion = strftime('%m/%d/%y %H:%M:%S',strtotime($entityVenta->getFechaCreacion()));
    
    # INFORMACION VENTA DETALLES
    $productoEntity = new ProductoRepository();
    $detalles = $entityVenta->getVentaDetallesSaved($idVenta);
    $listDetalles = "";
    $subtotal = 0;
    $montoTotal = 0;
    $montoImpuestos = 0;
    $descuentoOrdenTotal = 0;
    $itemsTotal = 0;
    
    $repo = new ImpuestosRepository();
    $listaImpuestos = $repo->getInfoImpuestos();
    $impuestosAplicables = array();   
    
    foreach($detalles as $detalle){    
        $itemsTotal += $detalle['cantidad'];
     
        $total = $detalle['cantidad'] * $detalle['precio_sin_impuestos'];
        $subtotal += $total;
        $total -= $detalle['descuento_item_monto'];
        $total -= $detalle['descuento_orden_monto'];

        $descuentoOrdenTotal += $detalle['descuento_item_monto'];
        $descuentoOrdenTotal += $detalle['descuento_orden_monto'];          

        $montoTotal += $total;           
        $montoImpuestos += $detalle['impuestos_monto'];              
       
        $listDetalles .= "<tr>
                        <td class='text-center'>{$detalle['cantidad']}</td>
                        <td>"
                            .ucfirst($detalle['descripcion'].' '.$detalle['tamanoName'])."<br/>"
                            #. "<span style='font-size:12px'>".ucfirst($tamano)."</span>
                        ."</td>
                        <td style='text-align:right'>$".number_format($detalle['precio'],2)."</td>
                        <td style='text-align:right'>$".number_format($total,2)."</td>";
        $listDetalles .= "</tr>";
    }
    
    if($isSpecialRequisition === true){        
        $listDetalles .="<tr><td></td><td>Customer: $cliente</td><td></td>";
        $listDetalles .="<tr><td></td><td>Delivery date: $deliveryDate</td><td></td>";
        $listDetalles .="<tr><td></td><td>$balance</td><td></td>";
    }
    
    $subtotalMenosDescuento =  number_format(round($subtotal - $descuentoOrdenTotal,2,PHP_ROUND_HALF_UP),2); 
    $subtotal = number_format(round($subtotal,2,PHP_ROUND_HALF_UP),2);  
    
    $montoTotalSinFormato = round($montoTotal  + $montoImpuestos,2,PHP_ROUND_HALF_UP);
    $totalRecibido = $ventaData['total_recibido'];
    $cambio = number_format(round($totalRecibido  - $montoTotalSinFormato,2,PHP_ROUND_HALF_UP),2);
   
    $montoTotal = number_format($montoTotalSinFormato,2);
    $totalRecibido = number_format(round($totalRecibido,2,PHP_ROUND_HALF_UP),2);
    
    $descuentoOrdenTotal = number_format(round($descuentoOrdenTotal,2,PHP_ROUND_HALF_UP),2);    
    $montoImpuestos = number_format(round($montoImpuestos,2,PHP_ROUND_HALF_UP),2);    
    
    /*INFORMACION DETALLES PAGO*/
    $detallesPago = $entityVenta->getCobrosDetalleByIdVenta($idVenta);
    $pagos = array();     
    $cardPaymentFlag = NULL;
    
    $translationPaymentMethod = array("Efectivo"=>'Cash','Tarjeta de credito'=>'Credit card','Tarjeta de debito'=>'Debit card','Cheque'=>'Check','EBT'=>'EBT');
    foreach($detallesPago as $detalle){
        if($detalle['formaPago']==6 || $detalle['formaPago']==5){
            //Si es true significa que el pago fue realizado con tarjeta de debito y credito.
            $cardPaymentFlag = true;
        }
        $forma = $translationPaymentMethod[$detalle['formaPagoName']];
        $forma .= " ".$detalle['last_4'];
        $monto = number_format(round($detalle['monto'],2,PHP_ROUND_HALF_UP),2); 
        
        $pagos[] = array(
            'forma'=>$forma,
            'monto'=>$monto
        );
    }
    ?>
        <div id="printArea" style="margin:auto;width: 80mm;font-size: 14px">
        <div style="margin:auto;font-size: 10px;font-family: Arial,Helvetica Neue,Helvetica,sans-serif">
        <div style="text-align: center">
            <div style="margin: 30px;margin-bottom: 10px">
                <img src="../../public/img/logo_login.png" width="50%">
            </div>            
            <h4 style="margin-bottom:0px"><?php echo $nombreEmpresa;?></h4>  
            <p style="margin:0px;"><?php echo $nombreSucursal; ?></p>
            <p style="margin:0px;"><?php echo $direccion; ?></p>
            <p style="margin:0px;"><?php echo $ciudadEstadoZC; ?></p>
            <p style="margin:0px;"><?php echo $telefono;?></p>
            <br/>
        </div> 
        <div>    
            <p style="margin:0px;"><?php echo $_translator->_getTranslation('Sale')?> #: <?php echo $numVenta?></p>
            <p style="margin:0px;"><?php echo $_translator->_getTranslation('Date')?>: <?php echo $fechaCreacion;?></p>
            <p style="margin:0px;"><?php echo $_translator->_getTranslation('Store')?>: <?php echo $nombreSucursal?></p>
            <p style="margin:0px;"><?php echo $_translator->_getTranslation('Cashier')?>: <?php echo $cajero?></p>            
            <p style="margin:0px;"><?php echo $_translator->_getTranslation('Items')?>: <?php echo $itemsTotal;?></p>
        </div> 
        <style>.table > tbody > tr > td, .table > tbody > tr > th, .table > tfoot > tr > td, .table > tfoot > tr > th, .table > thead > tr > td, .table > thead > tr > th{padding:2px; font-size: 12px}</style>
        <table class="m-t-1 table table-condensed tableTicket">
        <thead>
            <th style="width:10%"><?php echo $_translator->_getTranslation('Qty')?></th>
            <th style="width:50%"><?php echo $_translator->_getTranslation('Price')?></th>
            <th style="width:15%"><?php echo $_translator->_getTranslation('Description')?></th>
            <th style="width:25%;text-align: right">Total</th>
        </thead>
        <tbody>
        <?php echo $listDetalles;?>
        <tr style="border: 1px solid #f3f3f3"></tr>        
        <tr>
            <td colspan="3" style="border:0px;text-align: right;margin:0px;padding:0px"><?php echo $_translator->_getTranslation('Subtotal')?></td>
            <td style="border:0px;text-align: right;margin:0px;padding:0px">$ <?php echo $subtotal?></td>
        </tr>        
       <?php if($descuentoOrdenTotal != '0'){?>
        <tr>
            <td colspan="3" style="border:0px;text-align: right;margin:0px;padding:0px"><?php echo $_translator->_getTranslation('Discount')?></td>
            <td style="border:0px;text-align: right;margin:0px;padding:0px">$ <?php echo $descuentoOrdenTotal?></td>
        </tr>
        <tr>
            <td colspan="3" style="border:0px;text-align: right;margin:0px;padding:0px"><?php echo $_translator->_getTranslation('Subtotal')?></td>
            <td style="border:0px;text-align: right;margin:0px;padding:0px">$ <?php echo $subtotalMenosDescuento; ?></td>
        </tr>
        <?php }?>
         <tr style="border:0px">
            <td colspan="3" style="border:0px;text-align: right;margin:0px;padding:0px"><?php echo $_translator->_getTranslation('Tax')?></td>
            <td style="border:0px;text-align: right;margin:0px;padding:0px">$ <?php echo number_format(round($montoImpuestos,2,PHP_ROUND_HALF_UP),2);?></td>
        </tr>
        
        <tr style="border:0px;">
            <td colspan="3" style="border:0px;text-align: right;margin:0px;padding:0px"><b><?php echo $_translator->_getTranslation('Total due')?></b></td>
            <td style="border:0px;text-align: right;margin:0px;padding:0px"><b>$ <?php echo $montoTotal?></b></td>
        </tr>
        <tr style="border:0px;">
            <td colspan="3" style="border:0px;text-align: right;margin:0px;padding:0px"><b><?php echo $_translator->_getTranslation('Payment')?></b></td>
            <td style="border:0px;text-align: right;margin:0px;padding:0px"><b>$ <?php echo $totalRecibido;?></b></td>
        </tr>
        <tr style="border:0px;">
            <td colspan="3" style="border:0px;text-align: right;margin:0px;padding:0px"><b><?php echo $_translator->_getTranslation('Change due')?></b></td>
            <td style="border:0px;text-align: right;margin:0px;padding:0px"><b>$ <?php echo $cambio ?></b></td>
        </tr>
        <tr>
            <td colspan="3" style="border:0px;text-align: right;margin:0px;padding:0px"><?php echo $_translator->_getTranslation('Payment method')?></td>
        </tr>
        <?php            
            foreach($pagos as $pago ){?>
        <tr>
            <td colspan="3" style="border:0px;text-align: right;margin:0px;padding:0px"><?php echo $pago['forma'];?></td>
            <td style="border:0px;text-align: right;margin:0px;padding:0px">$ <?php echo $pago['monto'];?></td>
        </tr>
        <?php }?>
        </tbody>
    </table> 
    <div style="text-align: center"></td>
        </tr>
        </tbody>
        <p>Our products do not contain preservatives; consume within 36 hours of purchasing.</p>
        <p>Once product has left the store, it can not be returned or exchanged.</p>
        <p>Changes and cancellations on special orders must be requested 72 hours before date of delivery.</p>
        
        <p style="margin:0px">Thank you for visiting</p>
        <p style="margin:0px">Have a nice day</p>
    </div>              
    <br/>
    </div>
    </div>

</body>
</html>