<?php 
    $controller = 'POS';
    $action = 'print';
    include $_SERVER["DOCUMENT_ROOT"].'/app/include/bootstrap.php';?>
<!DOCTYPE html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width,initial-scale=1.0,minimum-scale=1.0,maximum-scale=1.0,user-scalable=no">
    <link href="<?php echo ROOT_HOST?>/public/bootstrap/css/bootstrap.min.css" rel="stylesheet">  
    <script src="<?php echo ROOT_HOST?>/public/js/funciones.js"></script>  
</head>
<body>
    <iframe name="print_frame" width="100%" height="200px" frameborder="0" src="about:blank"></iframe>
    <?php
    /* INFORMACION EMPRESA */
    $empresa = new EmpresaEntity();
    $empresa->setOptions($empresa->getById(1)); 
    
    $nombreEmpresa  = $empresa->getNombre();
    $direccion      = $empresa->getDireccion();
    $ciudadEstadoZC = $empresa->getCiudad().', '.$empresa->getEstado().' '.$empresa->getCodigoPostal();
    $telefono       = $empresa->getTelefono();  
    
    /* INFORMACION DEVOLUCION */
    $idDevolucion = $_GET['idDevolucion'];
    $devolucionEntity = new DevolucionEntity();
    $venta = $devolucionEntity->setOptions($devolucionEntity->getById($idDevolucion));
    $devolucionEntity->setId($idDevolucion);
    $ventaData = $devolucionEntity->getOptions();
    $cajero = $devolucionEntity->getUsuarioName();
    $fechaCreacion = strftime('%m/%d/%y %H:%M:%S',strtotime($devolucionEntity->getFechaCreacion()));

    /* INFORMACION DEVOLUCION DETALLES */
    $devolucionesDetalles = $devolucionEntity->getDevolucionDetalles();
    $montoTotal = 0;
    
    $stringListDetalles = null;
    foreach($devolucionesDetalles as $detalle){
             $item = $detalle['descripcion'];             
             $totalItemUnitario = number_format(round($detalle['montoUnitario'],2,PHP_ROUND_HALF_UP),2);
             $totalItem = number_format(round($totalItemUnitario * $detalle['cantidad'],2,PHP_ROUND_HALF_UP),2);
             $montoTotal += $totalItem;
             $stringListDetalles .= "<tr>"
                     . "<td>{$detalle['cantidad']}</td>"
                     . "<td>{$item}</td>"
                     . "<td style='text-align:right'>".$totalItemUnitario."</td>"
                     . "<td style='text-align:right'>".$totalItem."</td>"
                     . "</tr>";
    }
    
    /*INFORMACION DETALLES PAGO*/
    $detallesPago = $devolucionEntity->getPagosDetalleByIdDevolucion($idDevolucion);
    $pagos = array();     
    $cardPaymentFlag = NULL;
    foreach($detallesPago as $detalle){
        if($detalle['formaPago']==6 || $detalle['formaPago']==5){
            //Si es true significa que el pago fue realizado con tarjeta de debito y credito.
            $cardPaymentFlag = true;
        }
        $forma = $_translator->_getTranslation($detalle['formaPagoName']);
        $forma = str_pad($forma." ".substr($detalle['numDocumento'],-4), 16, " ", STR_PAD_RIGHT);

        $monto = number_format($detalle['monto'],2);             
        $monto = str_pad($monto, 11, " ", STR_PAD_LEFT);
        $pagos[] = $forma.$monto;
    }
?>
    <div id="cashier">
        <div style="margin:auto;font-size: 10px;font-family: Arial,Helvetica Neue,Helvetica,sans-serif">
            <div style="text-align: center">
                <h3 style='font-size: 24px'><?php echo $nombreEmpresa;?></h3>
                <p style="margin:0"><?php echo $direccion; ?></p>
                <p style="margin:0"><?php echo $ciudadEstadoZC; ?></p>
                <p style="margin:0"><?php echo $telefono;?></p>
            </div> 
            <div class="text-left m-t-1">            
                <p style="margin:0">Refund #: <?php echo $idDevolucion;?></p>
                <p style="margin:0">Date: <?php echo $fechaCreacion;?></p>
                <p style="margin:0">Cashier: <?php echo $cajero;?></p>
            </div> 
            <table style="width:100%;font-size: 10px;margin-top:1rem;margin-bottom:20px;border-collapse:collapse;border-spacing:0px">
            <thead>
                <th style="width:10%">Qty</th>
                <th style="width:55%">Description</th>
                <th style="width:15%">Unit</th>
                <th style="width:20%;text-align: right">Total</th>
            </thead>
            <tbody>
            <?php echo $stringListDetalles;?>
            <tr style="border: 1px solid #f3f3f3"></tr>
            <tr style="border:0px">
                <td colspan="3" style="border:0px;text-align:right"><b>Total</b></td>
                <td style="border:0px;text-align:right"><b>$ <?php echo $montoTotal?></b></td>
            </tr>
             <?php
                foreach($detallesPago as $pago ){?>
            <tr>
                <td colspan="3" style="border:0px;text-align:right"><?php echo $_translator->_getTranslation($pago['formaPagoName'])." ".$pago['numDocumento'];?></td>
                <td style="border:0px;text-align:right">$ <?php echo $pago['monto'];?></td>
            </tr>
            <?php }?>
            </tbody>
        </table>
        <div style="text-align: center">    
            <p style="margin:0">________________________</p>
            <p style="margin:0"> Customer sign</p>
            <p style="margin:0;margin-top:5px"> You will be getting your refund<br/> after 3 or 5 days.</p>
        </div>
        <div style="text-align: center;margin-top:10px">
            <p style="margin:0">Thank you for your coming.</p>
            <p style="margin:0">We hope you'll visit again.</p>
            <p style="margin-top:1rem">****** Cashier copy ******</p>
        </div> 
        </div>
    </div>
    
    <div id="customer">
        <div style="margin:auto;font-size: 10px;font-family: Arial,Helvetica Neue,Helvetica,sans-serif">
            <div style="text-align: center">
                <h3 style='font-size: 24px'><?php echo $nombreEmpresa;?></h3>
                <p style="margin:0"><?php echo $direccion; ?></p>
                <p style="margin:0"><?php echo $ciudadEstadoZC; ?></p>
                <p style="margin:0"><?php echo $telefono;?></p>
            </div> 
            <div class="text-left m-t-1">            
                <p style="margin:0">Refund #: <?php echo $idDevolucion;?></p>
                <p style="margin:0">Date: <?php echo $fechaCreacion;?></p>
                <p style="margin:0">Cashier: <?php echo $cajero;?></p>
            </div> 
            <table style="width:100%;font-size: 10px;margin-top:1rem;margin-bottom:20px;border-collapse:collapse;border-spacing:0px">
            <thead>
               <th style="width:10%">Qty</th>
               <th style="width:55%">Description</th>
               <th style="width:15%">Unit</th>
               <th style="width:20%;text-align: right">Total</th>
            </thead>
            <tbody>
            <tr style="border:0px">
                <td colspan="3" style="border:0px;text-align:right"><b>Total</b></td>
                <td style="border:0px;text-align:right"><b>$ <?php echo $montoTotal?></b></td>
            </tr>
             <?php
                foreach($detallesPago as $pago ){?>
            <tr>
                <td colspan="3" style="border:0px;text-align:right"><?php echo $_translator->_getTranslation($pago['formaPagoName'])." ".$pago['numDocumento'];?></td>
                <td style="border:0px;text-align:right">$ <?php echo $pago['monto'];?></td>
            </tr>
            <?php }?>
            </tbody>
        </table>
        <div style="text-align: center">    
            <p style="margin:0"> You will be getting your refund<br/> after 3 or 5 days.</p>
        </div>
        <div style="text-align: center;margin-top:10px">
            <p style="margin:0">Thank you for your coming.</p>
            <p style="margin:0">We hope you'll visit again.</p>
            <p style="margin-top:1rem">****** Customer copy ******</p>
        </div> 
        </div>
    </div>
    <script type="text/javascript">  
        //printDivCSS = new String ();
        
        function print(ticket){
            window.frames["print_frame"].document.body.innerHTML = document.getElementById(ticket).innerHTML;
            window.frames["print_frame"].window.focus();
            window.frames["print_frame"].window.print();
        }
        
        print('cashier');
        setTimeout("print('customer')",300);
    </script>
</body>
</html>