<?php
    
    $arrayData = $data['data'];
    reset($arrayData);
    $firstKey = key($arrayData);
    $colTitulosTemp = $arrayData[$firstKey];
    
    $fieldsToPrint = array(
        'sucursalName'=>'Sucursal',
        'num_venta'=>'Venta',
        'fecha'=>'Fecha',
        'hora'=>'Hora',
        'formaPagoConcat'=>'Forma de pago',
        'last4Concat'=>'Tarjeta',
        'monto_con_fp'=>'Monto con FP',
        'subTotal'=>'Subtotal',
        'descuento'=>'Descuento',
        'impuestos'=>'Impuestos',
        'total_venta'=>'Total',
        'statusName'=>'Status'
    );
    
    foreach($fieldsToPrint as $titulo => $value){
        if(key_exists($titulo, $colTitulosTemp)){            
            $colTitulos[] = $fieldsToPrint[$titulo];
        }
    }

    $objPHPExcel = new PHPExcel();
    $objPHPExcel->getActiveSheet()->freezePane('A3');
    $col = count($colTitulos);
    $lastCol = $this->getColLetter($col-1);
    
    $objPHPExcel->getActiveSheet()->mergeCells("A1:".$lastCol."1");            
    $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(50);
    $objPHPExcel->getActiveSheet()->getStyle("A1")->getFont()->setBold(true);
    $objPHPExcel->getActiveSheet()->setCellValue("A1", $this->headerExcelReport);
    $objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setWrapText(true);
    $objPHPExcel->getActiveSheet()->getStyle("A1")->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    $objPHPExcel->getActiveSheet()->getStyle("A1")->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
   
    $objPHPExcel->getActiveSheet()->getStyle("A2:".$lastCol."2")->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    $objPHPExcel->getActiveSheet()->fromArray($colTitulos,NULL,'A2');   
    
    $row=3;
    foreach ($arrayData as $key => $data) {
        $i=0;      
        foreach ($fieldsToPrint as $col => $value) {             
            if(key_exists($col, $data)){ 
                $colLetter = $this->getColLetter($i);
                $objPHPExcel->getActiveSheet()->setCellValue($colLetter . $row, $data[$col]);
                //$objPHPExcel->getActiveSheet()->getStyle("A$row:D$row")->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
                //$objPHPExcel->getActiveSheet()->getStyle("C$row:H$row")->getNumberFormat()->setFormatCode('$#,##0.00_ ;[Red]-$#,##0.00');
                $i++;
            }
        }
        $row++;
    }
    
     $objPHPExcel->setActiveSheetIndex(0);   
    $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
    
    if($this->saveFile == true){
        $objWriter->save($this->getTempFolder()."/".$this->getNombreArchivo().".xlsx");
    }else{                
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header("Content-Disposition: attachment;filename=".$this->getNombreArchivo().".xlsx");
        header('Cache-Control: max-age=0');
        $objWriter->save('php://output');
        exit;
    }
    unset($objWriter);

    foreach(range('A',$lastCol) as $columnID) {
        $objPHPExcel->getActiveSheet()->getColumnDimension($columnID)
            ->setAutoSize(true);
    }

    $objPHPExcel->setActiveSheetIndex(0);   
    $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
    
    if($this->saveFile == true){
        $objWriter->save($this->getTempFolder()."/".$this->getNombreArchivo().".xlsx");
    }else{                
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header("Content-Disposition: attachment;filename=".$this->getNombreArchivo().".xlsx");
        header('Cache-Control: max-age=0');
        $objWriter->save('php://output');
        exit;
    }
    unset($objWriter);