<?php
class WasteForm extends Form {

    public function __construct() {
        $this->setActionForm('Waste.php');
        $this->setClass('waste');
        $this->setMethod('post');
        $this->setDefaultFormLabelsColSize(4);
        $this->setDefaultFormElementsColSize(8);
        parent::__construct();
        $this->init();
    }

    public function init() {
        $this->addElement(array(
            'type' => 'text',
            'name' => 'date',
            'label'=>'Fecha',
            'required'=> true,
        ));
        
         $append = "<div class='input-group-btn descuento_tipo'>
                    <select class='form-control' id='um' name='um' style='width:90px'>                    
                      <option value='lbs'>LBS</option>
                      <option value='pza'>PIEZA</option>
                    </select>
                  </div>";
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'quantity',
            'label'=>'Cantidad',
            'class'=>'mg_decimal',
            'append'=>$append,
            'required'=>true
        ));
        
        $this->addElement(array(
            'type' => 'textarea',
            'name' => 'reason',
            'label'=>'Motivo',
            'required'=>true
        ));
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'send',
            'value'=> $this->_getTranslation('Terminar'),
            'optionals'=>array(
                'onclick'=>"submit()"),
            'class'=>'btn btn-primary m-t-1 m-b-1'
        ));
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'cancelar',
            'value'=> $this->_getTranslation('Cancelar'),
            'optionals'=>array(
            'onclick'=>"document.location = '".ROOT_HOST."/Controller/Waste.php'"),
            'class'=>'btn btn-danger m-t-1 m-b-1'
        ));
    }
    
    public function populate($data){
        $tools = new Tools();
        if(isset($data['date']) && $tools->isValidaDateYYYMMDD($data['date'])){
            $data['date'] = $tools->setFormatDateToForm($data['date']);
        }   
        
        parent::populate($data);
    }
}