<?php
/**
 * Description of UsuarioForm
 *
 * @author carlos
 */

class UsuarioForm extends Form {

    public function __construct() {
        $this->setActionForm('User.php');
        $this->setClass('usuario');
        $this->setMethod('post');
        parent::__construct();
        $this->init();
    }

    public function init() {
        $this->addElement(array(
            'type' => 'text',
            'name' => 'usuario',
            'label'=>'Usuario',
            'required'=> true
        ));

        $this->addElement(array(
            'type' => 'password',
            'name' => 'contrasena',
            'Password'=>'password',
            'label'=>'Contrasena',
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'password',
            'name' => 'nip',
            'label'=>'NIP',
            'required'=> false,
            'optionals'=>array('maxlength'=>'5','size'=>'5')
        ));        
        
         $this->addElement(array(
            'type' => 'text',
            'name' => 'confirmar_nip',
            'label'=>'Confirmar NIP',
            'required'=> false,
             'optionals'=>array('maxlength'=>'5','size'=>'5')
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'nombre',
            'label'=>'Nombre',
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'apellido',
            'label'=>'Apellido',
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'role',
            'label'=>'Role',
            'multiOptions' => $this->getListRoles(),
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'select multiple',
            'name' => 'sucursal',
            'label'=>'Sucursal',
            'multiOptions' => $this->getListSucursales(),
            'value'=>'',
            'required'=> true
        ));
        
         $this->addElement(array(
            'type' => 'select',
            'name' => 'acceso_movil',
            'label'=>'Acceso movil',
            'multiOptions' => array('1'=>'Si','0'=>'No'),
            'value'=>1,
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'status',
            'label'=>'Status',
            'multiOptions' => $this->getListStatus(),
            'required'=> true
        ));
        
        $this->addElement(array(
            'type'=>'submit',
            'name'=>'send',
            'value'=>$this->_getTranslation('Terminar'),
            'class'=>'btn btn-primary'
        ));
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'cancelar',
            'value'=> $this->_getTranslation('Cancelar'),
            'optionals'=>array(
                'onclick'=>"document.location = '".ROOT_HOST."/Controller/User.php'"),
            'class'=>'btn btn-danger m-t-1 m-b-1'
        ));
    }
    
    public function getListRoles(){
        $repository = new UsuarioRepository();
        $list = $repository->getListRoles();
         
        $array = array();
        foreach($list as $key => $value){
            $array[$key] = $value;
        }
        return $array;
    }
    
    public function getListSucursales(){
        $repository = new SucursalRepository();
        $list = $repository->getListSelectSucursales();
         
        $array = array();
        foreach($list as $key => $value){
            $array[$key] = $value;
        }
        return $array;            
    }
    
    public function getListStatus(){
        $repository = new UsuarioRepository();
        $list = $repository->getListStatus();
         
        $array = array();
        if($list){
            foreach($list as $key => $value){
                $array[$key] = $value;
            }
        }
        
        return $array;
            
    }
    
    public function populate($data){
        if(isset($data['sucursal']) && $data['sucursal']!=null && is_array($data['sucursal'])){
            $sucursales = array();
            foreach($data['sucursal'] as $sucursal){
                $sucursales[$sucursal] = $sucursal;
            }
            $data['sucursal'] = $sucursales;
        }
        parent::populate($data);
    }
    
    public function setEditForm(){
        $this->noRequired(array('contrasena'));
        $this->noRequired(array('nip'));
    }
    
    public function isValid() {
        $rs = parent::isValid();
        
        if($rs){           
            $nip = $this->getValueElement('nip');            
            /*
            $confirmar_nip = $this->getValueElement('confirmar_nip');
            
            if(strtolower($nip) !== strtolower($confirmar_nip)){
                $flasmessenger = new FlashMessenger();
                $flasmessenger->addMessage(array('danger'=>'NIP ingreados no coinciden.'));
                return null;
            }*/
            if(trim($nip) !=='' && (trim($nip)) !== null){
                 $repoUser = new UsuarioRepository();            
                if($repoUser->existNIP(array('nip'=>$nip,'id'=>$this->getId()))){
                    $flashmessenger = new FlashMessenger();
                    $flashmessenger->addMessage(array('danger'=>'NIP ingresado ya esta siendo utilizado, intente nuevamente.'));
                    return null;
                }
            }
           
        }
        
        return $rs;
    }
}