<?php
/**
 * Description of LoginForm
 * @author carlos augusto vazquez lara
 */
class ReporteForm extends Form {
    public function __construct() {
        $this->setActionForm('Reports.php');
        $this->setActionController('create');
        $this->setName('reportes');
        $this->setMethod('post');
        $this->setClass('form-horizontal');
        parent::__construct();
        $this->init();
        
    }

    public function init() {
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'reporte',
            'required'=>true
        ));   
          
        
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'optionsFromGet',
            'required'=>true
        ));   
        
        $attributes_wrapper_append_date = array('class'=>'date','id'=>'fechaDatePicker');
        $append = "<span class = 'btn input-group-addon'><i class='fa fa-calendar'></i></span>";
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'fechaInicio',
            'label'=>'Fecha inicio',
            'required'=>false,
            'append'=>$append,
            'wrapper_attributes'=>$attributes_wrapper_append_date
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'fechaFin',
            'label'=>'Fecha fin',
            'required'=>false,
            'append'=>$append,
            'wrapper_attributes'=>$attributes_wrapper_append_date
        ));
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'output',
            'label'=>'Bajar reporte',
            //'multiOptions'=>array('excel'=>'Excel','pdf'=>'PDF'),
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'select multiple',
            'name' => 'id_user',
            'label'=>'Usuario',
            'multiOptions' => $this->getListUsuarios(),
            'required'=> true,
        ));   
         
        $this->addElement(array(
            'type' => 'select multiple',
            'name' => 'forma_pago',
            'label'=>'Forma de pago',
            'multiOptions' => $this->getListaFormasDePago(),
            'required'=> true,
        )); 
        
        $this->addElement(array(
            'type' => 'select multiple',
            'name' => 'store_id',
            'label'=>'Sucursal',
            'multiOptions' => $this->getListSucursales(),
            'value'=>'',
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'status',
            'label'=>'Status',
            'multiOptions' => array('2'=>'Pagadas','3'=>'Canceladas','null'=>'Todas'),
            'required'=> true,
        )); 
        
        $this->addElement(array(
            'type'=>'submit',
            'name'=>'enviar',
            'value'=>'Enviar',
            'class'=>'btn btn-lg btn-primary'
        ));
        
        $this->addElement(array(
            'type' => 'select multiple',
            'name' => 'to',
            'label'=>'Para',
            'multiOptions'=>array(
                'factsuc1@lospastelescaserosdegaby.com'=>'factsuc1@lospastelescaserosdegaby.com',
                'admin1@lospastelescaserosdegaby.com'=>'admin1@lospastelescaserosdegaby.com',
                'admin2@lospastelescaserosdegaby.com'=>'admin2@lospastelescaserosdegaby.com',
                'gerencia@lospastelescaserosdegaby.com'=>'gerencia@lospastelescaserosdegaby.com',
                'pasteles.gaby@yahoo.com'=>'pasteles.gaby@yahoo.com'  
                ),
            'optionals'=>array('style'=>'width:350px;')
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'cc',
            'label'=>'Copia',
            'optionals'=>array('style'=>'width:350px;')
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'subject',
            'label'=>'Titulo',
            'optionals'=>array('style'=>'width:350px;')
        ));
        
        $this->addElement(array(
            'type' => 'textarea',
            'name' => 'message',
            'label'=>'Mensaje',
            'optionals'=>array('style'=>'width:350px;height:100px')
        ));
        
        $this->addElement(array(
            'type'=>'button',
            'name'=>'sendMail',
            'label'=>'',
            'value'=>$this->_getTranslation('Enviar mail'),
            'class'=>'btn btn-primary',
            'optionals'=>array('onclick'=>'sendReportToMail()')
        ));
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'cerrar',
            'value'=> $this->_getTranslation('Cerrar'),
            'class'=>'btn btn-default btn-lg',
            'optionals'=>array(
                'data-dismiss'=>'modal',
                'aria-hidden'=>'true',
                ),
            'col-size-element'=>'12',
        ));
    }
    
     public function getListUsuarios(){
        $repository = new UsuarioRepository();
        $list = $repository->getListaSelectUsuarios();
         
        $array = array(''=>''); #Para poder aplicar "placeholder"  en select2 en vista
        foreach($list as $key => $value){
            $array[$key] = $value;
        }
        return $array;
    }
    
    public function getListaFormasDePago(){
        $repository = new FormaMetodoPagoRepository();
        $result = $repository->getListSelectFormasPago();
        
        $array = array('' => '');
        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
        }
        return $array;
    }
    
     public function getListSucursales(){
        $repository = new SucursalRepository();
        $list = $repository->getListSelectSucursales();
         
        $array = array();
        foreach($list as $key => $value){
            $array[$key] = $value;
        }
        return $array;            
    }
    
     public function getStringFiltersForm($report){
        $formString = '';
        switch($report){            
            case 'ventasPorFecha':
            case 'ventasDetalles':
                $this->setPropiedad('output', array('multiOptions'=>array('pantalla'=>'Pantalla')));
                
                $formString .= $this->getElementString('store_id');
                $formString .= $this->getElementString('fechaInicio');
                $formString .= $this->getElementString('fechaFin');
                $formString .= $this->getElementString('forma_pago');
                $formString .= $this->getElementString('status');
                $formString .= $this->getElementString('output');             
                
                break;
            
            case 'ventas_por_producto':
                $this->setPropiedad('output', array('multiOptions'=>array('pantalla'=>'Pantalla')));
                
                $formString .= $this->getElementString('store_id');
                $formString .= $this->getElementString('fechaInicio');
                $formString .= $this->getElementString('fechaFin');
                $formString .= $this->getElementString('output');             
                
                break;
            
            case 'ventas_por_producto_en_ordenes_especiales':
            case 'saldosPendientes':
            case 'historial_inventario':
                $this->setPropiedad('output', array('multiOptions'=>array('excel'=>'Excel')));
                
                $formString .= $this->getElementString('store_id');
                $formString .= $this->getElementString('fechaInicio');
                $formString .= $this->getElementString('fechaFin');
                $formString .= $this->getElementString('output');             
                
                break;
            
            case 'time_clock':
                $this->setPropiedad('output', array('multiOptions'=>array('excel'=>'Excel')));
                
                $formString .= $this->getElementString('store_id');
                $formString .= $this->getElementString('fechaInicio');
                $formString .= $this->getElementString('fechaFin');
                $formString .= $this->getElementString('id_user');
                $formString .= $this->getElementString('output');             
                
                break;
            
            /*MOBILE REPORTS*/
            case 'sales_activity':
            case 'transactions':
            case 'time_clock':
                $this->setActionForm('Mobile.php');
                $this->setValueToElement('pantalla', 'output');
                $this->hideElement(array('output'));
                
                $formString .= $this->getElementString('fechaInicio');
                $formString .= $this->getElementString('fechaFin');
                $formString .= $this->getElementString('store_id');
                $formString .= $this->getElementString('output');      
                break;
        }
        
        return $formString;
    }
}