<?php
/**
 * Description of NivelForm
 *
 * @author carlos
 */

class RefundForm extends Form {

    public function __construct() {
        $this->setName('refund');
        $this->setClass('refundform');
        $this->setDefaultFormElementsColSize('8');
        $this->setDefaultFormLabelsColSize('4');
        parent::__construct();
        $this->init();
    }

    public function init() {
        $this->addElement(array(
            'type'=>'hidden',
            'name'=>'charge'
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'amount',
            'label'=>'Reembolso',
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'reason',
            'label'=>'Motivo',
            'multiOptions'=>array(
                'duplicate'=>'Duplicado',
                //'fraudulent'=>'Fraudulento',
                'requested_by_customer'=>'Requerido por cliente'),
            'required'=>true
        ));  
        
        $this->addElement(array(
            'type' => 'textarea',
            'name' => 'comments',
            'label'=>'Comentario',
            'required'=> false
        ));
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'sendRefund',
            'value'=> $this->_getTranslation('Reembolsar'),
            'class'=>'btn btn-primary',
            'col-size-element'=>'12',
        ));
    }
}