<?php
class ProductoForm extends Form {
    
    public function __construct() {
        $this->setActionForm('Product.php');
        $this->setName('producto');
        $this->setEnctype('multipart/form-data');
        $this->setClass('producto form-horizontal');
        $this->setMethod('post');
        $this->setDefaultFormLabelsColSize(4);
        $this->setDefaultFormElementsColSize(8);
        parent::__construct();
        $this->init();
    }

    public function init() {                    
        $this->addElement(array(
            'type' => 'text',
            'name' => 'codigo',
            'label'=>'Codigo',
            'required'=>false
        ));
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'type',
            'label'=>'Tipo',
            'multiOptions'=>array('producto'=>'Producto','servicio'=>'Servicio'),
            'required'=>true
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'descripcion',
            'label'=>'Descripcion',
            'required'=>true
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'nombre_para_pos',
            'label'=>'Nombre para venta',
            'required'=>false
        ));
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'color',
            'label'=>'Color',
            'multiOptions'=>$this->getListColors(),
            'required'=>false,
        ));
       
        $append = "<span class = 'btn input-group-addon' data-toggle='modal' data-target='#modalAgregarPresentacion'><i class='fa fa-plus'></i></span>";
        $this->addElement(array(
            'type' => 'select',
            'name' => 'categoria',
            'label'=>'Categoria',
            'multiOptions'=>$this->listaCategorias('Producto'),
            //'append'=>$append,
            'required'=>true
        ));
        
        $append = "<span class = 'btn input-group-addon' data-toggle='modal' data-target='#modalAgregarPresentacion'><i class='fa fa-plus'></i></span>";
        $this->addElement(array(
            'type' => 'select',
            'name' => 'marca',
            'label'=>'Marca',
            'multiOptions'=>$this->listaMarcas(),
            //'append'=>$append,
            'required'=>false
        ));
        
        $append = "<span class = 'btn input-group-addon' data-toggle='modal' data-target='#modalAgregarPresentacion'><i class='fa fa-plus'></i></span>";
        $this->addElement(array(
            'type' => 'select',
            'name' => 'unidad_de_medida',
            'label'=>'Unidad medida',
            'multiOptions'=>$this->listaUnidadesMedida(),
            //'append'=>$append,
            'required'=>false
        ));        
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'mostrar_en_pos',
            'label'=>'Mostrar en venta',
            'multiOptions'=>array('1'=>'Si','0'=>'No'),
            'value'=>'1',
            'required'=>false,
        ));
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'status',
            'label'=>'Status',
            'multiOptions' => $this->getListStatus(),
            'value'=>'1',
            'required'=> true
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'punitarioventa',
            'label'=>'Precio',
            'validators'=>array('double'),
            'required'=>true
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'descuento',
            'label'=>'Descuento',
            'validators'=>array('double'),
            'required'=>false
        ));        
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'impuestos',
            'label'=>'Impuestos',
            'multiOptions'=>$this->listaImpuestos(),
            'required'=>true
        ));        
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'impuestos_incluidos',
            'label'=>'Impuestos incluidos',
            'multiOptions'=>array('no'=>'No','si'=>'Si'),
            'required'=>true,
        ));
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'aplica_para_ebt',
            'label'=>'Aplica para EBT ?',
            'multiOptions'=>array('1'=>'Si','0'=>'No',''=>'Seleccionar una opcion ...',),
            'value'=>'',
            'required'=>true,
        ));
        
        /*
        $this->addElement(array(
            'type' => 'select',
            'name' => 'venta_solo_para_mayores',
            'label'=>'Venta solo para mayores',
            'multiOptions'=>array('1'=>'Si','0'=>'No'),
            'value'=>'0',
            'required'=>false,
        ));*/
        
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'venta_solo_para_mayores',
            'value'=>'0',
        ));
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'llevar_inventario',
            'label'=>'Llevar inventario',
            'multiOptions'=>array('0'=>'No','1'=>'Si'),
            'required'=>false
        ));     
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'stock_minimo',
            'label'=>'Stock minimo',
            'validators'=>array('double'),
            'required'=>false
        ));  
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'costo',
            'label'=>'Costo',
            'validators'=>array('double'),
            'required'=>false
        ));        
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'impuestos_compra',
            'label'=>'Impuestos',
            'multiOptions'=>$this->listaImpuestos(),
            'required'=>true
        ));        
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'impuestos_incluidos_compra',
            'label'=>'Impuestos incluidos',
            'multiOptions'=>array('no'=>'No','si'=>'Si'),
            'required'=>false,
        ));               
        
        /*
        $this->addElement(array(
            'type' => 'select multiple',
            'name' => 'proveedores',
            'label'=>'Proveedores',
            'multiOptions'=>$this->getListVendors(),
            'required'=>false
        ));         */   
        
        $this->addElement(array(
            'type' => 'file',
            'name' => "imagen",
            'label' => 'Imagen',
            'class' => 'upload',
            'required' => false,
            'optionals' => array(
                'title' => 'Adjuntar imagen de producto'
            ),
        ));
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'send',
            'value'=> $this->_getTranslation('Terminar'),
            'optionals'=>array(
                'onclick'=>"submit()"),
            'class'=>'btn btn-primary m-t-1 m-b-1'
        ));
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'cancel',
            'value'=> $this->_getTranslation('Cancelar'),
            'optionals'=>array(
                'onclick'=>"document.location = '".ROOT_HOST."/Controller/Product.php'"),
            'class'=>'btn btn-danger m-t-1 m-b-1'
        ));
        
         /*Se utiliza para consulta si existe en la tabla de comprasdetalles_X, si existe se actualiza registro.*/
         $this->addElement(array(
            'type' => 'hidden',
            'name' => 'idDetailTemp',
            'required'=>false
        ));               
     
        $this->addElement(array(
            'type' => 'select',
            'name' => 'slice_category',
            'multiOptions'=>$this->listaCategorias('Partes del pastel'),
            'optionals'=>array('onchange'=>'setSliceFlavor()'),
            'col-size-element'=>'12'
        ));
        
        /*key = value  key = id_slice  value = flavorName*/
        $this->addElement(array(
            'type' => 'select',
            'name' => 'slice_id',
            'multiOptions'=>array('0' => 'Seleccionar una opcion...'),
            'col-size-element'=>'12'
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'slice_quantity',
            'optionals'=>array('style'=>'text-align:right'),
            'col-size-element'=>'12'
        ));
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'addSlice',
            'value'=> $this->_getTranslation('Agregar'),
            'optionals'=>array(
                'onclick'=>"setProductDetails()"),
            'class'=>'btn btn-default'
        ));
        
        $this->addElement(array(
            'type'=>'button',
            'name'=>'btn-slices',
            'value'=>$this->_getTranslation('Configurar Partes del pastel'),
            'class'=>'btn btn-default col-md-11 col-xs-11',
            'optionals'=>array('type'=>'button',"onClick"=>"$('#modalProductSlices').modal('show')"),
            'col-size-element'=>'9'
        ));   
    }
    
    public function listaImpuestos(){            
        $repository = new ImpuestosRepository();
        $result = $repository->getListaSelectImpuestos();
        
        $array = array('' => 'Seleccionar una opcion...');
        if ($result) {            
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }
    }   
    
    public function getListColors(){
        $repository = new ProductoRepository();
        $result = $repository->getListSelectColors();
        
        $array = array('0' => array('value'=>'Seleccionar una opcion...','optionals'=>array('data-color'=>'#fff')));
        if ($result){           
            foreach ($result as $key => $value) {
                $valueArray['value'] = $value;
                $valueArray['optionals'] = array("data-color"=>$value);
                $array[$key] = $valueArray;
            }
        //   echo "<pre>";var_dump($array);echo "</pre>";exit;

            return $array;
        }
    }
    
    public function listaCategorias($type){
        $repository = new CategoriaRepository();
        $result = $repository->getListaSelectCategorias($type);
        
        $array = array('' => 'Seleccionar una opcion...');
        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }
    }
    
    public function listaMarcas(){
        $repository = new MarcaRepository();
        $result = $repository->getListaSelectMarcas();
        
         $array = array(0 => 'Seleccionar una opcion...');
        if ($result) {           
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }
    }   
    
    public function getListStatus(){
        $repository = new ProductoRepository();
        $result = $repository->getListStatus();
         
        $array = array();
        foreach($result as $key => $value){
            $array[$key] = $value;
        }
        return $array;        
    }
    
    public function listaPresentaciones(){
        $repository = new PresentacionRepository();
        $result = $repository->getListaSelectPresentaciones();
        
         $array = array(0 => 'Seleccionar una opcion...');
        if ($result) {           
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }
    }   
    
    public function listaUnidadesMedida(){
        $repository = new UnidadMedidaRepository();
        $result = $repository->getListaSelectUnidadesMedida();
        
        $array = array(0 => 'Seleccionar una opcion...');
        if ($result) {            
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }
    }    
    
    public function getListVendors(){ 
        $repository = new ProveedorRepository();
        $result = $repository->getListaSelectProveedores();
        
        $array = array();
        if ($result) {            
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }
    }   
    
    public function getNextIdProduct(){
        $repo = new ProductoRepository();
        $lastId = $repo->getLastIdProduct();
        $nextId = $lastId + 1;
        
        return $nextId;
    }
    
    public function isValid() {
        $valid = parent::isValid();        
        $flashmessenger = new FlashMessenger();                
        
        $idProducto = $this->getId();
        $codigo = $this->getElement('codigo');
        
        $repository = new ProductoRepository();
        $producto = $repository->existeCodigo($codigo['value'],$idProducto);
        if($producto){
            $message  = $this->_getTranslation('Ya se esta utilizando este codigo para el producto: ');
            $message .= $producto['descripcion'].' '.$producto['categoria'].' '.$producto['marca'];
            $flashmessenger->addMessage(array('info'=>$message));
            return null;
        }  
         
        return $valid;
    }
    
    public function populate($data){
        if(isset($data['proveedores']) && $data['proveedores']!=null && is_array($data['proveedores'])){
            $sucursales = array();
            foreach($data['proveedores'] as $sucursal){
                $sucursales[$sucursal] = $sucursal;
            }
            $data['proveedores'] = $sucursales;
        }
        
        parent::populate($data);        
    }
}