<?php
/**
 * Description of NivelForm
 *
 * @author carlos
 */

class EmpresaForm extends Form {

    public function __construct() {
        $this->setActionForm('Company.php');
        $this->setClass('empresa');
        $this->setMethod('post');
        $this->setEnctype('multipart/form-data');
         $this->setDefaultFormLabelsColSize(4);
        $this->setDefaultFormElementsColSize(8);
        parent::__construct();
        $this->init();
    }

    public function init() {
        $this->addElement(array(
            'type' => 'text',
            'name' => 'nombre',
            'label'=>'Nombre',
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'direccion',
            'label'=>'Direccion',
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'ciudad',
            'label'=>'Ciudad',
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'estado',
            'label'=>'Estado',
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'codigopostal',
            'label'=>'Codigo postal',
            'required'=> true
        ));
        
         $this->addElement(array(
            'type' => 'text',
            'name' => 'nombre_contacto',
            'label'=>'Contacto',
            'required'=> false
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'telefono',
            'label'=>'Telefono',
            'required'=> false
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'fax',
            'label'=>'Fax',
            'required'=> false
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'email',
            'label'=>'Correo electronico',
            'required'=> false
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'paginaweb',
            'label'=>'Web',
            'required'=> false
        ));
        
        $this->addElement(array(
            'type' => 'file',
            'name' => 'logo_file',
            'label' => 'Logo',
            'class' => 'upload',
            'required' => false,
            'optionals' => array(
                'title' => 'Logo'
            ),
        ));
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'send',
            'value'=> $this->_getTranslation('Terminar'),
            'optionals'=>array(
                'onclick'=>"submit()"),
            'class'=>'btn btn-primary m-t-1 m-b-1'
        ));
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'cancelar',
            'value'=> $this->_getTranslation('Cancelar'),
            'optionals'=>array(
                'onclick'=>"document.location = '".ROOT_HOST."/Controller/Company.php'"),
            'class'=>'btn btn-danger m-t-1 m-b-1'
        ));
    }
    
    public function populate($data){
        parent::populate($data);
    }
}