<?php
/**
 * Description of DevolucionForm
 *
 * @author carlos
 */

class DevolucionForm extends Form {

    public function __construct() {
        $this->setActionForm('Return.php');
        $this->setName('devolucion');
        $this->setClass('devolucion');
        $this->setMethod('post');
        parent::__construct();
        $this->init();
    }

    public function init() {                
        $this->addElement(array(
            'type' => 'text',
            'name' => 'fecha',
            'label'=>'Fecha',
            'value'=>date('d/m/Y'),
            'validators'=>array('date'),
            'required'=> true
        ));        
                
        $this->addElement(array(
            'type' => 'select',
            'name' => 'formaPago',
            'label'=>'Forma de pago',
            'multiOptions'=>$this->listaFormasDePago(),
            'value'=>'1',
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'monto',
            'label'=>'Monto',
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'numDocumento',
            'label'=>'Num referencia',
            'required'=> true
        ));
       
        $this->addElement(array(
            'type' => 'textarea',
            'name' => 'notas',
            'label'=>'Notas',
            'optionals'=>array('style'=>'width:275px;height:80px'),
            'required'=> false
        ));
        
        $this->addElement(array(
            'type'=>'button',
            'name'=>'guardar',
            'value'=>$this->_getTranslation('Agregar'),
            'optionals'=>array('onclick'=>'setCobroTemp()'),
            'class'=>'btn btn-primary',
            'col-size-element'=>'12',
        ));
        
         $this->addElement(array(
            'type' => 'button',
            'name' => 'cerrar',
            'value'=> $this->_getTranslation('Cerrar'),
            'class'=>'btn btn-default',
            'optionals'=>array(
                'data-dismiss'=>'modal',
                'aria-hidden'=>'true',
                ),
            'col-size-element'=>'12',
        ));
        
    }
    
    public function listaFormasDePago(){
        $repository = new FormaMetodoPagoRepository();
        $result = $repository->getListFormasPago();
        
        if ($result) {
            //$array = array(null => 'Seleccionar una opcion...');
            $array = array();
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }
    }
    
    public function populate($data){
        $tools = new Tools();
        $data['fecha'] = $tools->setFormatDateToForm($data['fecha']);
        parent::populate($data);
    }
}