<?php
/**
 * Description of PagoForm
 *
 * @author carlos
 */

class CobroForm extends Form {

    public function __construct() {
        $this->setActionForm('CustomerPayment.php');
        $this->setName('cobro');
        $this->setClass('cobro');
        $this->setMethod('post');
        parent::__construct();
        $this->init();
    }

    public function init() {        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'idVenta',
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'fecha',
            'label'=>'Fecha',
            'value'=>date('d/m/Y'),
            'validators'=>array('date'),
            'required'=> true
        ));        
                
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'formaPago',
            'value'=>'1',
            'required'=> true
        ));
        
         $this->addElement(array(
            'type' => 'hidden',
            'name' => 'card_payment_type',
            'value'=>'1',
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'monto',
            'required'=> true,
            'optionals'=>array('placeholder'=>$this->_getTranslation('Monto')),
            //'class'=>'numPad',            
            'col-size-element'=>'12',
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'numDocumento',
            'optionals'=>array('placeholder'=>$this->_getTranslation('Reference')),
            'required'=> false,
            'col-size-element'=>'12',
        ));
        
        $append = "<span style='width:20px'; class = 'btn btn-success input-group-addon' onclick='processCardPayment()'><i class='fa fa-check'></i></span>";
        $this->addElement(array(
            'type' => 'text',
            'name' => 'swipeCard',
            'label'=>'Swipe card',
            'required'=> false,
            'append'=>$append,
        ));
        
        /*
        $this->addElement(array(
            'type' => 'select',
            'name' => 'tarjeta_tipo',
            'label'=>'Tipo',
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'tarjeta_nombre',
            'label'=>'Nombre',
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'tarjeta_anio',
            'label'=>'Año',
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'tarjeta_mes',
            'label'=>'Mes',
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'tarjeta_codigo',
            'label'=>'Codigo',
            'required'=> true
        ));
        */
        $this->addElement(array(
            'type' => 'textarea',
            'name' => 'notas',
            'label'=>'Notas',
            'optionals'=>array('style'=>'width:275px;height:80px'),
            'required'=> false
        ));
        
        $this->addElement(array(
            'type'=>'button',
            'name'=>'guardar',
            'value'=>$this->_getTranslation('Agregar'),
            'optionals'=>array('onclick'=>'setCobroTemp()'),
            'class'=>'btn btn-primary',
            'col-size-element'=>'12',
        ));
        
         $this->addElement(array(
            'type' => 'button',
            'name' => 'cerrar',
            'value'=> $this->_getTranslation('Cerrar'),
            'class'=>'btn btn-default',
            'optionals'=>array(
                'data-dismiss'=>'modal',
                'aria-hidden'=>'true',
                ),
            'col-size-element'=>'12',
        ));
        
    }
    
    public function listaFormasDePago(){
        $repository = new FormaMetodoPagoRepository();
        $result = $repository->getListFormasPago();
        
        if ($result) {
            $array = array(null => 'Seleccionar una opcion...');
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }
    }
    
    public function populate($data){
        $tools = new Tools();
        $data['fecha'] = $tools->setFormatDateToForm($data['fecha']);
        parent::populate($data);
    }
}