<?php
/**
 * Description of ClienteForm
 *
 * @author carlos
 */
class ClienteForm extends Form {

    public function __construct() {
        $this->setActionForm('Customer.php');
        $this->setName('cliente');
        $this->setMethod('post');
        $this->setClass('cliente');       
        $this->setDefaultFormLabelsColSize('4');
        $this->setDefaultFormElementsColSize('8');
        parent::__construct();
        $this->init();
    }

    public function init() {
        $this->addElement(array(
            'type' => 'text',
            'name' => 'nombre',
            'label'=>'Nombre',
            'required'=>true
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'nombre_empresa',
            'label'=>'Empresa/Negocio',
            'required'=>true
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'calle',
            'label'=>'Direccion',
            'required'=>false
        ));      
    
        
         $this->addElement(array(
            'type' => 'text',
            'name' => 'ciudad',
            'label'=>'Ciudad',
            //'multiOptions'=>array('Mcallen'=>'Mcallen','Mission'=>'Mission'),
            'required'=>false
        )); 
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'estado',
            'label'=>'Estado',
            'required'=>false
        ));
        
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'codigopostal',
            'label'=>'Codigo postal',
            'required'=>false
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'contacto',
            'label'=>'Contacto',
            'required'=>false
        ));        
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'telefono',
            'label'=>'Telefono',
            'required'=>false
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'fax',
            'label'=>'Fax',
            'required'=>false
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'correo',
            'label'=>'Email',
            'required'=>false
        ));
         
        $this->addElement(array(
            'type' => 'textarea',
            'name' => 'comentarios',
            'label'=>'Comentarios',
        ));
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'send',
            'value'=> $this->_getTranslation('Terminar'),
            'optionals'=>array(
                'onclick'=>"submit()"),
            'class'=>'btn btn-primary m-t-1 m-b-1'
        ));
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'cancelar',
            'value'=> $this->_getTranslation('Cancelar'),
            'optionals'=>array(
                'onclick'=>"document.location = '".ROOT_HOST."/Controller/Customer.php'"),
            'class'=>'btn btn-danger m-t-1 m-b-1'
        ));
        
         $this->addElement(array(
            'type' => 'button',
            'name' => 'guardarCliente',
            'value'=> $this->_getTranslation('Guardar'),
            'class'=>'btn btn-primary',
            'optionals'=>array('onclick'=>'saveCliente()'),
            'col-size-element'=>'12',
        ));
    }
    
    public function populate($data) {
        if(isset($data['metodoPago']) && $data['metodoPago']=='2'){
            $this->enabledElement(array('diasCredito'));
        }
        parent::populate($data);
    }
}