<?php
/**
 * Description of NivelForm
 *
 * @author carlos
 */

class CategoriaForm extends Form {

    public function __construct() {
        $this->setActionForm('Category.php');
        $this->setClass('categoria');
        $this->setMethod('post');
        $this->setDefaultFormLabelsColSize(4);
        $this->setDefaultFormElementsColSize(8);
        parent::__construct();
        $this->init();
    }

    public function init() {
        $this->addElement(array(
            'type' => 'text',
            'name' => 'descripcion',
            'label'=>'Descripcion',
            'required'=> true,
        ));
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'type',
            'label'=>'Tipo',
            'multiOptions'=>array('Producto'=>'Producto'),
            'required'=>true
        ));    
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'send',
            'value'=> $this->_getTranslation('Terminar'),
            'optionals'=>array(
                'onclick'=>"submit()"),
            'class'=>'btn btn-primary m-t-1 m-b-1'
        ));
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'cancelar',
            'value'=> $this->_getTranslation('Cancelar'),
            'optionals'=>array(
            'onclick'=>"document.location = '".ROOT_HOST."/Controller/Category.php'"),
            'class'=>'btn btn-danger m-t-1 m-b-1'
        ));
    }
    
    public function populate($data){
        parent::populate($data);
    }
}