<?php
class WasteRepository extends EntityRepository {

    private $table = 'waste';
    private $options = array(
        'date'=>null,
        'quantity'=>null,
        'um'=>null,
        'reason'=>null,
        'status'=>null
    );
    
    public function setOptions($data){
      foreach ($this->options as $option => $value){
          if(isset($data[$option])){
            $this->options[$option] = $data[$option];
          }
      }
    }
  
    public function getOptions(){
        return $this->options;
    }
    
    public function getTable(){
        return $this->table;
    }

    public function save(array $data, $table = null) { 
        $tools = new Tools();
        $data['date'] = $tools->setFormatDateToDB($data['date']);
        
        $login = new Login();
        $data['idCaja']= $login->getIdCaja();
        $data['creado_fecha'] = date('Y-m-d');
        $data['creado_por'] = $login->getId();       
        $data['status'] = 1;     
        unset($data['modificaciones']);
        
        return parent::save($data, $this->table);
    }
    
    public function delete($id, $table = null) {        
        return parent::update($id, array('status'=>2), $this->table);        
    }

    public function update($id, $data, $table = null) {
        $tools = new Tools();
        $data['date'] = $tools->setFormatDateToDB($data['date']);
        
        unset($data['creado_fecha'],$data['creado_por'],$data['status'],$data['modificaciones']);
        
        return parent::update($id, $data, $this->table);
    }

    public function getById($id, $table = null,$selectAux = null) {
        return parent::getById($id, $this->table,$selectAux);
    }

    public function isUsedInRecord($id, array $buscarEn = null,$andWhere = null) {
        return parent::isUsedInRecord($id, array('productos' => 'categoria'));
    }
    
    public function getListaWaste() {
        $select = "SELECT w.*,"
                . "DATE_FORMAT(w.date,'%m/%d/%Y')as formated_date,"
                . "CONCAT(u.nombre,' ',u.apellido)as user_name,"
                . "fxGetStatusName(w.status,'status','Waste')as status_name "
                . "FROM $this->table w "
                . "LEFT JOIN usuarios u ON w.creado_por = u.id "
                . "ORDER BY date DESC";
        $result = $this->query($select);

        if ($result) {
           return $this->resultToArray($result);
        }
        return null;
    }
}
