<?php
class VentaDetallesTempEntity extends VentaDetallesTempRepository{
    private $options = array (
        'idVenta' => null,
        'idProducto' => null,
        'descripcion' => null,        
        'etiqueta'=>null,
        'cantidad'=>null,
        'precio'=>null,
        'punitariocompra'=>null,
        'cuentaContable'=>null,
        'tipo_entrada'=>null,
        'referencia'=>null,
        'ref_fac'=>null,
        'lote'=>null
     );
    
    public function setOptions($data){
        foreach ($this->options as $option => $value){
            if(isset($data[$option])){
              $this->options[$option] = $data[$option];
            }
        }
    }

    public function getOptions(){
        return $this->options;
    }
    
    public function prepareOptionsAndSetOptions($data){
        $precio = $data['precio'];
        $otroPrecio = $data['otroPrecio'];
        
        if($precio == '' && $otroPrecio == ''){return null;}
        
        if($otroPrecio != ''){
            $data['precio'] = $otroPrecio;
            unset($data['otroPrecio']);
        }

        if($data['idVenta'] == '' || $data['idVenta'] == NULL){
            unset($data['idVenta']);
            unset($this->options['idVenta']);
        }
        
        $this->setOptions($data);
        
        return true;
    }

    public function pagination($pag){
      $paginacion = new Paginacion($pag);
      $paginacion->setTables('ventas');
      //$paginacion->setWhereFilter();
      $paginacion->setLayout(new Tradicional(2));
      
      return $paginacion;   
  }
}