<?php
/**
 * Description of Producto
 * @author carlos
 */
class ProductoEntity extends ProductoRepository{
    private $options = array (        
        'type'=>null,
        'mostrar_en_pos'=>null,
        'nombre_para_pos'=>null,
        'color'=>null,
        'codigo' => null,
        'descripcion' => null,
        'categoria' => null,
        'marca' => null,
        'unidad_de_medida'=>null,     
        'llevar_inventario'=>null,
        'stock_minimo'=>null,
        'punitarioventa' => null,
        'descuento'=>null,
        'impuestos'=>null,
        'impuestos_incluidos'=>null,
        'aplica_para_ebt'=>null,
        'venta_solo_para_mayores'=>null,
        'costo'=>null,     
        'impuestos_compra'=>null,
        'impuestos_incluidos_compra'=>null,
        'proveedores'=>null,
        'creado_por'=>null,
        'creado_fecha'=>null,
        'modificaciones'=>null,
        'status'=>null ,
        
     );
    
    public function setOptions($data){
        foreach ($this->options as $option => $value){
            if(isset($data[$option])){
              $this->options[$option] = $data[$option];
            }
        }
    }

    public function getOptions(){
        return $this->options;
    }
    
    public function getPreciosVenta(){
        $array = array(
            $this->options['punitarioventa']=>'Precio menudeo - $'.$this->options['punitarioventa'],
            $this->options['pmayoreoventa']=>'Precio mayoreo - $'.$this->options['pmayoreoventa']
        );
        
        return $array;
    }
    
    public function getDescripcion(){
        return $this->options['descripcion'];
    }
}