<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

class PosMarcaRepository extends EntityRepository {

    private $table = ' marcas';
    private $options = array(
        'descripcion'=>null,
        'creado_fecha'=>null,
        'creado_por'=>null,
        'modificaciones'=>null,
        'status'=>null
    );
    
    public function setOptions($data){
      foreach ($this->options as $option => $value){
          if(isset($data[$option])){
            $this->options[$option] = $data[$option];
          }
      }
    }
  
    public function getOptions(){
        return $this->options;
    }
    
    public function getTable(){
        return $this->table;
    }

    public function save(array $data, $table = null) {
        $login = new Login();
        $data['creado_fecha'] = date('Y-m-d');
        $data['creado_por'] = $login->getId();
        $data['status'] = 1;
        unset($data['modificaciones']);

        return parent::save($data, $this->table);
    }
    
    public function delete($id, $table = null) {        
        return parent::delete($id, $this->table);
    }

    public function update($id, $data, $table = null) {
        unset($data['creado_fecha'],$data['creado_por'],$data['status'],$data['modificaciones']);
        
        return parent::update($id, $data, $this->table);
    }

    public function getById($id, $table = null,$selectAux = null) {
        return parent::getById($id, $this->table,$selectAux);
    }

    public function isUsedInRecord($id, array $buscarEn = null,$andWhere = null) {
        return parent::isUsedInRecord($id, array('productos' => 'marca'));
    }

    public function getListaSelectMarcas() {
        $select = "SELECT * FROM $this->table ";
        $result = $this->query($select);

        if ($result) {
            $array = array();
            while ($row = $result->fetch_assoc()) {
                $array[$row['id']] = $row['descripcion'];
            }
            return $array;
        }
        return null;
    }
    
     public function getListaMarcas() {
        $select = "SELECT * from $this->table ";
        $result = $this->query($select);

        if ($result) {
           return $this->resultToArray($result);
        }
        return null;
    }
}
