<?php
class EmpresaRepository extends EntityRepository {

    private $table = 'empresa';
    private $images = null;
    private $options_image = array(
        'allowedExtensions'=>array('image/jpg','image/jpeg','image/png','image/gif'),
        'maxFileSizeAllowed'=>16384
    );

    public function save(array $data, $table = null) {        
        $rs = parent::save($data, $this->table);        
        if($rs){                        
            $insertId = $this->getInsertId();
            //$this->saveImage($insertId);          
        }  
        return $rs;
    }
    
    public function delete($id, $table = null) {
        return parent::delete($id, $this->table);
    }

    public function update($id, $data, $table = null) {        
        $rs = parent::update($id, $data, $this->table);
       
        if($rs){                        
           // $this->saveImage($id);             
        }  
        return $rs;
    }

    public function getById($id, $table = null,$selectAux = null) {
        return parent::getById($id, $this->table,$selectAux);
    }

    public function isUsedInRecord($id, array $buscarEn = null,$andWhere = null) {
        return parent::isUsedInRecord($id, array('' => ''));
    }
    
    public function setImage($images){
        $this->images = $images;
    }
    
    public function saveImage($idSucursal){ 
        if($this->images['name'] != ''){
            if (in_array($this->images['type'], $this->options_image['allowedExtensions']) && $this->images['size'] <= $this->options_image['maxFileSizeAllowed'] * 1024){
                $imagen_temporal = $this->images['tmp_name'];

                // Tipo de archivo
                $tipo = $this->images['type']; 
                $size = $this->images['size'];

                // Leemos contenido y escapamos caracteres especiales
                $data = file_get_contents($imagen_temporal);
                //$data = addslashes($data);

                $array = array(
                    'logo'=>$data,
                    'logo_type'=>$tipo,
                    'logo_size'=>$size
                );
                
                parent::update($idSucursal, $array, $this->table);                

            }else{
                $this->flashmessenger->addMessage(array(
                'danger'=>$this->_getTranslation("Formato de archivo no permitido o excede el tamaño límite de {$this->options_image['maxFileSizeAllowed']} Kbytes.")));
                return null;
            }
        }
        return true;
    }
}