<?php

class ClienteRepository extends EntityRepository {
    
    private $table = 'clientes';

    public function save(array $data, $table = null) {
        $login = new Login();
        $data['creado_por'] = $login->getId();
        $data['creado_fecha'] = date('Y-m-d H:i:s');        
        
        return parent::save($data, $this->table);
    }
    
    public function saveClientePos($data){
        $login = new Login();
        $data['creado_por'] = $login->getId();
        $data['creado_fecha'] = date('Y-m-d H:i:s');        
        
        return parent::save($data,$this->table);
    }
    
    public function updateClientePos($id,$data,$table = null){
        $login = new Login();
        $data["ultima_mod_por"] = $login->getId();
        $data["ultima_mod_fecha"] = date("Y-m-d H:i:s");
        
        return parent::update($id,$data,$this->table);
    }

    public function update($id, $data, $table = null) {
        $login = new Login();
        $data["ultima_mod_por"] = $login->getId();
        $data["ultima_mod_fecha"] = date("Y-m-d H:i:s");
        
        return parent::update($id, $data, $this->table);
    }

    public function getById($id, $table = null,$selectAux = null) {
        $select = "SELECT * "
                 . "FROM $this->table WHERE id = '$id'";
        $result = $this->query($select);

        if ($result->num_rows>0) {
            $set = $this->resultToArray($result);
            return $set[0];
        }
        return false;
    }
    
    public function delete($id, $table = null) {
        return parent::delete($id, $this->table);
    }

    public function isUsedInRecord($id, array $buscarEn = null,$andWhere= null) {
        return parent::isUsedInRecord($id, array('ventas'=>'cliente'));   
    }
    
    public function getListaSelectClientes(){
        $query = "SELECT id,nombre,IF(telefono != '',CONCAT(' - ',REPLACE(telefono,' ','')),'')as telefono "
                . "FROM $this->table "
                . "ORDER BY nombre ASC";
        $result = $this->query($query);
        
        if($result){
            $array = array();
            while($row = $result->fetch_object()){
                $array[$row->id] = $row->nombre.$row->telefono;
            }
            
            return $array;
        }
        
        return null;
    }
    
     public function getListaClientes(){
        $query = "SELECT * FROM $this->table ORDER BY nombre ASC";
        $result = $this->query($query);
        
        if($result){
            return $this->resultToArray($result);
        }
        
        return null;
    }
    
    public function createFilterFecha($options,$campoFecha = null ){
        $fechaInicio = $options['fechaInicio'];
        $fechaFin = $options['fechaFin'];
        $fecha = null;
        $tools = new Tools();
        if($fechaInicio!=null){
            $fechaInicio = $tools->setFormatDateToDB($fechaInicio);
            if($fechaFin!=null){
                $fechaFin = $tools->setFormatDateToDB($fechaFin);
                $fecha .=" AND $campoFecha BETWEEN '{$fechaInicio}' AND '{$fechaFin}' ";
            }else{
                $fecha .=" AND $campoFecha BETWEEN '{$fechaInicio}' AND '{$fechaInicio}' ";
            }
        }elseif($fechaFin!=null){
            $fecha .=" AND $campoFecha BETWEEN '{$fechaFin}' AND '{$fechaFin}' ";
        }
        
        return $fecha;
    }
}