<?php
/**
 * Description of Cliente
 *
 * @author carlos
 */

class ClienteEntity extends ClienteRepository{
    private $options = array (
        'nombre' => null,
        'nombre_empresa'=>null,
        'calle' => null,
        'estado' => null,
        'ciudad' => null,
        'codigopostal' => null,
        'contacto' => null,
        'correo' => null,
        'telefono' => null,
        'fax'=>null,
        'payment_terms'=>null,
        'comentarios'=>null,
        'creado_por'=>null,
        'creado_fecha'=>null,
        'modificaciones'=>null
     );
    
  public function setOptions($data){
      foreach ($this->options as $option => $value){
          if(isset($data[$option])){
            $this->options[$option] = $data[$option];
          }
      }
  }
  
  public function getOptions(){
      return $this->options;
  }
    
    public function setNombre($nombre){
        $this->nombre = $nombre;
    }
    
    public function getNombreParaCheque(){
        if(trim($this->options['nombreParaCheque'])==''){
            return $this->options['nombre'];
        }
        return $this->options['nombreParaCheque'];
    }
    
    public function setCalle($calle){
        $this->calle = $calle;
    }
    
    public function setNumero($numero){
        $this->numero = $numero;
    }
    
    public function setEstado($estado){
        $this->estado = $estado;
    }
    
    public function setCiudad($ciudad){
        $this->ciudad = $ciudad;
    }
    
    public function setCodigopostal($codigoPostal){
        $this->codigoPostal = $codigoPostal;
    }
    
    public function setContacto($contacto){
        $this->contacto = $contacto;
    }
    
    public function setCorreo($correo){
        $this->correo = $correo;
    }
    
    public function setTelefono($telefono){
        $this->telefono = $telefono;
    }
    
    public function setTable($table){
        $this->table = $table;
    }

    public function getNombre(){
        return $this->options['nombre'];
    }
    
    public function getNombreEmpresa(){
        return $this->options['nombre_empresa'];
    }
    
    public function getCalle(){
        return $this->options['calle'];
    }
    
    public function getColonia(){
        return $this->options['colonia'];
    }
    
    public function getNumero(){
        return $this->options['numero'];
    }
    
    public function getEstado(){
        return $this->options['estado'];
    }
    
    public function getCiudad(){
        return $this->options['ciudad'];
    }
    
    public function getCodigopostal(){
        return $this->options['codigopostal'];
    }
    
    public function getContacto(){
        return $this->options['contacto'];
    }
    
    public function getCorreo(){
        return $this->options['correo'];
    }
    
    public function getTelefono(){
        return $this->options['telefono'];
    }
    
    public function getSaldoPendiente(array $options = null,$onlyInovice = null){
        if($options==null){$options['idCliente'] = $this->getId();}
        return parent::getSaldoPendiente($options,$onlyInovice);
    }
    
    public function getOpenInvoices($cliente = null,$rangoFecha = null) {
        if($cliente == null){$cliente = $this->getId();}
        return parent::getOpenInvoices($cliente,$rangoFecha);
    }
    
    public function getTable(){
        return $this->table;
    }  
}