<?php
class VentaAjax extends VentaRepository {
    
    public $flashmessenger = null;
    
    public function __construct() {
        if(!$this->flashmessenger instanceof FlashMessenger){
            $this->flashmessenger = new FlashMessenger();
        }
    }
    
    public function getResponse($request, $options) {
        return $this->$request($options);
    }
    
    public function _getTranslation($text){
        $translator = new Translator();
        return $translator->_getTranslation($text);
    }
    
    public function getTranslation($options){
        $msj = $options['msj'];
        
        return array(
            'response'=>true,
            'translation'=>$this->_getTranslation($msj)
        );
    } 
    

    public function getTotalSales($options){
        $salesRecord = new VentaRepository();
        $salesData = $salesRecord->getSalesByDateRange($options['start'],$options['end']);
        
        $string = '';
        $totalSales = 0;
        $chartData = array();
        if($salesData){
            foreach($salesData as $sale){
                $totalSales += $sale['total_sales'];
                $chartData[$sale['store_name']] = number_format($sale['total_sales'],2,'.','');
                $string .= "<tr>";
                $string .= "<td class='text-center'>{$sale['store_name']}</td>";
                $string .= "<td class='text-right'>$".number_format($sale['total_sales'],2)."</td>";
                $string .= "</tr>";
            }
            
            return array(
                'response'=>true,
                'caption'=>$this->_getTranslation('Ventas')." ".$this->_getTranslation('de')." ".$options['start']." ".$this->_getTranslation('a')." ".$options['end'],
                'salesData'=>$string,
                'totalSales'=>number_format($totalSales,2,'.',''),
                'chartData'=>$chartData 
            );
        }   
        
        return array('response'=>false);
    }
    
     public function getTotalSalesByStoreId($options){
        $salesRecord = new VentaRepository();
        $salesData = $salesRecord->getSalesByStoreIdByDateRange($options['start'],$options['end']);
        
        $string = '';
        $totalSales = 0;
        $chartData = array();
        if($salesData){
            foreach($salesData as $sale){
                $totalSales += $sale['total_sales'];
                $chartData[$sale['dayname']] = number_format($sale['total_sales'],2,'.','');
                $string .= "<tr>";
                $string .= "<td class='text-center'>{$sale['dayname']} <small>{$sale['date']}</small></td>";
                $string .= "<td class='text-right'>$".number_format($sale['total_sales'],2)."</td>";
                $string .= "</tr>";
            }
            
            return array(
                'response'=>true,
                'caption'=>$this->_getTranslation('Ventas')." ".$this->_getTranslation('de')." ".$options['start']." a ".$options['end'],
                'salesData'=>$string,
                'totalSales'=>number_format($totalSales,2,'.',''),
                'chartData'=>$chartData 
            );
        }   
        
        return array('response'=>false);
    }
}