<?php
/**
 * Description of Ajax
 *
 * @author carlos
 */
class ReportAjax extends EntityRepository {
    
    public $flashmessenger = null;
    
    public function __construct() {
        if(!$this->flashmessenger instanceof FlashMessenger){
            $this->flashmessenger = new FlashMessenger();
        }
    }
    
    public function getResponse($request, $options) {
        return $this->$request($options);
    }
    
    public function _getTranslation($text){
        $translator = new Translator();
        return $translator->_getTranslation($text);
    }
    
    public function getTranslation($options){
        $msj = $options['msj'];
        
        return array(
            'response'=>true,
            'translation'=>$this->_getTranslation($msj)
                );
    }    
    
    public function getFiltersReport($options){
        $form = new ReporteForm();        
        
        return array(
            'response'=>true,
            'filters'=>$form->getStringFiltersForm($options['report'])
        );
    }    
    
    public function deleteReportSaleList(array $options){
        $id = $options['id'];
        $repository = new VentaRepository();
        if($repository->getById($id)['status'] != '3'){
            if($repository->delete($id)){
                $response = true;
                $msj = 'Venta eliminada correctamente.';
            }else{
                $response = null;
                $msj = "No se pudo eliminar venta. Intente nuevamente.";
            }
        
        }else{
            $response = null;
            $msj = "La venta se encuentra cancelada.";
        }

        $json = array(
                'response' => $response,
                'message'=>$msj,
            ); 
            return $json;
    }
}