<?php
class ProductAjax extends ProductoRepository {    
    public function __construct() {
        parent::__construct();
    }

    public function getResponse($request, $options) {
        return $this->$request($options);
    }

    public function setProductDetails(array $options) {        
        $slice = $this->getSliceById($options['slice_id']);
        if($slice){
            $data = array(
                'idDetailTemp'=>$options['idDetailTemp'],
                'id_slice'=>$slice['id'],
                'quantity'=>$options['slice_quantity']); 
            
            $this->insertDetalle($data);
            $productDetails = $this->getProductDetails();
            $detalles = $this->listProductDetails($productDetails);

            $json = array(
                'response' => true,
                'productDetails' => $detalles['listDetails']
            );
            
            return $json;
        }else{
            $this->flashmessenger->addMessage(array('info'=>$this->_getTranslation('Producto no registrado.')));
            return $json = array(
                'response'=>null,
                'message'=>$this->flashmessenger->getMessageString());
        }
    }
    
    public function listProductDetails($detalles){
        $listDetalles = "";
        
        foreach($detalles as $detalle){
            $id = $detalle['id'];          
            $detalle['slice_category'] = $detalle['category'];
            $detalle['slice_id'] = $detalle['id_slice'];
            $detalle['slice_quantity'] = $detalle['quantity'];
            
            unset($detalle['id'],$detalle['category'],$detalle['id_slice'],$detalle['quantity']);
            
            $array = json_encode($detalle);            
            $listDetalles .= "<tr>
                <td>".$detalle['categoryName']."</td> 
                <td>".$detalle['flavor'].' '.$detalle['sizeName']."</td>                    
                <td class='text-right'>".number_format($detalle['slice_quantity'],2)."</td>                      
                <td class='text-center'>                       
                    <a class='btn btn-sm btn-default' onclick='setDetailProductToEdit($array);'><i class='fa fa-pencil'></i></a>
                    <a class='btn btn-sm btn-danger' onclick='deleteProductDetalles($id);'><i class='fa fa-trash'></i></a>
                </td>
                </tr>";
        }
        
        return array('listDetails'=>$listDetalles
            );
    }
    
    public function getListProductDetails(){
        $productDetails = $this->getProductDetails();
        $detalles = $this->listProductDetails($productDetails);

            $json = array(
                'response' => true,
                'productDetails' => $detalles['listDetails']
            ); 
            
            return $json;
    }

    public function deleteDetalles(array $options){
        $id = $options['id'];
        $repository = new ProductDetailsTempRepository();
        
        if($repository->delete($id)){
            $response = true;
            $this->flashmessenger->addMessage(array('success'=>'Parte eliminada correctamente.'));
        }else{
            $response = null;
            $this->flashmessenger->addMessage(array('danger'=>'No se pudo eliminar parte del pastel. Intente nuevamente.'));
        }
        
        $productDetails = $this->getProductDetails();
        $detalles = $this->listProductDetails($productDetails);

        $json = array(
                'response' => true,
                'listDetails' => $detalles['listDetails'],
                'message'=>$this->flashmessenger->getMessageString()
            ); 
            return $json;
    }
    
    public function setSliceFlavor($options){
        $category = $options['category'];
        
        $repoSlices = new SliceRepository();
        $result = $repoSlices->getListSelectSlice($category);   
        
        $list = "<option value='0'>".$this->_getTranslation('Seleccionar una opcion...')."</value>";
        if($result){
            foreach($result as $key => $value){
                $list .= "<option value='$key'>".utf8_encode($value)."</option>";
            }
        }
        
        
        return array(
            'response'=>true,
            'listSlices'=>$list
        );
    }
}