<?php
/**
 * Description of Ajax
 *
 * @author carlos
 */
class Ajax extends GenericRepository {
    
    public function getResponse($request, $options) {
        return $this->$request($options);
    }
    
    public function _getTranslation($text){
        $translator = new Translator();
        return $translator->_getTranslation($text);
    }
    
    public function getTranslation($options){
        $msj = $options['msj'];
        
        return array(
            'response'=>true,
            'translation'=>$this->_getTranslation($msj)
                );
    }
    
     public function refreshSession(){              
        session_regenerate_id();
        return array(
           'response'=>true
               );
    }
    
    public function saveRetiro($options){
        $data = array();
        foreach($options['options'] as $row){
            $data[$row['name']] = $row['value'];
        }
        
        $login = new Login();
        $repo = new AperturaCierreCajaRepository();
        $idApertura = $repo->getAperturaActualByIdCaja($login->getId());
        $data['id_apertura_cierre'] = $idApertura;
        $rs = parent::saveRetiro($data);  
        
        if($rs){           
            return array(
                'response'=>true,
                'retirosDetails'=>$this->listRetiros($idApertura),
                'idAperturaCaja'=>$idApertura,
                'idRetiro'=>$rs,
                'message'=>$this->flashmessenger->getMessageString()
            );
        }else{
            return array(
                'response'=>false,
                'message'=>$this->flashmessenger->getMessageString()
            );
        }      
    }
    
    public function listRetiros($idApertura){
        $retiros = parent::getListRetiros($idApertura);
        $string = '';
        $i = 0;
        if($retiros != null){
            foreach($retiros as $retiro){
                $i++;
                $array = json_encode($retiro);
                $string .= "<tr>"
                        .  "<td class='text-center'>{$i}</td>"
                        .  "<td class='text-center' style='width:15%'>$ ".number_format($retiro['monto'] ,2)."</td>"
                        .  "<td class='text-center'> {$retiro['status']}</td>"
                        .  "<td class='text-right'>"
                        . " <a onclick='setRetiroToEdit({$array});'><i class='btn btn-md btn-default fa fa-pencil'></i></a>"
                        . " <a onclick='deleteRetiro({$retiro['id']});'><i class='btn btn-md btn-danger fa fa-trash'></i></a>"
                        . "</td>"
                        . "</tr>";
            }
        }
        return $string;
    }
    
     public function deleteRetiro($options){
        $rs = parent::deleteRetiro($options['id']);      

        if($rs){        
            $login = new Login();
            $repo = new AperturaCierreCajaRepository();
            $idApertura = $repo->getAperturaActualByIdCaja($login->getId());
        
            return array(
                'response'=>true,
                'retirosDetails'=>$this->listRetiros($idApertura),
                'message'=>$this->flashmessenger->getMessageString()
            );
        }else{
            return array(
                'response'=>false,
                'message'=>$this->flashmessenger->getMessageString()
            );
        }    
    }
    
    public function setInventoryManually($options){
        $data = array();
        foreach($options['options'] as $row){
            $data[$row['name']] = $row['value'];
        }
        
        $idProduct = $data['idProduct'];
        $idStore = $data['idStore'];
        $stock = $data['stock'];
        $notes = $data['notes'];
        
        $login = new Login();
        $settings = new SettingsEntity();
        $allowedEditInventory = $settings->_get('role_allowed_to_edit_inventory');
        $allowedEditInventory = explode(',', $allowedEditInventory);        
        
        if($login->getSucursal() != $idStore && !in_array($login->getRole(), $allowedEditInventory)){
            $this->flashmessenger->addMessage(array('danger'=>'No tienes permisos para editar este registro.'));
            return array(
                'response'=>null,
                'message'=>$this->flashmessenger->getMessageString()
            );
        }
        
        $repoInventory = new InventarioRepository();
        $result = $repoInventory->updateInventory(array(
                    'id_product'=>$idProduct,
                    'quantity'=>$stock,
                    'sucursal'=>$idStore,
                    'notes'=>$notes
                ));
        
        if($result){
            return array(
                'response'=>true,
                'idProduct'=>$idProduct,
                'idStore'=>$idStore,
                'stock'=>$stock
            );
        }else{
            $this->flashmessenger->addMessage(array('danger'=>'Algo salio mal al tratar de editar inventario. Intente nuevamente.'));
            return array(
                'response'=>false,
                'message'=>$this->flashmessenger->getMessageString()
            );
        }
    }
}