$(document).ready(function(){
    $('.btn-toggle').click(function() { 
     $(this).find('.btn').toggleClass('active');  

     if ($(this).find('.btn-primary').size()>0) {
         $(this).find('.btn').toggleClass('btn-primary');
     }
 });
});

$(document).ajaxStart($.blockUI).ajaxStop($.unblockUI);

function _getTranslation(msj,callback){
    $.post('/Controller/Ajax.php', {
        action: 'ajax',
        request: 'getTranslation',
        msj:msj
            }, function(data) {
                callback(msj);
            }, 'json');
}

function fadeOutAlert(){
  window.setTimeout(function() {
    $('.alert').fadeTo(500, 0).slideUp(500, function(){
        $(this).remove();
    });
  }, 10000);
}

function moveToError(){
    $('html, body').animate({ scrollTop: '0px'},500);
}

function addMsgFlashmessenger(tipo,msg,elem){
    $('#msg').remove();
    $('#flashmessenger').append("<div id='msg' class='alert alert-"+tipo+"'></div>");
    var btnClose = "<button type='button' class='close' data-dismiss='alert'>&times;</button>";
    $('#msg').html(btnClose+msg);
    moveToError();
    fadeOutAlert();
    //setTimeout(function() {$("#"+elem).focus();}, 0);
}

function submit(formName){
    $('form[name='+formName+']').submit();
}

function clearForm(formName){
    $('form[name='+formName+']')[0].reset();
}

function clearFormChofer(){
    clearForm("chofer");
}

function confirmDelete(msg,link){
    BootstrapDialog.confirm({
       message: msg,
       type: BootstrapDialog.TYPE_GRAPEAPP,
       callback: function(result){
           if(result) {
               $("#iframe").attr("src", link.href);
               $("#iframe").load();
           }
       }
    }); 
    return false;    
}

function filterCustomer(link){
    BootstrapDialog.show({
            title: function(dialog){
                _getTranslation('Seleccionar cliente',function(msj){dialog.setTitle(msj)})
            },
            message: function(){
                var $message = $("<div></div>");
                $message.append("<label style='display:inline-block;width:100px'>Cliente</label>");
                var $customer = $("<select id='customerFilter' class='form-control'><option value='all'>Todos</option></select></div>");
                
                fillCustomers(function(callback){
                    $customer.html(callback.list);
                });  
                
                $message.append($customer);
                
                var $fiCustomer = $("<input type='text' id='fiCustomer' class='form-control' />");                
                var $divFiCustomer = $("<div></div>");
                $divFiCustomer.append("<label style='display:inline-block;width:100px'>Fecha inicio</label>");
                $divFiCustomer.append($fiCustomer);
                $message.append($divFiCustomer);
                
                var $ffCustomer = $("<input type='text' id='ffCustomer' class='form-control' />");
                var $divFfCustomer = $("<div></div>");
                $divFfCustomer.append("<label style='display:inline-block;width:100px'>Fecha fin</label>");
                $divFfCustomer.append($ffCustomer);
                $message.append($divFfCustomer);
                
                return $message;
                 },
            onshow: function(dialog){
                    _getTranslation('Cancelar',function(msj){dialog.getButton('cancelar').append(msj);});
                    _getTranslation('Enviar',function(msj){dialog.getButton('enviar').append(msj);});                    
                   
            },
            onshown: function(){
                 $("#fiCustomer").datepicker({
                        dateFormat: 'mm/dd/yy',
                        showWeek:true,
                        changeMonth:true,
                        changeYear: true});
                    
                $("#ffCustomer").datepicker({
                    dateFormat: 'mm/dd/yy',
                    showWeek:true,
                    changeMonth:true,
                    changeYear: true});
            },
            type: BootstrapDialog.TYPE_GRAPEAPP,
            buttons: [{
                id: 'cancelar',
                label: '',                
                action: function(dialog) {
                    dialog.close();
                }
            }, {
                id: 'enviar',
                label: '',
                cssClass: 'btn',
                action: function() {
                    var idCliente = $("#customerFilter").val();
                    var fi = $("#fiCustomer").val();
                    var ff = $("#ffCustomer").val();
                    document.location = link.href+'&idCliente='+idCliente+'&fi='+fi+'&ff='+ff;
                }
            }]
        });
    return false; 
}

function fillCustomers(callback){ 
    $.post('/Controller/Ajax.php', {
        action: 'ajax',
        request: 'getListClientes'
    }, function(data) {
        if (data.response){
            return callback(data);
        }
    }, 'json');
}

function filterVendor(link){
    BootstrapDialog.show({
            title: function(dialog){
                _getTranslation('Seleccionar proveedor',function(msj){dialog.setTitle(msj)})
            },
            message: function(){
                var $message = $("<div></div>");
                $message.append("<label style='display:inline-block;width:100px'>Proveedor</label>");
                var $proveedor = $("<select id='vendorFilter' class='form-control'><option value='all'>Todos</option></select></div>");
                
                fillVendors(function(callback){
                    $proveedor.html(callback.list);
                });  
                
                $message.append($proveedor);
                
                var $fiVendor = $("<input type='text' id='fiVendor' class='form-control' />");                
                var $divFiVendor = $("<div></div>");
                $divFiVendor.append("<label style='display:inline-block;width:100px'>Fecha inicio</label>");
                $divFiVendor.append($fiVendor);
                $message.append($divFiVendor);
                
                var $ffVendor = $("<input type='text' id='ffVendor' class='form-control' />");
                var $divFfVendor = $("<div></div>");
                $divFfVendor.append("<label style='display:inline-block;width:100px'>Fecha fin</label>");
                $divFfVendor.append($ffVendor);
                $message.append($divFfVendor);
                
                return $message;
                 },
            onshow: function(dialog){
                    _getTranslation('Cancelar',function(msj){dialog.getButton('cancelar').append(msj);});
                    _getTranslation('Enviar',function(msj){dialog.getButton('enviar').append(msj);});                    
                   
            },
            onshown: function(){
                 $("#fiVendor").datepicker({
                        dateFormat: 'mm/dd/yy',
                        showWeek:true,
                        changeMonth:true,
                        changeYear: true});
                    
                $("#ffVendor").datepicker({
                    dateFormat: 'mm/dd/yy',
                    showWeek:true,
                    changeMonth:true,
                    changeYear: true});
            },
            type: BootstrapDialog.TYPE_GRAPEAPP,
            buttons: [{
                id: 'cancelar',
                label: '',                
                action: function(dialog) {
                    dialog.close();
                }
            }, {
                id: 'enviar',
                label: '',
                cssClass: 'btn',
                action: function() {                   
                    var idProveedor = $("#vendorFilter").val();
                    var fi = $("#fiVendor").val();
                    var ff = $("#ffVendor").val();
                    document.location = link.href+'&idProveedor='+idProveedor+'&fi='+fi+'&ff='+ff;
                }
            }]
        });
    return false; 
}

function fillVendors(callback){ 
    $.post('/Controller/Ajax.php', {
        action: 'ajax',
        request: 'getListProveedores'
    }, function(data) {
        if (data.response){
            return callback(data);
        }
    }, 'json');
}

function showStockPorReferencia(){ 
    var producto = $('#producto').val();
    if(producto === '0') return null;
    
    $.post('/Controller/Venta.php', {
        action: 'ajax',
        request: 'getStockPorReferencia',
        producto: producto
    }, function(data) {
        if(data.noShowDialog){return null;}
        if (data.response){
             $('#dialogStockPorReferencia').html(data.message+data.stockPorReferencia);
        }else{
            $('#dialogStockPorReferencia').html(data.message);
        }
        $('#dialogStockPorReferencia').dialog('open');
    }, 'json');
}

function clearPopupProducto(){
    clearForm('productoForm');
    var tipo = $('form[name=productoForm] #tipo').val();
    $.post('/Controller/Compra.php', {
        action: 'ajax',
        request: 'getElementsAgregarProdutoForm',
        tipo: tipo
    }, function(data) {
        if (data.response){      
            $('#flashmessenger-producto').html('');
            $("#formElementsProducto").html(data.elementsFormString); 
            $('#modalAgregarProducto').modal('hide');
        }
    }, 'json');
}

function agregarProducto(){ 
    var options = $("form[name='productoForm']").serializeArray();    
   
    $.post('/Controller/Compra.php', {
        action: 'ajax',
        request: 'agregarProducto',
        options:options        
    }, function(data) {
        if (data.response){
                clearForm('productoForm');
                $('#flashmessenger-producto').html('');
                $('#modalAgregarProducto').modal('hide');
                $('#producto').html(data.listProductos);
                $("#autocomplete-producto").html(data.listProductos);
        }else{ 
            $('#flashmessenger-producto').html(data.message);
            $("#formElementsProducto").html(data.formString);   
        }
    }, 'json');
}

function agregarChofer(){
    var nombre = $("#nombreChofer").val();
    var apellido = $("#apellido").val();
    var licencia = $("#licencia").val();
    var telefono = $("#telefono").val();
    var transportista = $("#transportista").val();
    $.post('/Controller/Venta.php', {
        action: 'ajax',
        request: 'agregarChofer',
        nombre: nombre,
        apellido: apellido,
        licencia: licencia,
        telefono: telefono,
        transportista: transportista
    }, function(data) {
        if (data.response){
                clearForm('chofer');
                getChoferesByTransportista($('#truck_trailer').val());
                $('#modalAgregarChofer').modal('hide');
        }else{
            $('#flashmessenger-chofer').html(data.message);
            fadeOutAlert();
        }
    }, 'json');
}

function agregarTransportista(){
    var nombre = $("#nombre").val();
    $.post('/Controller/Venta.php', {
        action: 'ajax',
        request: 'agregarTransportista',
        nombre: nombre
    }, function(data) {
        if (data.response){
                clearForm('truckTrailer');
                getTransportistas();
                $('#modalAgregarTransportista').modal('hide');
        }else{
            $('#flashmessenger-transportista').html(data.message);
            fadeOutAlert();
        }
    }, 'json');
}

function agregarCliente(){
    var options = $("form[name='cliente']").serializeArray();   
    $.post('/Controller/Venta.php', {
        action: 'ajax',
        request: 'agregarCliente',
        options: options
    }, function(data) {
        if (data.response){
                clearAgregarCliente();
                $('form[name=venta] #cliente').html(data.listClientes);
                $('#modalAgregarCliente').modal('hide');
        }else{
            $('#flashmessenger-cliente').html(data.message);
            $('#formElementsCliente').html(data.formString);
            fadeOutAlert();
        }
    }, 'json');
}

function clearAgregarCliente(){
    clearForm('cliente');
    $('#flashmessenger-cliente').html('');  
    $('#modalAgregarCliente').modal('hide');
    
    $.post('/Controller/Venta.php', {
        action: 'ajax',
        request: 'getElementsClienteForm'
    }, function(data) {
        if (data.response){      
            $("#formElementsCliente").html(data.elementsFormString); 
        }
    }, 'json');    
}

function agregarProveedor(){ 
    var options = $("form[name='proveedor']").serializeArray();   
    $.post('/Controller/Compra.php', {
        action: 'ajax',
        request: 'agregarProveedor',
        options: options
    }, function(data) {
        if (data.response){
                clearAgregarProveedor();
                $('.selectProveedor').html(data.listProveedores);
                $('#modalAgregarProveedor').modal('hide');
        }else{
            $('#flashmessenger-proveedor').html(data.message);
            $('#formElementsProveedor').html(data.formString);
            fadeOutAlert();
        }
    }, 'json');
}

function clearAgregarProveedor(){
    clearForm('proveedor');
    $('#flashmessenger-proveedor').html('');  
    $('#modalAgregarProveedor').modal('hide');
    
    $.post('/Controller/Compra.php', {
        action: 'ajax',
        request: 'getElementsProveedorForm'
    }, function(data) {
        if (data.response){      
            $("#formElementsProveedor").html(data.elementsFormString); 
        }
    }, 'json');    
}

function getTransportistas(){ 
    $.post('/Controller/Shipment.php', {
        action: 'ajax',
        request: 'getTransportistas'
    }, function(data) {
        if (data.response){
                $("#truck_trailer").html(data.listTransportistas);
                $("#transportista").html(data.listTransportistas);
        }
    }, 'json');
}

function getChoferesByTransportista(id){ 
    $.post('/Controller/Shipment.php', {
        action: 'ajax',
        request: 'getChoferesByTransportista',
        id: id
    }, function(data) {
        if (data.response){
                $("#chofer").html(data.listChoferes);
        }else{
            return null;
        }
        
    }, 'json');
}


function setActionForm(formName,output){  
    if(output === 'pantalla'){
        $('form[name='+formName+']').attr('action','/View/Reports/Pantalla/default.php');
        $('#linkSendMail').removeAttr("href"); 
    }else if(output === 'excel'){
        $('form[name='+formName+']').attr('action','Reportes.php');
        $('#linkSendMail').attr("href",'#sendMail'); 
    }
}

function setActionFormReporteFinanzas(formName,output){  
    if(output === 'pantalla'){
        $('form[name='+formName+']').attr('action','/View/Reports/Pantalla/reportes-finanzas-output.php');
        $('#linkSendMail').removeAttr("href"); 
    }else if(output === 'excel'){
        $('form[name='+formName+']').attr('action','Reportes-finanzas.php');
        $('#linkSendMail').attr("href",'#sendMail'); 
    }
}

function cantidadRecibida(elem,enviado){
    var enviado = parseInt(enviado);
    var recibido = parseInt(elem.value);
     
    if(recibido < enviado){
        var msj = 'La cantidad recibida es menor a la cantidad original.';
        $.post('/Controller/Ajax.php', {action: 'ajax',request: 'getTranslation',msj:msj
            }, function(data) {
                BootstrapDialog.alert({
                    message:data.translation,
                    type: BootstrapDialog.TYPE_GRAPEAPP
                });
            }, 'json');
        
    }else if(recibido > enviado){
        var msj = 'La cantidad recibida es mayor a la cantidad original.';
        $.post('/Controller/Ajax.php', {action: 'ajax',request: 'getTranslation',msj:msj
            }, function(data) {
               BootstrapDialog.alert({
                    message:data.translation,
                    type: BootstrapDialog.TYPE_GRAPEAPP
                });
            }, 'json');
    }else{
        return null;
    }
}

function setReport(reporte){
    $('#reporte-predeterminado').val(reporte);
    $('#output').val('excel');
}

function setFiltersReportForm(){
    var reportName = $('#reporte').val();
    
    $.post('/Controller/Ajax.php', {
        action: 'ajax',
        request: 'getFiltersReportForm',
        reportName: reportName
    }, function(data) {
        if (data.response){
                $("#filtersReport").html(data.filtersReport);
        }
    }, 'json');
}

function enabledDisabledPeriodoCredito(value,formName){
    if(value === '2'){
        $('form[name='+formName+'] #diasCredito').prop('disabled',false);
    }else if(value === '1'){
        $('form[name='+formName+'] #diasCredito').prop('disabled',true);
    }
}

function showHideFieldCheck(){ 
    var cliente = $('#cliente').val();
    var formaPago = $('#formaPago').val();  
    $('#numCheque').val('');
    
    $.post('/Controller/Cobro.php', {
        action: 'ajax',
        request: 'getNotasCreditoDisponibleByCliente',
        cliente: cliente,
        formaPago: formaPago
    }, function(data) {
        if (data.response){
            $("#divNumCheque").html(data.element);
        }
        
        if(formaPago === '6'){
             $('#cuentaBancaria').prop('disabled',true);
        }else{
             $('#cuentaBancaria').val('');
             $('#cuentaBancaria').prop('disabled',false);
        }
    }, 'json');    
}

function setMontoCobro(){
    var value = $('#numCheque').val().split('-');
    $('#monto').val(value[1]);    
}

function showHideFieldNameToPrint(){
    var formaPago = $('#formaPago').val();  
    
    if(formaPago === '4'){
         $('#div-nameToPrint').show();
    }else{
         $('#div-nameToPrint').hide();
    }
}


/***********************/
/***** SHIPMENT ********/
/***********************/

function setShipmentDetalles(){
    var producto = $("#producto").val();
    var cantidad = $("#cantidad").val();
    var color = $("#color").val();
    var etiqueta = $("#etiqueta").val();
    var cuentaContable = $("#cuentaContable").val();
    
    $.post('/Controller/Shipment.php', {
        action: 'ajax',
        request: 'setVentaDetalles',
        producto: producto,
        cantidad: cantidad,
        color: color,
        etiqueta: etiqueta,
        cuentaContable: cuentaContable
    }, function(data) {
        if (data.response){
                $("#shipmentDetalles").html(data.shipmentDetalles);
                $("#montoTotal").html(data.montoTotal);
                $("#cajasTotal").html(data.cajasTotal);
                $("#autocomplete-producto").focus();
                $("#autocomplete-producto").val('');
                $("#producto").val('');
                $('#cantidad').val('1');               
                $('#etiqueta').val('');
                $('#color').val('');
                scrollStart('scroll-items');
        }else{
                $('#flashmessenger').html(data.message);
                fadeOutAlert();
        }
    }, 'json');
}

function getListShipmentDetalles(){
    $.post('/Controller/Shipment.php', {
        action: 'ajax',
        request: 'getListShipmentDetalles'
    }, function(data) {
        if (data.response){
                parent.window.opener.$("#shipmentDetalles").html(data.shipmentDetalles);
                parent.window.opener.$("#cajasTotal").html(data.cajasTotal);
                parent.window.opener.$("#autocomplete-producto").focus();
                parent.window.opener.$("#autocomplete-producto").val('');
                parent.window.opener.$("#producto").val('');
                parent.window.opener.$('#cantidad').val('1');
                //scrollStart();
                window.close();
        }
    }, 'json');
}

function deleteShipmentDetalles(id){ 
    if(confirm('Esta seguro de eliminar este producto ?') === false){return null;}
    $.post('/Controller/Shipment.php', {
        action: 'ajax',
        request: 'deleteDetalles',
        id: id
    }, function(data) {
        if (data.response){
                $("#shipmentDetalles").html(data.shipmentDetalles);
                $("#cajasTotal").html(data.cajasTotal);
                $("#autocomplete-producto").focus();
                $("#autocomplete-producto").val('');
                $("#producto").val('');
                $('#cantidad').val('1');
                scrollStart();
        }else{
            $("#flashmessenger").html(data.mensaje);
            $("#autocomplete-producto").focus();
        }
    }, 'json');
}

function onEnterShipment(ev,element){
    if(ev === 13){ 
        switch(element){
            case 'producto':
                $('#cantidad').focus();
                $('#cantidad').select();
                $('form[name=shipment]').submit(function(){return false;});
                break;
                
            case 'cantidad':
                $('#etiqueta').focus();
                $('#etiqueta').select();
                $('form[name=shipment]').submit(function(){return false;});
                break;
                
            case 'etiqueta':
                $('#buscar').focus();
                $('#buscar').select();
                $('form[name=shipment]').submit(function(){return false;});
                break;
        }
     }   
}
/****************************/
/***** END SHIPMENT ********/
/***************************/

/***********************/
/******** COMPRAS *******/
/***********************/

function setMetodoPago(onlyCredit){
    if($('#proveedor').val()===''){
        $('#metodoPago').val('0');
        $('#diasCredito').val('');
        $('#fechaPago').val('');
        return null;
    }
    var idProveedor = $('#proveedor').val();
    var fechaCompra = $('#fecha').val();
    
    $.post('/Controller/Compra.php', {
        action: 'ajax',
        request: 'setMetodoPago',
        idProveedor: idProveedor,
        fechaCompra: fechaCompra
    }, function(data) {
        if (data.response){
            if(data.metodoPago === '1' && onlyCredit === true){$('#fechaPago').val('');return null;}
            if(data.metodoPago === '2'){
                $('#diasCredito').prop('disabled',false);
            }else if(data.metodoPago === '1'){
                $('#diasCredito').prop('disabled',true);
            }
               $('#metodoPago').val(data.metodoPago);
               $('#fechaPago').val(data.fechaPago);
               $('#diasCredito').val(data.diasCredito);
        }
    }, 'json');
}

function setFechaPago(){
    var fechaCompra = $('#fecha').val();
    var diasCredito = $('#diasCredito').val();
    
    $.post('/Controller/Compra.php', {
        action: 'ajax',
        request: 'setFechaPago',
        fechaCompra: fechaCompra,
        diasCredito: diasCredito
    }, function(data) {
        if (data.response){
               $('#fechaPago').val(data.fechaPago);
        }
    }, 'json');
} 

function onChangeMetodoPago(){
    var metodoPago = $('#metodoPago').val();
    
    if(metodoPago === '1'){        
        $('#diasCredito').val('');
        $('#fechaPago').val('');
        $('#diasCredito').prop('disabled',true);
    }else if(metodoPago === '2'){
        $('#diasCredito').prop('disabled',false);
        setMetodoPago(true);
    }
}

function setCompraDetalles(){ 
    var idDetalleTemp = $("#idDetalleTemp").val();
    var producto = $("#producto").val();
    var cantidad = $("#cantidad").val();
    var punitariocompra = $("#punitariocompra").val();
    var tipo = $("#tipo").val();
    var etiqueta = $("#etiqueta").val();
    var cuentaContable = $("#cuentaContable").val();
    var afectaLote = $("#afectaLote").val();
    var nombreGasto = $("#nombreGasto").val(); 
    
    $.post('/Controller/Compra.php', {
        action: 'ajax',
        request: 'setCompraDetalles',
        idDetalleTemp:idDetalleTemp,
        producto: producto,
        cantidad: cantidad,
        punitariocompra: punitariocompra,
        tipo:tipo,
        etiqueta:etiqueta,
        cuentaContable: cuentaContable,
        afectaLote:afectaLote,
        nombreGasto:nombreGasto
        
    }, function(data) {
        if (data.response){
                $("#compraDetalles").html(data.compraDetalles);
                $("#montoTotal").html(data.montoTotal);
                $("#cajasTotal").html(data.cajasTotal);
                 $('#idDetalleTemp').val('');
                $('#producto').val('');
                $('#afectaLote').val('');
                $('#nombreGasto').val('');
                $('#punitariocompra').val('');
                $('#autocomplete-cuentaContable').val('');    
                $('#autocomplete-producto').val('');      
                $('#autocomplete-producto').focus();
                $('#autocomplete-afectaLote').val('');    
                $('#autocomplete-afectaLote').val('');      
                $('#cantidad').val('1');
                $('#etiqueta').val('');
                scrollStart('scroll-items');
        }else{
            $('#flashmessenger').html(data.message);
            fadeOutAlert();
        }
    }, 'json');
}

function setDetalleCompraToEdit(data){
    for (var name in data) {
        $('form[name=compra] #'+name).val(data[name]);
    } 
    
    var type = $("form[name=compra] #tipo").val();
    
    if(type === 'Producto'){
        if(data['producto']){
            $("#producto").combobox("destroy");
            $("#producto").combobox(); 
        }
    }else{
        if(data['afectaLote']){
        $("#afectaLote").combobox("destroy");
        $("#afectaLote").combobox(); 
        }

       if(data['cuentaContable']){ 
            $("#cuentaContable").combobox("destroy");
            $("#cuentaContable").combobox(); 
       }
    }
}

function deleteDetalles(id){ 
    if(confirm('Esta seguro de eliminar este producto ?') === false){return null;}
    $.post('/Controller/Compra.php', {
        action: 'ajax',
        request: 'deleteDetalles',
        id: id
    }, function(data) {
        if (data.response){
                //$("#flashmessenger").html(data.mensaje);
                $("#compraDetalles").html(data.compraDetalles);
                $("#montoTotal").html(data.montoTotal);
                $("#cajasTotal").html(data.cajasTotal);
                $("#autocomplete-producto").focus();
                $('#cantidad').val('1');
                scrollStart('scroll-items');
        }else{
            $("#flashmessenger").html(data.mensaje);
            $("#autocomplete-producto").focus();
        }
    }, 'json');
}

function getListCompraDetalles(){
    $.post('/Controller/Compra.php', {
        action: 'ajax',
        request: 'getListCompraDetalles'
    }, function(data) {
        if (data.response){
                parent.window.opener.$("#compraDetalles").html(data.compraDetalles);
                parent.window.opener.$("#montoTotal").html(data.montoTotal);
                parent.window.opener.$("#cajasTotal").html(data.cajasTotal);
                parent.window.opener.$("#autocomplete-producto").focus();
                parent.window.opener.$("#autocomplete-producto").val('');
                parent.window.opener.$("#producto").val('');
                parent.window.opener.$('#cantidad').val('1');
                scrollStart('scroll-items');
                document.location.refresh();
        }
    }, 'json');
}

function clearOtroPrecio(){
    $('#otroPrecio').val('');
}

function clearFormProductoComun(){
    $("#pc_descripcion").val('');
    $("#pc_cantidad").val('');
    $("#pc_precio").val('');
    $("#pc_punitariocompra").val('');
    
    $("#producto").focus();
    $("#producto").val('');
    $('#cantidad').val('1');
}

function onEnter(ev,element){
    if(ev === 13){ 
        switch(element){
            case 'producto':
                $('#cantidad').focus();
                $('#cantidad').select();
                $('form[name=compra]').submit(function(){return false;});
                break;
                
            case 'cantidad':
                $('#punitariocompra').focus();
                $('#punitariocompra').select();
                $('form[name=compra]').submit(function(){return false;});
                break;
                
             case 'punitariocompra':
                $('#buscar').focus();
                $('#buscar').select();
                $('form[name=compra]').submit(function(){return false;});
                break;
        }
     }   
}

/* GASTOS DE COMPRA*/
function showGastoCompra(expenseName){
     $('#modalAgregarGastoCompra').modal('show');
     $('#flashmessenger-gastoCompra').html(''); 
     clearForm('gastoCompra');
     $('form[name=gastoCompra] #terminar').prop('disabled',false);     
     $("form[name=gastoCompra] #afectaLote").combobox(); 
     
    $.post('/Controller/Compra.php', {
        action: 'ajax',
        expenseName: expenseName,
        request: 'getDataByExpenseName'
    }, function(data) {
        if (data.response){
            $('form[name=gastoCompra] #cuentaContable').val(data.cuentaContable);
            $('form[name=gastoCompra] #descripcion').val(data.descripcion);
            $('form[name=gastoCompra] #nombreGasto').val(expenseName);
            $('#expensesList').html(data.listExpensesString);
        
        }
    }, 'json');
}

function setGastoCompra(data){
    var disabled = false;
    if(data['status']==='3'){  
        disabled = true;
    }
    for (var name in data) {
        $('form[name=gastoCompra] #'+name).val(data[name]);
        $('form[name=gastoCompra] #'+name).prop('disabled',disabled);
        $('form[name=gastoCompra] #fechaGasto').prop('disabled',disabled);
        $('form[name=gastoCompra] #terminar').prop('disabled',disabled);
    } 
    
    $("form[name=gastoCompra] #afectaLote").combobox("destroy");
    $("form[name=gastoCompra] #afectaLote").combobox(); 
   
}

function clearGastoCompra(gastoVenta){
    clearForm('gastoCompra');
    $('#flashmessenger-gastoCompra').html('');  
    $('#modalAgregarGastoCompra').modal('hide');
    
    $.post('/Controller/Compra.php', {
        action: 'ajax',
        request: 'getElementsGastosCompraForm',
        gastoVenta:gastoVenta
    }, function(data) {
        if (data.response){      
            $("#formElements").html(data.elementsFormString); 
            $("#fechaGasto").datepicker({
                dateFormat: 'mm/dd/yy',
                showWeek:true,
                changeMonth:true,
                changeYear: true});
        }
    }, 'json');    
}

function saveTempGastoCompra(gastoVenta){
    var options = $("form[name='gastoCompra']").serializeArray();   
    options.push({name: 'fecha', value:$('#fechaGasto').val()}); 
    
    $.post('/Controller/Compra.php', {
        action: 'ajax',
        request: 'saveTempGastoCompra',
        gastoVenta:gastoVenta,
        options: options
    }, function(data) {
        if (data.response){
               $('#'+data.nombreGasto).val(data.totalGasto);
               clearGastoCompra();
        }else{  
            $('#flashmessenger-gastoCompra').html(data.message);
            $("#formElements").html(data.formString);   
            $("form[name=gastoCompra] #afectaLote").combobox(); 
            $("#fechaGasto").datepicker({
                dateFormat: 'mm/dd/yy',
                showWeek:true,
                changeMonth:true,
                changeYear: true});
        }
    }, 'json');
}

function deleteGastoCompra(id){
    clearForm('gastoCompra');
    $('#flashmessenger-gastoCompra').html('');
    var nombreGasto = $('#nombreGasto').val();
    
    $.post('/Controller/Compra.php', {
        action: 'ajax',
        request: 'deleteGastoCompraById',
        id: id,
        nombreGasto: nombreGasto
    }, function(data) {     
        $('#flashmessenger-gastoCompra').html(data.message);
        if(data.response){
            $('#expensesList').html(data.listExpensesString);
            $('#'+data.nombreGasto).val(data.totalGasto);
        }
        
    }, 'json');    
}

function cancelPurchase(idCompra,link){   
    BootstrapDialog.confirm({
        message: function(dialog){
                    _getTranslation('Esta seguro de cancelar este registro ?',function(msj){dialog.setMessage(msj);});
                },
        callback: function(result){
            if(result){
                   showPymtOfPurchase(idCompra,function(callback){       
                     if(callback.response){     
                         var pymtListDialog = new BootstrapDialog({
                                     type: BootstrapDialog.TYPE_WARNING,
                                     title: function(dialog){
                                                _getTranslation('This invoice has payments registered. Can not be deleted.',function(msj){dialog.setTitle(msj);});
                                            },
                                     draggable: true,
                                     message: callback.showPymtOfPurchase,
                                     buttons: [{
                                         label: 'Close',
                                         cssClass: 'btn-default',
                                         action: function(dialogRef){ 
                                             dialogRef.close();
                                         }
                                     }]
                                 });
                         pymtListDialog.open();            
                     }else{
                          $("#iframe").attr("src", link.href);
                          $("#iframe").load();
                     }
                 });
            } 
         }
     });    
    return false;
}

function showPymtOfPurchase(idCompra,callback){
    $.post('/Controller/Compra.php', {
        action: 'ajax',
        request: 'showPymtOfPurchase',
        idCompra: idCompra
    }, function(data) {
           callback(data);  
    }, 'json');
}

/****************************/
/******** END COMPRAS *******/
/***************************/

/***********************/
/******** CONSIGNAS *******/
/***********************/

function setConsignaDetalles(){
    var idDetalleTemp = $("#idDetalleTemp").val();
    var producto = $("#producto").val();
    var cantidad = $("#cantidad").val();
    var punitariocompra = $("#punitariocompra").val();
    var tipo = $("#tipo").val();
    var etiqueta = $("#etiqueta").val();
    var cuentaContable = $("#cuentaContable").val();
    
    $.post('/Controller/Consigna.php', {
        action: 'ajax',
        request: 'setConsignaDetalles',
        producto: producto,
        cantidad: cantidad,
        punitariocompra: punitariocompra,
        tipo:tipo,
        etiqueta:etiqueta,
        cuentaContable: cuentaContable,
        idDetalleTemp:idDetalleTemp
    }, function(data) {
        if (data.response){
                $("#consignaDetalles").html(data.consignaDetalles);
                $("#montoTotal").html(data.montoTotal);
                $("#cajasTotal").html(data.cajasTotal);
                $("#producto").val('');
                $('#punitariocompra').val('');
                $("#autocomplete-producto").val('');     
                $("#autocomplete-producto").focus();
                $('#autocomplete-cuentaContable').val('');   
                $('#cantidad').val('1');
                $('#etiqueta').val('');
                scrollStart('scroll-items');
        }else{
            $('#flashmessenger').html(data.message);
            fadeOutAlert();
        }
    }, 'json');
}

function setDetalleConsignaToEdit(data){
    for (var name in data) {
        $('form[name=consigna] #'+name).val(data[name]);
    } 
    $("#cuentaContable").combobox("destroy");
    $("#cuentaContable").combobox(); 
    
    $("#producto").combobox("destroy");
    $("#producto").combobox(); 
}

function deleteDetallesConsigna(id){ 
    if(confirm('Esta seguro de eliminar este producto ?') === false){return null;}
    $.post('/Controller/Consigna.php', {
        action: 'ajax',
        request: 'deleteDetalles',
        id: id
    }, function(data) {
        if (data.response){
                //$("#flashmessenger").html(data.mensaje);
                $("#consignaDetalles").html(data.consignaDetalles);
                $("#montoTotal").html(data.montoTotal);
                $("#cajasTotal").html(data.cajasTotal);
                $("#producto").focus();
                $("#producto").val('');
                $('#cantidad').val('1');
                scrollStart('scroll-items');
        }else{
            $("#flashmessenger").html(data.mensaje);
            $('input[name=producto]').focus();
        }
    }, 'json');
}

function getListConsignaDetalles(){
    $.post('/Controller/Consigna.php', {
        action: 'ajax',
        request: 'getListConsignaDetalles'
    }, function(data) {
        if (data.response){
                parent.window.opener.$("#consignaDetalles").html(data.consignaDetalles);
                parent.window.opener.$("#montoTotal").html(data.montoTotal);
                parent.window.opener.$("#cajasTotal").html(data.cajasTotal);
                parent.window.opener.$("#producto").focus();
                parent.window.opener.$("#producto").val('');
                parent.window.opener.$('#cantidad').val('1');
                //scrollStart();
                window.close();
        }
    }, 'json');
}

function validateFormLiquidacion(){ 
    var options = $("form[name=liquidacion]").serializeArray();    
   
    $.post('/Controller/Consigna.php', {
        action: 'ajax',
        request: 'validateFormLiquidacion',
        options:options         
    }, function(data) {
        if (data.response){
           submit('liquidacion');
        }else{ 
            $('#flashmessenger-liquidacion').html(data.message);
            $("#formElementsLiquidacion").html(data.formString);   
            showHideFieldNameToPrint();
        }
    }, 'json');
}

function getSummaryAndConsignmentPymt(){  
    var idConsignment = $('form[name=liquidacion] #idConsigna').val();
    $.post('/Controller/Consigna.php', {
        action: 'ajax',
        request: 'getSummaryAndConsignmentPymt',
        idConsignment:idConsignment
    }, function(data) {
        if (data.response){
            $('#listConsigmentPayment').html(data.listConsigmentPayment); 
            $('#summaryLiquidation').html(data.summaryLiquidation);            
        }
    }, 'json');
}

function setConsignmentPayment(data){
    var disabled = false;
    if(data['status']==='2'){  
        disabled = true;
    }
    for (var name in data) {
        $('form[name=liquidacion] #'+name).val(data[name]);
        $('form[name=liquidacion] #'+name).prop('disabled',disabled);
        $('form[name=liquidacion] #fechaLiquidacion').prop('disabled',disabled);
        $('form[name=liquidacion] #pagar').prop('disabled',disabled);
    }   
    showHideFieldNameToPrint();
}

function deleteConsignmentPayment(refPago){
    var idConsigna = $('form[name=liquidacion] #idConsigna').val();
    $.post('/Controller/Consigna.php', {
        action: 'ajax',
        request: 'deleteConsignmentPayment',
        refPago:refPago,
        idConsigna: idConsigna
    }, function(data) {
        if (data.response){
            $('#flashmessenger-liquidacion').html(data.msg); 
            getSummaryAndConsignmentPymt();
            $('#pymtStatus').html(data.statusPago);
        }
    }, 'json'); 
}

function resetLiquidationModal(){    
     $('#flashmessenger-liquidacion').html(''); 
     $.post('/Controller/Consigna.php', {
        action: 'ajax',
        request: 'getElementsLiquidacionForm'        
    }, function(data) {
        if (data.response){
          $("#formElementsLiquidacion").html(data.elementsFormString); 
          showHideFieldNameToPrint();
          $("#fechaLiquidacion").datepicker({
                dateFormat: 'mm/dd/yy',
                showWeek:true,
                changeMonth:true,
                changeYear: true});
        }
    }, 'json');    
}
/****************************/
/******** END CONSIGNAS *******/
/***************************/

/***********************/
/******** VENTAS *******/
/***********************/

function hasDueInvoice(){
    var idCliente = $('#cliente').val();
    var idVenta = $("form[name='venta'] input[name='id']").val();
   
    $.post('/Controller/Venta.php', {
        action: 'ajax',
        request: 'getDueInvoice',
        idCliente: idCliente,
        idVenta: idVenta
    }, function(data) {
        if (data.response){
            BootstrapDialog.show({
                type: BootstrapDialog.TYPE_WARNING,
                closable: false,
                title: function (dialog){
                    _getTranslation('Alerta! Este cliente tiene factura(s) vencida(s)',function(msj){dialog.setTitle(msj);})
                },
                message: data.mensaje,
                buttons: [{
                    label: 'Close',
                    cssClass: 'btn-default',
                    action: function(dialogRef){
                        $("#cliente").val('');
                        dialogRef.close();
                    }},{
                    label: 'Approve Sale',
                    cssClass: 'btn-success',
                    action: function(dialogItself){                      
                        var approveSale = new BootstrapDialog({
                                    type: BootstrapDialog.TYPE_GRAPEAPP,
                                    title: function(dialog){
                                        _getTranslation('Clave para aprobar venta.',function(msj){dialog.setTitle(msj)})
                                    },
                                    message: function(dialog){
                                        _getTranslation('Por favor ingrese clave para aprobar esta venta: ',function(msj){dialog.setMessage(msj+' <input id="keyToApproveSale" type="password" class="form-control" />')})
                                    },
                                    buttons: [{
                                        label: 'Cancel',
                                        cssClass: 'btn-default',
                                        action: function(dialogRef){
                                            $("#cliente").val('');  
                                            dialogRef.close();
                                        }
                                    },{
                                        label: 'Approve',
                                        cssClass: 'btn-success',
                                        action: function(dialogRef){
                                            validateKeyToApproveSale($('#keyToApproveSale').val(),function(callback){
                                                if(callback.response){
                                                    BootstrapDialog.closeAll();
                                                }else{
                                                   dialogRef.setMessage("<div style='margin-bottom:10px'>"+callback.msg+"</div>" + msg);
                                                }                                                
                                            });                
                                        }
                                    }]
                                });
                        approveSale.open();
                    }
                }]
            });
        }
    }, 'json');
}

function validateKeyToApproveSale(key,callback){
        $.post('/Controller/Venta.php', {
        action: 'ajax',
        request: 'validateKeyToApproveSale',
        key: key
    }, function(data) {
          callback(data);        
    }, 'json');
}

function cancelSale(idVenta,link){   
    BootstrapDialog.confirm({
        message: function(dialog){
                    _getTranslation('Esta seguro de cancelar este registro ?',function(msj){dialog.setMessage(msj);});
                },
        callback: function(result){
            if(result){
                   showPymtReceived(idVenta,function(callback){       
                     if(callback.response){     
                         var pymtListDialog = new BootstrapDialog({
                                     type: BootstrapDialog.TYPE_WARNING,
                                     title: function(dialog){
                                                _getTranslation('This invoice has received payments. Can not be deleted.',function(msj){dialog.setTitle(msj);});
                                            },
                                     draggable: true,
                                     message: callback.pymtReceived,
                                     buttons: [{
                                         label: 'Close',
                                         cssClass: 'btn-default',
                                         action: function(dialogRef){ 
                                             dialogRef.close();
                                         }
                                     }]
                                 });
                         pymtListDialog.open();            
                     }else{
                          $("#iframe").attr("src", link.href);
                          $("#iframe").load();
                     }
                 });
            } 
         }
     });    
    return false;
}

function showPymtReceived(idVenta,callback){
    $.post('/Controller/Venta.php', {
        action: 'ajax',
        request: 'showPymtReceived',
        idVenta: idVenta
    }, function(data) {
           callback(data);  
    }, 'json');
}

function setMetodoPagoVenta(onlyCredit){
    if($('#cliente').val()===''){
        $('#metodo_pago').val('0');
        $('#diasCredito').val('');
        $('#fecha_pago').val('');
        return null;
    }
    
    var idCliente = $('#cliente').val();
    var fechaCompra = $('#fecha').val();
    
    $.post('/Controller/Venta.php', {
        action: 'ajax',
        request: 'setMetodoPago',
        idCliente: idCliente,
        fechaCompra: fechaCompra
    }, function(data) {
        if (data.response){
            if(data.metodoPago === '1' && onlyCredit === true){$('#fecha_pago').val('');return null;}
            if(data.metodoPago === '2'){
                $('#diasCredito').prop('disabled',false);
            }else if(data.metodoPago === '1'){
                $('#diasCredito').prop('disabled',true);
            } 
               $('#metodo_pago').val(data.metodoPago);               
               $('#fecha_pago').val(data.fechaPago);
               $('#diasCredito').val(data.diasCredito);
        }
    }, 'json');
}

function setFechaPagoVenta(){
    var fechaCompra = $('#fecha').val();
    var diasCredito = $('#diasCredito').val();
    
    $.post('/Controller/Venta.php', {
        action: 'ajax',
        request: 'setFechaPago',
        fechaCompra: fechaCompra,
        diasCredito: diasCredito
    }, function(data) {
        if (data.response){
               $('#fecha_pago').val(data.fechaPago);
        }
    }, 'json');
} 

function getComprador(cliente){  
    $.post('/Controller/Venta.php', {
        action: 'ajax',
        request: 'getComprador',
        cliente:cliente
    }, function(data) {
        if (data.response){
            $('#comprador').val(data.comprador);            
        }
    }, 'json');
}

function onChangeMetodoPagoVenta(){
    var metodoPago = $('#metodo_pago').val();
    
    if(metodoPago === '1'){        
        $('#diasCredito').val('');
        $('#fecha_pago').val($('#fecha').val());
        $('#diasCredito').prop('disabled',true);
    }else if(metodoPago === '2'){
        $('#diasCredito').prop('disabled',false);
        setMetodoPagoVenta(true);
    }
}

function setVentaDetalles(){
    var idDetalleTemp = $("#idDetalleTemp").val();
    var producto = $("#producto").val();
    var cantidad = $("#cantidad").val();
    var precio = $("#precio").val();
    var etiqueta = $("#etiqueta").val();
    var tipo_entrada = $("#tipo_entrada").val();
    var referencia = $("#referencia").val();
    var ref_fac = $("#ref_fac").val();
    var punitariocompra = $("form[name=venta] #punitariocompra").val();
    var lote = $("#lote").val();
    var cuentaContable = $("#cuentaContable").val();
    var preventa = $("#preventa").val();
    var cantidadOrigen = $("#cantidadOrigen").val();
    
    $.post('/Controller/Venta.php', {
        action: 'ajax',
        request: 'setVentaDetalles',
        producto: producto,
        cantidad: cantidad,
        precio: precio,
        etiqueta: etiqueta,
        tipo_entrada: tipo_entrada,
        referencia: referencia,
        ref_fac: ref_fac,
        punitariocompra:punitariocompra,
        lote: lote,
        cuentaContable: cuentaContable,
        preventa:preventa,
        idDetalleTemp: idDetalleTemp,
        cantidadOrigen: cantidadOrigen
    }, function(data) {
        if (data.response){
                $("#ventaDetalles").html(data.ventaDetalles);
                $("#montoTotal").html(data.montoTotal);
                $("#cajasTotal").html(data.cajasTotal);
                
                $('#dialogStockPorReferencia').dialog('close');                
                $("#idDetalleTemp").val('');
                $("#cantidadOrigen").val('');
                $("#producto").val('0');
                $('#cantidad').val('1');
                $('#precio').val('');
                $("#tipo_entrada").val('');
                $("#etiqueta").val('');
                $('#referencia').val('');
                $('#ref_fac').val('');
                $("form[name=venta] #punitariocompra").val('');
                $('#lote').val('');
                
                $("#autocomplete-producto").focus();
                $("#autocomplete-producto").val('');
                
                scrollStart('scroll-items');
                
        }else{
            $('#flashmessenger').html(data.message);
            fadeOutAlert();
        }        
    }, 'json');
}

function setDetalleVentaToEdit(data){
    for (var name in data) {
        $('form[name=venta] #'+name).val(data[name]);
    } 
   $("#cuentaContable").combobox("destroy");
   $("#cuentaContable").combobox(); 
    
    if(data['producto']){
        $("#producto").combobox("destroy");
        $("#producto").combobox(); 
    }
}

function setInfoProducto(etiqueta,tipo_entrada,referencia,factura,lote,punitariocompra){
     $('#etiqueta').val(etiqueta);
     $('#tipo_entrada').val(tipo_entrada);
     $('#referencia').val(referencia);
     $('#ref_fac').val(factura);
     /*Viene de formVenta o formMerma*/
     $('form[name=venta] #punitariocompra').val(punitariocompra);
     $('form[name=merma] #punitariocompra').val(punitariocompra);
     
     $('#lote').val(lote);
     
     $('#cantidad').val(1);
     $('#cantidad').select();
     $('#cantidad').focus();
}

function setInfoReferencesByLote(){
    var idProducto =  $('#idProducto').val();
    var etiqueta = $('#etiqueta').val();
    var lote = $('#lote').val();
     
    $.post('/Controller/Venta.php', {
        action: 'ajax',
        request: 'setInfoReferencesByLote',
        idProducto: idProducto,
        etiqueta: etiqueta,
        lote: lote
    }, function(data) {
        if (data.response){
                $('#tipo_entrada').val(data.tipo_entrada);
                $('#referencia').val(data.referencia);
                $('#ref_fac').val(data.ref_fac);
                $('#punitariocompra').val(data.punitariocompra);
        }else{
            $("#flashmessenger").html(data.mensaje);
        }
    }, 'json');
}

function deleteDetallesVenta(id){ 
    if(confirm('Esta seguro de eliminar este producto ?') === false){return null;}
    $.post('/Controller/Venta.php', {
        action: 'ajax',
        request: 'deleteDetalles',
        id: id
    }, function(data) {
        if (data.response){
                //$("#flashmessenger").html(data.mensaje);                
                $("#ventaDetalles").html(data.ventaDetalles);
                $("#montoTotal").html(data.montoTotal);
                $("#cajasTotal").html(data.cajasTotal);
                $('#autocomplete-producto').focus();
                $('#autocomplete-producto').val('');
                $('#producto').val('');
                $('#cantidad').val('1');
                $('#precio').val('');
                scrollStart('scroll-items');
        }else{
            $("#flashmessenger").html(data.mensaje);
            $('#producto').focus();
        }
    }, 'json');
}

function deleteDetallesVentaEdit(id,idVenta){ 
    if(confirm('Esta seguro de eliminar este producto ?') === false){return null;}
    $.post('/Controller/Venta.php', {
        action: 'ajax',
        request: 'deleteDetallesEdit',
        id: id,
        idVenta: idVenta
    }, function(data) {
        if (data.response){
                document.location.reload();
        }else{
            $("#flashmessenger").html(data.mensaje);
            $('#producto').focus();
        }
    }, 'json');
}

function getListVentaDetalles(){
    $.post('/Controller/Venta.php', {
        action: 'ajax',
        request: 'getListVentaDetalles'
    }, function(data) {
        if (data.response){
                parent.window.opener.$("#ventaDetalles").html(data.ventaDetalles);
                parent.window.opener.$("#montoTotal").html(data.montoTotal);
                parent.window.opener.$("#cajasTotal").html(data.cajasTotal);
                parent.window.opener.$("#autocomplete-producto").focus();
                parent.window.opener.$("#autocomplete-producto").val('');
                parent.window.opener.$("#producto").val('');
                parent.window.opener.$('#cantidad').val('1');
                parent.window.opener.$('#precio').val('');
                //scrollStart();
                window.close();
        }
    }, 'json');
}

function clearOtroPrecio(){
    $('#otroPrecio').val('');
}

function clearFormProductoComun(){
    $("#pc_descripcion").val('');
    $("#pc_cantidad").val('');
    $("#pc_precio").val('');
    $("#pc_punitariocompra").val('');
    
    $('#autocomplete-producto').focus();
    $('#autocomplete-producto').val('');
    $('#producto').val('');
    $('#cantidad').val('1');
}

function onEnterVenta(ev,element){
    if(ev === 13){ 
        switch(element){
            case 'producto':
                $('#cantidad').focus();
                $('#cantidad').select();
                $('form[name=venta]').submit(function(){return false;});
                break;
                
            case 'cantidad':
                $('#precio').focus();
                $('#precio').select();
                $('form[name=venta]').submit(function(){return false;});
                break;
                
            case 'precio':
                $('#buscar').focus();
                $('#buscar').select();
                $('form[name=venta]').submit(function(){return false;});
                break;
        }
     }   
}

/****************************/
/******** END VENTAS *******/
/***************************/

/***********************/
/******** MERMAS *******/
/***********************/

function setMermaDetalles(){
    var options = $("form[name='merma'] hidden, input, select").serializeArray();    
    
    $.post('/Controller/Merma.php', {
        action: 'ajax',
        request: 'setMermaDetalles',
       options:options
    }, function(data) {
        if (data.response){
                $("#mermaDetalles").html(data.mermaDetalles);
                $("#montoTotal").html(data.montoTotal);
                $("#cajasTotal").html(data.cajasTotal);
                
                $('#dialogStockPorReferencia').dialog('close'); 
                $("#autocomplete-cuentaContable").val('');
                $("#producto").val('');
                $('#cantidad').val('1');
                $('#etiqueta').val('');
                $('#precio').val('');
                $("#tipo_entrada").val('');
                $('#referencia').val('');
                $('#ref_fac').val('');
                $('#lote').val('');
                $("#autocomplete-producto").focus();
                $("#autocomplete-producto").val('');

                scrollStart('scroll-items');
        }else{
               $('#flashmessenger').html(data.message);
                fadeOutAlert();
        }        
    }, 'json');
}

function setDetalleMermaToEdit(data){
    for (var name in data) {
        $('form[name=merma] #'+name).val(data[name]);
    } 
   $("#cuentaContable").combobox("destroy");
   $("#cuentaContable").combobox(); 

    $("#producto").combobox("destroy");
    $("#producto").combobox(); 
}

function validarAntesActualizar(){
    var producto = $("#idProducto").val();
    var cantidad = $("#cantidad").val();
    var etiqueta = $("#etiqueta").val();
    var tipo_entrada = $("#tipo_entrada").val();
    var referencia = $("#referencia").val();
    var ref_fac = $("#ref_fac").val();
    var lote = $("#lote").val();
    var punitariocompra = $("#punitariocompra").val();
    
    $.post('/Controller/Merma.php', {
        action: 'ajax',
        request: 'validarAntesActualizar',
        producto: producto,
        etiqueta:etiqueta,
        cantidad: cantidad,
        tipo_entrada: tipo_entrada,
        referencia: referencia,
        ref_fac: ref_fac,
        lote: lote,
        punitariocompra:punitariocompra
    }, function(data) {
        if (data.response){
            submit('merma');
        }else{
            $('#flashmessenger').html(data.message);
            fadeOutAlert();
        }        
    }, 'json');
}

function deleteDetallesMerma(id){ 
    if(confirm('Esta seguro de eliminar este producto ?') === false){return null;}
    $.post('/Controller/Merma.php', {
        action: 'ajax',
        request: 'deleteDetalles',
        id: id
    }, function(data) {
        if (data.response){
                //$("#flashmessenger").html(data.mensaje);
                $("#mermaDetalles").html(data.mermaDetalles);
                $("#montoTotal").html(data.montoTotal);
                $("#cajasTotal").html(data.cajasTotal);
                $('#autocomplete-producto').focus();
                $('#autocomplete-producto').val('');
                $('#producto').val('');
                $('#cantidad').val('1');
                $('#precio').val('');
                scrollStart('scroll-items');
        }else{
            $("#flashmessenger").html(data.mensaje);
            $('#producto').focus();
        }
    }, 'json');
}

function getListMermaDetalles(){
    $.post('/Controller/Merma.php', {
        action: 'ajax',
        request: 'getListMermaDetalles'
    }, function(data) {
        if (data.response){
                parent.window.opener.$("#mermaDetalles").html(data.mermaDetalles);
                parent.window.opener.$("#montoTotal").html(data.montoTotal);
                parent.window.opener.$("#cajasTotal").html(data.cajasTotal);
                parent.window.opener.$("#autocomplete-producto").focus();
                parent.window.opener.$("#autocomplete-producto").val('');
                parent.window.opener.$("#producto").val('');
                parent.window.opener.$('#cantidad').val('1');
                parent.window.opener.$('#precio').val('');
                //scrollStart();
                window.close();
        }
    }, 'json');
}

/****************************/
/******** END MERMAS *******/
/***************************/

/***********************************/
/******** MOVIMIENTOS *******/
/*********************************/

function fillRemitenteDestino(tipo){
    onOffDisabled('xyz');
    $.post('/Controller/Banco-movimiento.php', {
        action: 'ajax',
        request: 'getListProveedoresClientes',
        tipo: tipo
    }, function(data) {
        if (data.response){
                $("#remitenteDestino").html(data.list);
        }
    }, 'json');
}

function onOffDisabled(value){
    if(value==='otro'){
        $('#otro').prop('disabled',false);
    }else{
        $('#otro').val('');
        $('#otro').prop('disabled',true);
    }
}

/***********************************/
/******** END MOVIMIENTOS *******/
/*********************************/

/***********************/
/******** MATERIA PRIMA *******/
/***********************/

function showMPPorReferencia(){ 
    var idMP = $('#idMP').val();
    $.post('/Controller/Ajax.php', {
        action: 'ajax-mp',
        request: 'getMPPorReferencia',
        idMP: idMP
    }, function(data) {
        if(data.noShowDialog){return null;}
        if (data.response){
             $('#dialogMPPorReferencia').html(data.message+data.MPPorReferencia);
        }else{
            $('#dialogMPPorReferencia').html(data.message);
        }
        $('#dialogMPPorReferencia').dialog('open');
    }, 'json');
}

function setInfoMP(idMP,tipo_entrada,referencia,punitariocompra){
     $('#tipo_entrada').val(tipo_entrada);
     $('#referencia').val(referencia);
     $('form[name=materiaprima] #punitariocompra').val(punitariocompra);
     $('#autocomplete-producto').val(idMP);
     $('#idMP').val(idMP);
     
     $("form[name=materiaprima] #cantidad").val(1);
     $("form[name=materiaprima] #cantidad").select();
     $("form[name=materiaprima] #cantidad").focus();
}

function setMPDetalles(){
    var keyRelacion = $("#keyRelacion").val();
    var idMP = $("#idMP").val();
    var mppara = $("#mppara").val();
    var cantidad = $("form[name=materiaprima] #cantidad").val();
    var numCajas = $("form[name=compradetalles] #cantidad").val();
    var numPallets = $("form[name=compradetalles] #pallets").val();
    var tipo_entrada = $("#tipo_entrada").val();
    var referencia = $("#referencia").val();
    var punitariocompra = $("form[name=materiaprima] #punitariocompra").val();
    
    $.post('/Controller/Ajax.php', {
        action: 'ajax-mp',
        request: 'setMPDetalles',
        keyRelacion: keyRelacion,
        idMP: idMP,
        mppara: mppara,
        cantidad: cantidad,
        numCajas: numCajas,
        numPallets: numPallets,
        tipo_entrada: tipo_entrada,
        referencia: referencia,
        punitariocompra: punitariocompra
    }, function(data) {
        if (data.response){
                $("#mpDetalles").html(data.mpDetalles);
                $("#montoTotal").html(data.montoTotal);
                $("#cajasTotal").html(data.cajasTotal);
                
                $("#autocomplete-producto").focus();
                $("#autocomplete-producto").val('');
                $("#idMP").val('');
                $('form[name=materiaprima] #cantidad').val('1');
                $('form[name=materiaprima] #punitariocompra').val('');
                $("#tipo_entrada").val('');
                $('#referencia').val('');

                scrollStart('scroll-items');
        }else{
            $('#flashmessenger').html(data.message);
            fadeOutAlert();
        }        
    }, 'json');
}

function deleteDetallesMP(id){ 
    if(confirm('Esta seguro de eliminar este producto ?') === false){return null;}
    $.post('/Controller/Ajax.php', {
        action: 'ajax-mp',
        request: 'deleteDetalles',
        id: id
    }, function(data) {
        if (data.response){               
                $("#mpDetalles").html(data.mpDetalles);
                $("#montoTotal").html(data.montoTotal);
                $("#cajasTotal").html(data.cajasTotal);
                scrollStart('scroll-items');
        }else{
            $("#flashmessenger").html(data.mensaje);
            $('#idMP').focus();
        }
    }, 'json');
}

function deleteDetallesMPEdit(id,idCompra){ 
    if(confirm('Esta seguro de eliminar este producto ?') === false){return null;}
    $.post('/Controller/Ajax.php', {
        action: 'ajax-mp',
        request: 'deleteDetallesEdit',
        id: id,
        idCompra: idCompra
    }, function(data) {
        if (data.response){
                document.location.reload();
        }else{
            $("#flashmessenger").html(data.mensaje);
            $('#idMP').focus();
        }
    }, 'json');
}

function getListVentaDetalles(){
    $.post('/Controller/Venta.php', {
        action: 'ajax',
        request: 'getListVentaDetalles'
    }, function(data) {
        if (data.response){
                parent.window.opener.$("#ventaDetalles").html(data.ventaDetalles);
                parent.window.opener.$("#montoTotal").html(data.montoTotal);
                parent.window.opener.$("#cajasTotal").html(data.cajasTotal);
                parent.window.opener.$("#autocomplete-producto").focus();
                parent.window.opener.$("#autocomplete-producto").val('');
                parent.window.opener.$("#producto").val('');
                parent.window.opener.$('#cantidad').val('1');
                parent.window.opener.$('#precio').val('');
                //scrollStart();
                window.close();
        }
    }, 'json');
}

function onEnterVenta(ev,element){
    if(ev === 13){ 
        switch(element){
            case 'producto':
                $('#cantidad').focus();
                $('#cantidad').select();
                $('form[name=venta]').submit(function(){return false;});
                break;
                
            case 'cantidad':
                $('#precio').focus();
                $('#precio').select();
                $('form[name=venta]').submit(function(){return false;});
                break;
                
            case 'precio':
                $('#buscar').focus();
                $('#buscar').select();
                $('form[name=venta]').submit(function(){return false;});
                break;
        }
     }   
}

/***********************************/
/******** END MATERIA PRIMA *******/
/***********************************/


/***********************************/
/******** ACCOUNTING         *******/
/***********************************/

function listGrupos(){
    var categoria = $('#idCategoria').val();
    $('#nombre').val('');
     
    $.post('/Controller/Ajax.php', {
        action: 'ajax',
        request: 'getListGrupos',
        categoria: categoria
    }, function(data) {
        if (data.response){
                $("#idGrupo").html(data.list);
                listAccountByCategoria();
        }
    }, 'json');
}

function setAccountName(){
    var accountName = $('#idGrupo option:selected').text();
    $('#nombre').val(accountName);
}

function listAccountByCategoria(){
    var categoria = $('#idCategoria').val();
    
    $.post('/Controller/Ajax.php', {
        action: 'ajax',
        request: 'getListAccountsByCategoria',
        categoria: categoria
    }, function(data) {
        if (data.response){
                $("#subAccountOf").html(data.list);
        }
    }, 'json');
}

/***********************************/
/******** COBROS             *******/
/***********************************/

function validaCobroRecibido(elem,saldo){
    var montoCobro = parseFloat(elem.value);
    var saldo = parseFloat(saldo);
    
    if(montoCobro > saldo){ 
        var msj = 'El monto ingresado es mayor al saldo pendiente.';
        $.post('/Controller/Ajax.php', {action: 'ajax',request: 'getTranslation',msj:msj
            }, function(data) {
               BootstrapDialog.alert({
                    message:data.translation,
                    type: BootstrapDialog.TYPE_GRAPEAPP
                });
            }, 'json');
    }else{
        return null;
    }
}

function bouncedCheck(checkNum){   
    $("#checkNum").val(checkNum);
    $.post('/Controller/Cobro.php', {
        action: 'ajax',
        request: 'bouncedCheck',
        checkNum: checkNum
    }, function(data) {
        if (data.response){
            $('#afectedInvoices').html(data.afectedInvoices);
             
        }
    }, 'json');
}

function saveBouncedCheck(){
    var options = $("form[name=chequeRebotado]").serializeArray();
    
    $.post('/Controller/Cobro.php', {
        action: 'ajax',
        request: 'saveBouncedCheck',
        options: options
    }, function(data) {
        if (data.response){
            $('#modalBouncedCheck').modal('hide');
            document.location.reload();
        }else{
            $('#formElements').html(data.formString);
            $('#flashmessenger-bouncedCheck').html(data.message);
        }
    }, 'json');
    
}

function skipBankFee(){
    if( $('#omitir').is(':checked') ) {
        $('.bankFee').prop('disabled',true);
    }else{
        $('.bankFee').prop('disabled',false);   
    }
}

/***********************************/
/******** PAGOS              *******/
/***********************************/
function getListConsignasPendientesPago(){
    var proveedor = $('#proveedor').val();
    var fechaInicio = $('#fecha_inicio').val();
    var fechaFin = $('#fecha_fin').val();
    $.post('/Controller/Consigna.php', {
        action: 'ajax',
        request: 'getListConsignasPorPagarByProveedor',
        proveedor: proveedor,
        fechaInicio: fechaInicio,
        fechaFin: fechaFin
    }, function(data) {
        if (data.response){
            $("#listConsignasPendientesPago").html(data.listConsignasPendientesPago);
        }
    }, 'json');
    $("#listConsignasAPagar").html('');
    setCheckAmount();
    
}

function addConsignaToPayment(trId,elementId){    
    var consignaData = $("#addConsigna_"+trId).children("td").map(function() {
        return $(this).text();
    }).get();

    $.post('/Controller/Consigna.php', {
        action: 'ajax',
        request: 'addConsignaToPayment',
        idConsigna: trId,
        elementId: elementId,
        consignaData: consignaData
    }, function(data) {
        if (data.response){
            $("#listConsignasAPagar").append(data.consigna);
            $('#addConsigna_'+trId).hide();
        }
    }, 'json');
}

function deleteConsignaFromPayment(trId,elementId){
    $('#pago['+elementId+']').remove();
    $('#deleteConsigna_'+trId).remove();
    $('#addConsigna_'+trId).show();
    setCheckAmount();
}

function getLisFacturasProveedor(){
    var proveedor = $('#proveedor').val();
    $.post('/Controller/Pago.php', {
        action: 'ajax',
        request: 'getListCuentasPorPagarByProveedor',
        proveedor: proveedor
    }, function(data) {
        if (data.response){
            $("#listFacturasProveedor").html(data.listFacturas);
        }
    }, 'json');
    $("#listFacturasAPagar").html('');
    setCheckAmount();
}

function addInvoiceToPayment(trId){    
    //$('#listFacturasProveedor .tr_'+trId).hide();
    $.post('/Controller/Pago.php', {
        action: 'ajax',
        request: 'addInvoiceToPayment',
        idCompra: trId
    }, function(data) {
        if (data.response){
            $("#listFacturasAPagar").append(data.factura);
            $('#addInvoice_'+trId).hide();
        }
    }, 'json');
    
}

function deleteInvoiceFromPayment(trId){
    $('#pago['+trId+']').remove();
    $('#deleteInvoice_'+trId).remove();
    $('#addInvoice_'+trId).show();
    setCheckAmount();
}

function setCheckAmount(){
  var pagos = $(".ammountPymt").serializeArray();  
  var checkAmmount = 0;
  $.each(pagos,function(i,pago){
      if($.trim(pago.value) !== ''){
        checkAmmount = parseFloat(checkAmmount) + parseFloat(pago.value);
      }      
  });
  var checkAmmountDecimal = checkAmmount.toFixed(2);
  $('.totalCheckAmmount').html("$"+checkAmmountDecimal.replace(/\B(?=(\d{3})+(?!\d))/g, ","));
}

function setNameToPrintFromPagos(){
    var proveedor = $('#proveedor').val();
    $.post('/Controller/Pago.php', {
        action: 'ajax',
        request:'getNameToPrint',
        proveedor: proveedor
    }, function(data) {
        if (data.response){
            $('#nombreImprimir').val(data.nameToPrint);
        }
    }, 'json');    
}

/***********************************/
/******** COBROS              *******/
/***********************************/
function getLisFacturasClientes(){
    var cliente = $('#cliente').val();
    $.post('/Controller/Cobro.php', {
        action: 'ajax',
        request: 'getListCuentasPorPagarByCliente',
        cliente: cliente
    }, function(data) {
        if (data.response){
            $("#listFacturasCliente").html(data.listFacturas);
        }
    }, 'json');
}

function addInvoiceToPaymentCobro(trId){    
    $('#listFacturasCliente .tr_'+trId).hide();
    $.post('/Controller/Cobro.php', {
        action: 'ajax',
        request: 'addInvoiceToPayment',
        idVenta: trId
    }, function(data) {
        if (data.response){
            var facturas = $("#listFacturasAPagar").html();
            $("#listFacturasAPagar").append(data.factura);
            $('#addInvoice_'+trId).hide();
        }
    }, 'json');
    
}

function deleteInvoiceFromPaymentCobro(trId){
    $('#cobro['+trId+']').remove();
    $('#deleteInvoice_'+trId).remove();
    $('#addInvoice_'+trId).show();
    setCheckAmount();
}

/******************************************/
/********** ASIENTOS DE DIARIO ************/
/******************************************/

function addAsientoRow(){    
    var index = $('#index').val();
    $.post('/Controller/Asiento.php', {
        action: 'ajax',
        request: 'addRow',
        index: index
    }, function(data) {
        if (data.response){
            $("#asientosRow").append(data.row);
            index++;
            $('#index').val(index);
        }
    }, 'json');    
}

function deleteAsientoRow(index){
    $('#index_'+index).remove();
}

function fillClienteProveedor(index){
    var tipo = $("select[name='asiento["+index+"][cuentaContable]']").val();
    
    $.post('/Controller/Asiento.php', {
        action: 'ajax',
        request: 'getListProveedoresClientes',
        tipo: tipo
    }, function(data) {
        if (data.response){
            $("select[name='asiento["+index+"][cliente_proveedor]']").html(data.list);
        }
    }, 'json');
}

function clearAsientoRow(index){
    $(".index_"+index).val("");
}

/************* NOTAS DE CREDITO **************/

function listVentasByCliente(){
    var cliente = $('#cliente').val();
    $.post('/Controller/NotaCredito.php', {
        action: 'ajax',
        request: 'listVentasByCliente',
        cliente: cliente
    }, function(data) {
        if (data.response){
                $("#idVenta").html(data.listVentas);
        }
    }, 'json');
}

function setFieldToRefund(){
     var aplicarComo = $('#aplicar_como').val();
     if(aplicarComo === '2'){ 
         $('.reembolso-field').prop('disabled',false);    
     }else{
         var tipo = $('#tipo').val();
         if(tipo!== '1'){$('#monto').removeClass('reembolso-field');}
         
         $('.reembolso-field').prop('disabled',true);  
         $('.reembolso-field').val('');  
         
        // $('#monto').removeClass('reembolso-field');
         $('#monto').addClass('reembolso-field');
     }
}

function setInfoToTipo(){
    var idVenta = $('#idVenta').val();
    var tipo = $('#tipo').val();
    /* tipo = 2 son descuentos*/
    $("#detalles").html('');
   
    if(tipo === '1'){
        $('#monto').prop('disabled',true);
        $.post('/Controller/NotaCredito.php', {
            action: 'ajax',
            request: 'getDetallesFactura',
            idVenta: idVenta
        }, function(data) {
            if (data.response){
                $("#detalles").html(data.listDetalles);
            }
        }, 'json');
    }else if(tipo === '3'){
        $('#monto').prop('disabled',true);
        $.post('/Controller/NotaCredito.php', {
            action: 'ajax',
            request: 'getCobrosFactura',
            idVenta: idVenta
        }, function(data) {
            if (data.response){
                $("#detalles").html(data.listDetalles);
            }
        }, 'json');
    }
    
    if(tipo === '2'){ 
         $('#monto').prop('disabled',false);
    }
}

function setNameToPrintFromNC(){
    var cliente = $('#cliente').val();
    $.post('/Controller/NotaCredito.php', {
        action: 'ajax',
        request:'getNameToPrint',
        cliente: cliente
    }, function(data) {
        if (data.response){
            $('#nombreImprimir').val(data.nameToPrint);
        }
    }, 'json');    
}

//************* CHEQUES ***********************//
function addCuentaRow(){    
    var index = $('#index').val();
    $.post('/Controller/Cheque.php', {
        action: 'ajax',
        request: 'addRow',
        index: index
    }, function(data) {
        if (data.response){
            $("#cuentasRow").append(data.row);
            index++;
            $('#index').val(index);
        }
    }, 'json');    
}

function clearCuentaRow(index){
    $(".index_"+index).val("");
}

function deleteCuentaRow(index){
    $('#index_'+index).remove();
}

function setNameToPrint(){
    var pagarA = $('#pagarA').val();
    $.post('/Controller/Cheque.php', {
        action: 'ajax',
        request:'getNameToPrint',
        nameToPrint: pagarA
    }, function(data) {
        if (data.response){
            $('#nombreImprimir').val(data.nameToPrint);
        }
    }, 'json');     
}


/*PREVENTAS*/
function setPreventaDetalles(){
    var idDetalleTemp = $("#idDetalleTemp").val();
    var producto = $("#producto").val();
    var cantidad = $("#cantidad").val();
    var precio = $("#precio").val();
    var etiqueta = $("#etiqueta").val();
    var tipo_entrada = $("#tipo_entrada").val();
    var referencia = $("#referencia").val();
    var ref_fac = $("#ref_fac").val();
    var punitariocompra = $("form[name=venta] #punitariocompra").val();
    var lote = $("#lote").val();
    var cuentaContable = $("#cuentaContable").val();
    var preventa = $("#preventa").val();
    var cantidadOrigen = $("#cantidadOrigen").val();
    
    $.post('/Controller/Preventa.php', {
        action: 'ajax',
        request: 'setVentaDetalles',
        producto: producto,
        cantidad: cantidad,
        precio: precio,
        etiqueta: etiqueta,
        tipo_entrada: tipo_entrada,
        referencia: referencia,
        ref_fac: ref_fac,
        punitariocompra:punitariocompra,
        lote: lote,
        cuentaContable: cuentaContable,
        preventa:preventa,
        idDetalleTemp: idDetalleTemp,
        cantidadOrigen: cantidadOrigen
    }, function(data) {
        if (data.response){
                $("#ventaDetalles").html(data.ventaDetalles);
                $("#montoTotal").html(data.montoTotal);
                $("#cajasTotal").html(data.cajasTotal);
                
                $('#dialogStockPorReferencia').dialog('close');                
                $("#idDetalleTemp").val('');
                $("#cantidadOrigen").val('');
                $("#producto").val('');
                $('#cantidad').val('1');
                $('#precio').val('');
                $("#tipo_entrada").val('');
                $("#etiqueta").val('');
                $('#referencia').val('');
                $('#ref_fac').val('');
                $("form[name=venta] #punitariocompra").val('');
                $('#lote').val('');
                
                $("#autocomplete-producto").focus();
                $("#autocomplete-producto").val('0');
                
                scrollStart('scroll-items');
                
        }else{
            $('#flashmessenger').html(data.message);
            fadeOutAlert();
        }        
    }, 'json');
}

function setDetallePreventaToEdit(data){
    for (var name in data) {
        $('form[name=venta] #'+name).val(data[name]);
    } 
   $("#cuentaContable").combobox("destroy");
   $("#cuentaContable").combobox(); 
    
    if(data['producto']){
        $("#producto").combobox("destroy");
        $("#producto").combobox(); 
    }
}

function deleteDetallesPreventa(id){ 
    if(confirm('Esta seguro de eliminar este producto ?') === false){return null;}
    $.post('/Controller/Preventa.php', {
        action: 'ajax',
        request: 'deleteDetalles',
        id: id
    }, function(data) {
        if (data.response){
                //$("#flashmessenger").html(data.mensaje);
                
                $("#ventaDetalles").html(data.ventaDetalles);
                $("#montoTotal").html(data.montoTotal);
                $("#cajasTotal").html(data.cajasTotal);
                $('#autocomplete-producto').focus();
                $('#autocomplete-producto').val('');
                $('#producto').val('');
                $('#cantidad').val('1');
                $('#precio').val('');
                scrollStart('scroll-items');
        }else{
            $("#flashmessenger").html(data.mensaje);
            $('#producto').focus();
        }
    }, 'json');
}

function deleteDetallesPreventaEdit(id,idPreventa){ 
    if(confirm('Esta seguro de eliminar este producto ?') === false){return null;}
    $.post('/Controller/Preventa.php', {
        action: 'ajax',
        request: 'deleteDetallesEdit',
        id: id,
        idPreventa: idPreventa
    }, function(data) {
        if (data.response){
            document.location.reload();
        }else{
            $("#flashmessenger").html(data.mensaje);
            $('#producto').focus();
        }
    }, 'json');
}

/* Import Bank transaction from excel*/

function saveReplacement(){
    var options = $(".import").serializeArray();
    $.post('/Controller/Ajax.php', {
        action: 'ajax',
        request: 'saveReplacement',
        options: options
    }, function(data) {
        if (data.response){
           $("#import-conflicts").html('');
           $("#flashmessenger").html(data.msg);
        }else{
            $("#flashmessenger").html(data.msg);
        }
    }, 'json');   
}

/* BANKS TRANSACTIONS*/
function setSummarySearchTransactionBank(beginningBalance,countDeposits,totalDeposits,countDebits,totalDebits,endingBalance){
    $('#beginningBalance').html(beginningBalance);
    $('#countDeposits').html(countDeposits);
    $('#totalDeposits').html(totalDeposits);
    $('#countDebits').html(countDebits);
    $('#totalDebits').html(totalDebits);
    $('#endingBalance').html(endingBalance);
}

/* CONCILIATION BANKS*/
function setSummaryConciliation(key,transaction,checkUnckeckAll){
    var element  = $("input[name='"+key+"']");
    var value = element.val().split('|');

    var withdrawalCount = parseFloat($('#withdrawalCount').html());
    var depositCount = parseFloat($('#depositCount').html());
    var withdrawalSum = parseFloat($('#withdrawalSum').html().replace(',',''));
    var depositSum = parseFloat($('#depositSum').html().replace(',',''));

    if(element.is(':checked')) { 
        element.removeClass('unChecked');
        element.addClass('checked');
        if(transaction.toLowerCase() === 'retiro'){
            withdrawalCount++;            
            $('#withdrawalCount').html(withdrawalCount);            
            
            withdrawalSum += parseFloat(value[2]);   
            var withdrawalSumDecimal = withdrawalSum.toFixed(2);
            $('#withdrawalSum').html(withdrawalSumDecimal.replace(/\B(?=(\d{3})+(?!\d))/g, ","));
            
            var unChecked = $('.retiro.unChecked').length;          
            if(unChecked > 0){
                $("#checkAllDebits").prop('checked',false);
            }else{
                $("#checkAllDebits").prop('checked',true);
            }           
            
        }else if(transaction.toLowerCase() === 'deposito'){
            depositCount++;
            $('#depositCount').html(depositCount);
            
            depositSum += parseFloat(value[2]);   
            var depositSumDecimal = depositSum.toFixed(2);
            $('#depositSum').html(depositSumDecimal.replace(/\B(?=(\d{3})+(?!\d))/g, ","));
            
            var unChecked = $('.deposito.unChecked').length;          
            if(unChecked > 0){
                $("#checkAllCredits").prop('checked',false);
            }else{
                $("#checkAllCredits").prop('checked',true);
            }     
        }
    }else{
        element.removeClass('checked');
        element.addClass('unChecked');
        if(transaction.toLowerCase() === 'retiro'){
            withdrawalCount--;
            $('#withdrawalCount').html(withdrawalCount);
      
            withdrawalSum -= parseFloat(value[2]);   
            var withdrawalSumDecimal = withdrawalSum.toFixed(2);
            $('#withdrawalSum').html(withdrawalSumDecimal.replace(/\B(?=(\d{3})+(?!\d))/g, ","));    
            
            $("#checkAllDebits").prop('checked',false);
            
        }else if(transaction.toLowerCase() === 'deposito'){
            depositCount--;
            $('#depositCount').html(depositCount);
            
            depositSum -= parseFloat(value[2]);   
            var depositSumDecimal = depositSum.toFixed(2);
            $('#depositSum').html(depositSumDecimal.replace(/\B(?=(\d{3})+(?!\d))/g, ","));
            
            $("#checkAllCredits").prop('checked',false);
        }
    }
    
    var startBalance = parseFloat($('#startBalance').html().replace(',',''));
    var realEndBalance = parseFloat($('#realEndBalance').html().replace(',',''));
    var withdrawalSum = parseFloat($('#withdrawalSum').html().replace(',',''));
    var depositSum = parseFloat($('#depositSum').html().replace(',',''));
    
    var transactionSum = depositSum - withdrawalSum;
    var endBalance = startBalance + transactionSum;
    var difference = Math.abs(realEndBalance) - Math.abs(endBalance);
    
    $('#transactionSum').html(transactionSum.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ","));
    $('#movimientosSeleccionados').val(transactionSum.toFixed(2));
    $('#endBalance').html(endBalance.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ","));
    $('#difference').html(difference.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ","));
    
    if(difference === 0){
        $('#close').prop('disabled',false);
    }else{
        $('#close').prop('disabled',true);
    }
}

function setDefaultInfo(idBank){
    var idConciliation = $("input[name='id']").val();
    $.post('/Controller/Ajax.php', {
        action: 'ajax',
        request: 'setDefultInfoConciliation',
        idBank: idBank,
        idConciliation: idConciliation
    }, function(data) {
        if (data.response){
           $("#fechaInicio").val(data.fechaInicio);
           $("#balanceInicial").val(data.balanceInicial);
        }else{
            $("#flashmessenger").html(data.msg);
            $('#fechaInicio').val('');
            $('#balanceInicial').val('');
        }
    }, 'json');
}

function checkUncheckAllDebits(element){
    var element  = $("#"+element);
    if(element.is(':checked')) {           
        $('.retiro.unChecked').each(function(index,checkbox){
            $("input[name='"+checkbox.name+"']").prop('checked',true);
            setSummaryConciliation(checkbox.name,'retiro');
        });
        
    }else{
       $('.retiro.checked').each(function(index,checkbox){
            $("input[name='"+checkbox.name+"']").prop('checked',false);
            setSummaryConciliation(checkbox.name,'retiro');
        });
    } 
}

function checkUncheckAllCredits(element){
    var element  = $("#"+element);
    if(element.is(':checked')) {       
        $('.deposito.unChecked').each(function(index,checkbox){
            $("input[name='"+checkbox.name+"']").prop('checked',true);
            setSummaryConciliation(checkbox.name,'deposito');
        });
    }else{
        $('.deposito.checked').each(function(index,checkbox){
            $("input[name='"+checkbox.name+"']").prop('checked',false);
            setSummaryConciliation(checkbox.name,'deposito');
        });
    }
}

/*Delete Filter to the Tables that uses datatable.*/
function clearFilterAndSubmit(formName,tableId){
    clearTableFilter(tableId);
}

function clearTableFilter(tableId){
    var table = $('#'+tableId).DataTable();
    table.search( '' ).columns().search( '' ).draw();
}