<?php 
    $controller = 'POS';
    $action = 'print';
    include $_SERVER["DOCUMENT_ROOT"].'/app/include/bootstrap.php';?>
<!DOCTYPE html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width,initial-scale=1.0,minimum-scale=1.0,maximum-scale=1.0,user-scalable=no">
    <link href="<?php echo ROOT_HOST?>/public/bootstrap/css/bootstrap.min.css" rel="stylesheet">  
    <script src="<?php echo ROOT_HOST?>/public/js/funciones.js"></script>  
</head>
<body>
    <iframe name="print_frame" width="100%" height="200px" frameborder="0" src="about:blank"></iframe>
    <?php
    /* INFORMACION EMPRESA */
    $empresa = new EmpresaEntity();
    $empresa->setOptions($empresa->getById(1)); 
    
    $nombreEmpresa  = $empresa->getNombre();
    $direccion      = $empresa->getDireccion();
    $ciudadEstadoZC = $empresa->getCiudad().', '.$empresa->getEstado().' '.$empresa->getCodigoPostal();
    $telefono       = $empresa->getTelefono();  
    
    /* INFORMACION VENTA */
    $idVenta = $_GET['idVenta'];
    $entityVenta = new VentaEntity();
    $venta = $entityVenta->setOptions($entityVenta->getById($idVenta));
    $ventaData = $entityVenta->getOptions();
    $cajero = $entityVenta->getUsuarioName();
    $fechaCreacion = strftime('%m/%d/%y %H:%M:%S',strtotime($entityVenta->getFechaCreacion()));

    /* INFORMACION VENTA DETALLES */
    $ventaAjax = new PosAjax();
    $ventaDetalles = $entityVenta->getVentaDetallesSaved($idVenta);
    $ventaTotales = $ventaAjax->listVentaDetalles($ventaDetalles,$ventaData['descuento_orden']);    
    
    $cambio = $ventaData['total_recibido'] - $ventaTotales['montoTotal'];
    $cambio = number_format($cambio,2);
    
    $subtotal = $ventaTotales['subtotal'];
    $montoImpuestos = $ventaTotales['impuestosTotal'];
    
    $descuentoOrdenTotal = $ventaTotales['descuentoOrden'];
    if($ventaTotales['descuentoOrden'] != '0'){
        $descuentoOrdenTotal = $ventaTotales['descuentoOrden'];
    }    
   
    $montoTotal = $ventaTotales['montoTotal'];
    $totalRecibido = number_format($ventaData['total_recibido'],2);
    $totalRecibido = $ventaData['total_recibido'];
    
    $stringListDetalles = null;
    foreach($ventaDetalles as $detalle){
             $item = $detalle['descripcion'];             
             $totalItem = number_format($detalle['precio']*$detalle['cantidad'],2);
             $descuento = ($detalle['descuento'] * $totalItem)/100;
             $stringListDetalles .= "<tr>"
                     . "<td>{$detalle['cantidad']}</td>"
                     . "<td>{$item}</td>"
                     . "<td style='text-align:right'>".number_format($totalItem - $descuento,2)."</td>"
                     . "</tr>";
    }
    
    /*INFORMACION DETALLES PAGO*/
    $detallesPago = $entityVenta->getCobrosDetalleByIdVenta($idVenta);
    $pagos = array();     
    $cardPaymentFlag = NULL;
    foreach($detallesPago as $detalle){
        if($detalle['formaPago']==6 || $detalle['formaPago']==5){
            //Si es true significa que el pago fue realizado con tarjeta de debito y credito.
            $cardPaymentFlag = true;
        }
        $forma = $_translator->_getTranslation($detalle['formaPagoName']);
        $forma = str_pad($forma." ".substr($detalle['numDocumento'],-4), 16, " ", STR_PAD_RIGHT);

        $monto = number_format($detalle['monto'],2);             
        $monto = str_pad($monto, 11, " ", STR_PAD_LEFT);
        $pagos[] = $forma.$monto;
    }
?>
    <div id="cashier">
        <div style="margin:auto;font-size: 10px;font-family: Arial,Helvetica Neue,Helvetica,sans-serif">
            <div style="text-align: center">
                <h3 style='font-size: 24px'><?php echo $nombreEmpresa;?></h3>
                <p style="margin:0"><?php echo $direccion; ?></p>
                <p style="margin:0"><?php echo $ciudadEstadoZC; ?></p>
                <p style="margin:0"><?php echo $telefono;?></p>
            </div> 
            <div class="text-left m-t-1">            
                <p style="margin:0">Sale #: <?php echo $idVenta;?></p>
                <p style="margin:0">Date: <?php echo $fechaCreacion;?></p>
                <p style="margin:0">Cashier: <?php echo $cajero;?></p>
            </div> 
            <table style="width:100%;font-size: 10px;margin-top:1rem;margin-bottom:20px;border-collapse:collapse;border-spacing:0px">
            <thead>
                <th style="width:10%">Qty</th>
                <th style="width:70%">Description</th>
                <th style="width:20%;text-align: right">Total</th>
            </thead>
            <tbody>
            <?php echo $stringListDetalles;?>
            <tr style="border: 1px solid #f3f3f3"></tr>
            <?php if($descuentoOrdenTotal != '0'){?>
            <tr>
                <td colspan="2" style="text-align:right">Discount</td>
                <td style="text-align:right">$ <?php echo $descuentoOrdenTotal?></td>
            </tr>
            <?php }?>
            <tr>
                <td colspan="2" style="border:0px;text-align:right">Subtotal</td>
                <td style="border:0px;text-align:right">$ <?php echo $subtotal?></td>
            </tr>        
            <tr style="border:0px">
                <td colspan="2" style="border:0px;text-align:right">Tax</td>
                <td style="border:0px;text-align:right">$ <?php echo $montoImpuestos?></td>
            </tr>
            <tr style="border:0px">
                <td colspan="2" style="border:0px;text-align:right"><b>Total</b></td>
                <td style="border:0px;text-align:right"><b>$ <?php echo $montoTotal?></b></td>
            </tr>
             <?php
                foreach($detallesPago as $pago ){?>
            <tr>
                <td colspan="2" style="border:0px;text-align:right"><?php echo $_translator->_getTranslation($pago['formaPagoName'])." ".$pago['numDocumento'];?></td>
                <td style="border:0px;text-align:right">$ <?php echo $pago['monto'];?></td>
            </tr>
            <?php }?>
            <tr style="border:0px;">
                <td colspan="2"style="border:0px;text-align:right"><b>Total received</b></td>
                <td style="border:0px;text-align:right"><b>$ <?php echo $totalRecibido;?></b></td>
            </tr>
            <tr style="border:0px;">
                <td colspan="2" style="border:0px;text-align:right"><b>Change</b></td>
                <td style="border:0px;text-align:right"><b>$ <?php echo $cambio ?></b></td>
            </tr>
            </tbody>
        </table>
        <div style="text-align: center">
            <p style="margin:0">Thank you for your coming.</p>
            <p style="margin:0">We hope you'll visit again.</p>
            <p style="margin-top:1rem">****** Cashier copy ******</p>
        </div> 
        </div>
    </div>
    
    <div id="customer">
        <div style="margin:auto;font-size: 10px;font-family: Arial,Helvetica Neue,Helvetica,sans-serif">
            <div style="text-align: center">
                <h3 style='font-size: 24px'><?php echo $nombreEmpresa;?></h3>
                <p style="margin:0"><?php echo $direccion; ?></p>
                <p style="margin:0"><?php echo $ciudadEstadoZC; ?></p>
                <p style="margin:0"><?php echo $telefono;?></p>
            </div> 
            <div class="text-left m-t-1">            
                <p style="margin:0">Sale #: <?php echo $idVenta;?></p>
                <p style="margin:0">Date: <?php echo $fechaCreacion;?></p>
                <p style="margin:0">Cashier: <?php echo $cajero;?></p>
            </div> 
            <table style="width:100%;font-size: 10px;margin-top:1rem;margin-bottom:20px;border-collapse:collapse;border-spacing:0px">
            <thead>
                <th style="width:10%">Qty</th>
                <th style="width:70%">Description</th>
                <th style="width:20%;text-align: right">Total</th>
            </thead>
            <tbody>
            <?php echo $stringListDetalles;?>
            <tr style="border: 1px solid #f3f3f3"></tr>
            <?php if($descuentoOrdenTotal != '0'){?>
            <tr>
                <td colspan="2" style="text-align:right">Discount</td>
                <td style="text-align:right">$ <?php echo $descuentoOrdenTotal?></td>
            </tr>
            <?php }?>
            <tr>
                <td colspan="2" style="border:0px;text-align:right">Subtotal</td>
                <td style="border:0px;text-align:right">$ <?php echo $subtotal?></td>
            </tr>        
            <tr style="border:0px">
                <td colspan="2" style="border:0px;text-align:right">Tax</td>
                <td style="border:0px;text-align:right">$ <?php echo $montoImpuestos?></td>
            </tr>
            <tr style="border:0px">
                <td colspan="2" style="border:0px;text-align:right"><b>Total</b></td>
                <td style="border:0px;text-align:right"><b>$ <?php echo $montoTotal?></b></td>
            </tr>
             <?php
                foreach($detallesPago as $pago ){?>
            <tr>
                <td colspan="2" style="border:0px;text-align:right"><?php echo $_translator->_getTranslation($pago['formaPagoName'])." ".$pago['numDocumento'];?></td>
                <td style="border:0px;text-align:right">$ <?php echo $pago['monto'];?></td>
            </tr>
            <?php }?>
            <tr style="border:0px;">
                <td colspan="2"style="border:0px;text-align:right"><b>Total received</b></td>
                <td style="border:0px;text-align:right"><b>$ <?php echo $totalRecibido;?></b></td>
            </tr>
            <tr style="border:0px;">
                <td colspan="2" style="border:0px;text-align:right"><b>Change</b></td>
                <td style="border:0px;text-align:right"><b>$ <?php echo $cambio ?></b></td>
            </tr>
            </tbody>
        </table>
        <div style="text-align: center">
            <p style="margin:0">Thank you for your coming.</p>
            <p style="margin:0">We hope you'll visit again.</p>
            <p style="margin-top:1rem">****** Customer copy ******</p>
        </div> 
        </div>
    </div>
    <script type="text/javascript">  
        //printDivCSS = new String ();
        
        function print(ticket){
            window.frames["print_frame"].document.body.innerHTML = document.getElementById(ticket).innerHTML;
            window.frames["print_frame"].window.focus();
            window.frames["print_frame"].window.print();
        }
        
        print('cashier');
        setTimeout("print('customer')",300);
    </script>
</body>
</html>