<?php 
    $root = realpath($_SERVER["DOCUMENT_ROOT"].'');
    include $root.'/app/config/dbConfig.php';
    include $root.'/app/config/appConfig.php';
    include $root."/class/DataBase/DataBase.php";  
    include $root."/Entity/EntityRepository.php";
    include $root."/class/Translator/Translator.php";
    include $root."/class/FlashMessenger/FlashMessenger.php";    
    include $root."/Entity/EmpresaRepository.php";    
    include $root."/Entity/VentaRepository.php";
    include $root."/Entity/EmpresaEntity.php";
    include $root."/Entity/VentaEntity.php";    
    include $root."/Entity/ProductoRepository.php";
    include $root."/Entity/SucursalRepository.php";
    include $root."/Entity/ImpuestosRepository.php";
    include $root."/Entity/SpecialRequisitionRepository.php";
    include $root."/Controller/Ajax/PosAjax.php";?>
<!DOCTYPE html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width,initial-scale=1.0,minimum-scale=1.0,maximum-scale=1.0,user-scalable=no">
    <link href="<?php echo ROOT_HOST?>/public/bootstrap/css/bootstrap.min.css" rel="stylesheet">  
    <script src="<?php echo ROOT_HOST?>/public/js/funciones.js"></script>  
</head>
<body style="background-color: #C8CCCE;">
     <?php
    # INFORMACION EMPRESA
    $empresa = new EmpresaEntity();
    $empresa->setOptions($empresa->getById(1)); 
    
    $nombreEmpresa  = $empresa->getNombre();
    $direccion      = $empresa->getDireccion();
    $ciudadEstadoZC = $empresa->getCiudad().', '.$empresa->getEstado().' '.$empresa->getCodigoPostal();
    $telefono       = $empresa->getTelefono();  
    $paginaWeb      = $empresa->getPaginaWeb();
    
    # INFORMACION VENTA
    $entityVenta = new VentaEntity();
    
    if(isset($_GET['idVenta'])){
        $idVenta = $_GET['idVenta'];    
    }
    
    /*Cuando se usa modal reeimprimir en POS */
    if(isset($_GET['numVenta'])){
        $login = new Login();
        $_ventaDataTemp = $entityVenta->getByNumVentaAndStoreId($_GET['numVenta'],$login->getSucursal());
        $idVenta = $_ventaDataTemp['id'];        
    }    
    
    $options = $entityVenta->getById($idVenta);
    if($options == null){ 
        $entityVenta->flashmessenger->addMessage(array('danger'=>'Uppss. Venta no registrada.'));
        $msg = $entityVenta->flashmessenger->getMessageString();
        echo "<script>window.parent.$('#flashmessenger').html(\"{$msg}\");fadeOutAlert();</script>";
        exit;
    }
       
    $entityVenta->setOptions($options);
    $entityVenta->setId($idVenta);    
    $numVenta = $entityVenta->getNumVenta();
    
    $SucursalRepository = new SucursalRepository();
    $SucursalRepository->setOptions($SucursalRepository->getById($options['idSucursal']));
    
    $nombreSucursal = $SucursalRepository->getNombre();
    $direccion      = $SucursalRepository->getDireccion();
    $ciudadEstadoZC = $SucursalRepository->getCiudad().', '.$SucursalRepository->getEstado().' '.$SucursalRepository->getCodigoPostal();
    $telefono       = $SucursalRepository->getTelefono();  
    
    /* PARA OBTENER BALANCE DE SpecialRequisition*/
    $isSpecialRequisition = null;
    $specialRequisitionId = $entityVenta->getSpecialRequisitionId();
    if($specialRequisitionId != null & $specialRequisitionId != '0'){
       $isSpecialRequisition = true;
       $repoSR = new SpecialRequisitionRepository();
       $repoSR->setOptions($repoSR->getById($specialRequisitionId));
       $repoSR->setId($specialRequisitionId);
       $balance = "Saldo pendiente: $". number_format($repoSR->getBalance(),2);
       $cliente = $repoSR->getCustomerName();
    }
    
    $ventaData = $entityVenta->getOptions();
    $cajero = $entityVenta->getUsuarioName();
    $fechaCreacion = strftime('%m/%d/%y %H:%M:%S',strtotime($entityVenta->getFechaCreacion()));
    
    # INFORMACION VENTA DETALLES
    $productoEntity = new ProductoRepository();
    $detalles = $entityVenta->getVentaDetallesSaved($idVenta);
    $listDetalles = "";
    $subtotal = 0;
    $montoTotal = 0;
    $montoImpuestos = 0;
    $descuentoOrdenTotal = 0;
    $itemsTotal = 0;
    
    $repo = new ImpuestosRepository();
    $listaImpuestos = $repo->getInfoImpuestos();
    $impuestosAplicables = array();   
    
    foreach($detalles as $detalle){    
        $itemsTotal += $detalle['cantidad'];
     
        $total = $detalle['cantidad'] * $detalle['precio_sin_impuestos'];
        $subtotal += $total;
        $total -= $detalle['descuento_item_monto'];
        $total -= $detalle['descuento_orden_monto'];

        $descuentoOrdenTotal += $detalle['descuento_item_monto'];
        $descuentoOrdenTotal += $detalle['descuento_orden_monto'];          

        $montoTotal += $total;           
        $montoImpuestos += $detalle['impuestos_monto'];              
       
        $listDetalles .= "<tr>
                        <td style='text-align:center'>{$detalle['cantidad']}</td>
                        <td>"
                            .ucfirst($detalle['descripcion'].' '.$detalle['tamanoName'])."<br/>"
                            #. "<span style='font-size:12px'>".ucfirst($tamano)."</span>
                        ."</td>
                        <td style='text-align:right'>$".number_format($total,2)."</td>";
        $listDetalles .= "</tr>";
    }
    
    if($isSpecialRequisition === true){        
        $listDetalles .="<tr><td></td><td>Cliente: $cliente</td><td></td>";
        $listDetalles .="<tr><td></td><td>$balance</td><td></td>";
    }
    
    $subtotalMenosDescuento =  number_format(round($subtotal - $descuentoOrdenTotal,2,PHP_ROUND_HALF_UP),2); 
    $subtotal = number_format(round($subtotal,2,PHP_ROUND_HALF_UP),2);  
    
    $montoTotalSinFormato = round($montoTotal  + $montoImpuestos,2,PHP_ROUND_HALF_UP);
    $totalRecibido = $ventaData['total_recibido'];
    $cambio = number_format(round($totalRecibido  - $montoTotalSinFormato,2,PHP_ROUND_HALF_UP),2);
   
    $montoTotal = number_format($montoTotalSinFormato,2);
    $totalRecibido = number_format(round($totalRecibido,2,PHP_ROUND_HALF_UP),2);
    
    $descuentoOrdenTotal = number_format(round($descuentoOrdenTotal,2,PHP_ROUND_HALF_UP),2);    
    $montoImpuestos = number_format(round($montoImpuestos,2,PHP_ROUND_HALF_UP),2);    
    
    /*INFORMACION DETALLES PAGO*/
    $detallesPago = $entityVenta->getCobrosDetalleByIdVenta($idVenta);
    $pagos = array();     
    $cardPaymentFlag = NULL;
    $_translator = new Translator();
    
    foreach($detallesPago as $detalle){
        if($detalle['formaPago']==6 || $detalle['formaPago']==5){
            //Si es true significa que el pago fue realizado con tarjeta de debito y credito.
            $cardPaymentFlag = true;
        }
        $forma = $_translator->_getTranslation($detalle['formaPagoName']);
        $forma .= " ".$detalle['last_4'];
        $monto = number_format(round($detalle['monto'],2,PHP_ROUND_HALF_UP),2); 
        
        $pagos[] = array(
            'forma'=>$forma,
            'monto'=>$monto
        );
    }
    ?>
    <div style="width:400px;margin:auto;margin-top: 15px">
    <div style="background-color: #fff; padding:10px;width:100%;text-align: center"><img src="<?php echo ROOT?>/public/img/logo_login.png" width="40%"/></div>
    <div style="background-color: #fff; width:400px;margin:auto;padding:10px;">   
        <div style="text-align: center">       
            <h4 style="margin-bottom:0px"><?php echo $nombreEmpresa;?></h4>  
            <p style="margin:0px;"><?php echo $nombreSucursal; ?></p>
            <p style="margin:0px;"><?php echo $direccion; ?></p>
            <p style="margin:0px;"><?php echo $ciudadEstadoZC; ?></p>
            <p style="margin:0px;"><?php echo $telefono;?></p>
            <br/>
        </div> 
        <div>    
            <p style="margin:0px;"><?php echo $_translator->_getTranslation('Sale')?> #: <?php echo $numVenta?></p>
            <p style="margin:0px;"><?php echo $_translator->_getTranslation('Date')?>: <?php echo $fechaCreacion;?></p>
            <p style="margin:0px;"><?php echo $_translator->_getTranslation('Store')?>: <?php echo $nombreSucursal?></p>
            <p style="margin:0px;"><?php echo $_translator->_getTranslation('Cashier')?>: <?php echo $cajero?></p>            
            <p style="margin:0px;"><?php echo $_translator->_getTranslation('Items')?>: <?php echo $itemsTotal;?></p>
        </div> 
        <style>.table > tbody > tr > td, .table > tbody > tr > th, .table > tfoot > tr > td, .table > tfoot > tr > th, .table > thead > tr > td, .table > thead > tr > th{padding:2px}</style>
        <table style="margin-top:1rem !important;;background-color: transparent;width: 100%;max-width: 100%;margin-bottom: 20px;border-spacing: 0;border-collapse: collapse;box-sizing: border-box;">
        <thead>
            <th style="width:10%;text-align: center"><?php echo $_translator->_getTranslation('Qty')?></th>
            <th style="width:65%;text-align: left"><?php echo $_translator->_getTranslation('Description')?></th>
            <th style="width:25%;text-align: right">Total</th>
        </thead>
        <tbody>
        <?php echo $listDetalles;?>
        <tr style="border: 1px solid #f3f3f3"></tr>        
        <tr>
            <td colspan="2" style="border:0px;text-align: right;margin:0px;padding:0px"><?php echo $_translator->_getTranslation('Subtotal')?></td>
            <td style="border:0px;text-align: right;margin:0px;padding:0px">$ <?php echo $subtotal?></td>
        </tr>        
       <?php if($descuentoOrdenTotal != '0'){?>
        <tr>
            <td colspan="2" style="border:0px;text-align: right;margin:0px;padding:0px"><?php echo $_translator->_getTranslation('Discount')?></td>
            <td style="border:0px;text-align: right;margin:0px;padding:0px">$ <?php echo $descuentoOrdenTotal?></td>
        </tr>
        <tr>
            <td colspan="2" style="border:0px;text-align: right;margin:0px;padding:0px"><?php echo $_translator->_getTranslation('Subtotal')?></td>
            <td style="border:0px;text-align: right;margin:0px;padding:0px">$ <?php echo $subtotalMenosDescuento; ?></td>
        </tr>
        <?php }?>
         <tr style="border:0px">
            <td colspan="2" style="border:0px;text-align: right;margin:0px;padding:0px"><?php echo $_translator->_getTranslation('Tax')?></td>
            <td style="border:0px;text-align: right;margin:0px;padding:0px">$ <?php echo number_format(round($montoImpuestos,2,PHP_ROUND_HALF_UP),2);?></td>
        </tr>
        
        <tr style="border:0px;">
            <td colspan="2" style="border:0px;text-align: right;margin:0px;padding:0px"><b><?php echo $_translator->_getTranslation('Total')?></b></td>
            <td style="border:0px;text-align: right;margin:0px;padding:0px"><b>$ <?php echo $montoTotal?></b></td>
        </tr>
        <tr style="border:0px;">
            <td colspan="2" style="border:0px;text-align: right;margin:0px;padding:0px"><b><?php echo $_translator->_getTranslation('Payment')?></b></td>
            <td style="border:0px;text-align: right;margin:0px;padding:0px"><b>$ <?php echo $totalRecibido;?></b></td>
        </tr>
        <tr style="border:0px;">
            <td colspan="2" style="border:0px;text-align: right;margin:0px;padding:0px"><b><?php echo $_translator->_getTranslation('Change due')?></b></td>
            <td style="border:0px;text-align: right;margin:0px;padding:0px"><b>$ <?php echo $cambio ?></b></td>
        </tr>
        <tr>
            <td colspan="2" style="border:0px;text-align: right;margin:0px;padding:0px"><?php echo $_translator->_getTranslation('Payment method')?></td>
        </tr>
        <?php
            foreach($pagos as $pago ){?>
        <tr>
            <td colspan="2" style="border:0px;text-align: right;margin:0px;padding:0px"><?php echo $_translator->_getTranslation($pago['forma']);?></td>
            <td style="border:0px;text-align: right;margin:0px;padding:0px">$ <?php echo $pago['monto'];?></td>
        </tr>
        <?php }?>
        </tbody>
    </table> 
    <div style="text-align: center;width:80%;margin:auto">
        <p>Our products do not contain preservatives; consume within 36 hours of purchasing.</p>
        <p>Once product has left the store, it can not be returned or exchanged.</p>
        <p>Changes and cancellations on special orders must be requested 72 hours before date of delivery.</p>
        
        <p style="margin:0px">Thank you for visiting</p>
        <p style="margin:0px">Have a nice day</p>
    </div>                  
    <div style="width:100%;">
        <img src="<?php echo ROOT?>/public/img/shadow-receipt.gif" width="100%"/>
        <div style='clear: both'></div>
    </div>        
    </div>
    </div>
</body>
</html>