<?php 
    $query_date = date('Y-m-d');
    $date = new DateTime($query_date);
    $date->modify('first day of this month');
    $firstdayMonth= $date->format('m/d/Y');
    $date->modify('last day of this month');
    $lastdayMonth = $date->format('m/d/Y');?>


    <!-- SALES -->
    <div class="box clearfix">
        <div class="box-header">  
            <h3><i class='fa fa-line-chart'></i><?php echo $_translator->_getTranslation('Ventas');?></h3>
            <div class="pull-right box-tools">
                <button type="button" class="btn btn-primary daterange pull-right" data-toggle="tooltip" title="Date range"><i class="fa fa-calendar"></i></button>
            </div>
        </div>
    
        <div class="box-body">
            <div class="col-lg-4 col-xs-12" >
                <table id="tbl_sales" class="table">
                    <caption class="text-center" ></caption>
                    <thead>
                    <tr>
                        <th class="text-center"><?php echo $_translator->_getTranslation('Sucursal'); ?></th>
                        <th class="text-right"><?php echo $_translator->_getTranslation('Total'); ?></th>
                    </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>   
            <div id="chart_sales" class="col-lg-8 col-xs-12">
                <canvas style="width: 15%;" id="canvas_chart_sales"></canvas>
            </div>
        </div>
    </div>
    <!-- END SALES -->    
    
    
    <!-- SPECIAL ORDERS -->
    <!--
    <div class="box clearfix">
        <div class="box-header">  
            <h3><i class='fa fa-birthday-cake'></i><?php echo $_translator->_getTranslation('Ordenes especiales');?></h3>
            <div class="pull-right box-tools">
                <button type="button" class="btn btn-primary daterange_special_orders pull-right" data-toggle="tooltip" title="Date range"><i class="fa fa-calendar"></i></button>
            </div>
        </div>
        
        <div class="box-body">
            <div class="col-lg-4 col-xs-12">
                <table id="tbl_special_orders" class="table">
                    <caption class="text-center"></caption>
                    <thead>
                    <tr>
                        <th class="text-center"><?php echo $_translator->_getTranslation('Sucursal'); ?></th>
                        <th class="text-center"><?php echo $_translator->_getTranslation('Pedidos'); ?></th>
                        <th class="text-right"><?php echo $_translator->_getTranslation('Total ventas'); ?></th>
                    </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
            <div id="chart_special_orders" class="col-lg-8 col-xs-12">
                <canvas style="width: 15%;" id="canvas_chart_special_orders"></canvas>
            </div>
        </div>
    </div>
    -->
    <script>
        $(document).ready(function () {
            _salesChart('<?php echo $firstdayMonth ?>','<?php echo $lastdayMonth ?>');
            _specialOrdersChart('<?php echo $firstdayMonth ?>','<?php echo $lastdayMonth ?>');
        });
    </script>