<?php
class SliceForm extends Form {    
    public function __construct() {
        $this->setName('slice');
        $this->setActionForm('Slice.php');
        $this->setClass('compra form-horizontal');
        $this->setMethod('post');
        parent::__construct();
        $this->init();
    }

    public function init() {                
        $attributes_wrapper_append_select = array('class'=>'select2-bootstrap-append');
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'category',
            'label'=>'Categoria',
            'multiOptions'=>$this->listCategories(),
            'required'=>true
        ));
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'size',
            'label'=>'Tamaño',
            'multiOptions'=>$this->listSizes(),
            'required'=>true
        ));
        
         $this->addElement(array(
            'type' => 'text',
            'name' => 'flavor',
            'label'=>'Nombre',
            'required'=>true
        )); 
         
        $this->addElement(array(
            'type' => 'text',
            'name' => 'price',
            'label'=>'Precio',
            'validators'=>array('double'),
            'required'=>true,
        ));
        
        $this->addElement(array(
            'type' => 'textarea',
            'name' => 'comments',
            'label'=>'Notas',
            'required'=>false
        ));          
         
         /*Se utiliza para consulta si existe en la tabla de comprasdetalles_X, si existe se actualiza registro.*/
        /*
         $this->addElement(array(
            'type' => 'hidden',
            'name' => 'idDetailTemp',
            'required'=>false
        ));            
         
         $append = "<span class = 'btn input-group-addon' data-toggle='modal' data-target='#modalAgregarProducto'><i class='fa fa-plus'></i></span>";
         $this->addElement(array(
            'type' => 'select',
            'name' => 'id_supplie',
            'label'=>'Producto',
            'multiOptions'=>$this->getListSupplies(),
            'optionals'=>array('onchange'=>'getUnitMeasure()'),
            'col-size-label'=>'12',
            'col-size-element'=>'12',
            'append'=>$append

         ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'quantity',
            'label'=>'Cantidad',
            'validators'=>array('double'),
            'required'=>false,
            'col-size-element'=>'12'
        ));

        $this->addElement(array(
            'type'=>'button',
            'name'=>'buscar',
            'value'=>$this->_getTranslation('Agregar'),
            'class'=>'btn btn-success',
            'optionals'=>array('onClick'=>'setSliceDetails()')
        ));
        */
        $this->addElement(array(
            'type'=>'button',
            'name'=>'terminar',
            'value'=>$this->_getTranslation('Terminar'),
            'class'=>'btn btn-primary',
            'optionals'=>array("onClick"=>"submit('slice')")
        ));   
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'cancelar',
            'value'=> $this->_getTranslation('Cancelar'),
            'optionals'=>array(
                'onclick'=>"document.location = '".ROOT_HOST."/Controller/Slice.php'"),
            'class'=>'btn btn-danger m-t-1 m-b-1'
        ));
    }
    
    public function listCategories(){
        $repository = new CategoriaRepository();
        $list = $repository->getListaSelectCategorias('Partes del pastel');

        if(count($list)>1){ $array = array(''=>'Seleccionar una opcion...');}
        if ($list) {               
            foreach ($list as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }        
        return array(''=>'Seleccionar una opcion...');
    }
    
   public function listSizes(){
        $repository = new TamanoRepository();
        $list = $repository->getListaSelectTamanos();
        
        if(count($list)>1){$array = array(''=>'Seleccionar una opcion...');}
        if ($list) {               
            foreach ($list as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }
        return array(''=>'Seleccionar una opcion...');
    }
    
    public function getListSupplies(){
        $repository = new SupplieRepository();
        #1 = status activo
        $productos = $repository->getListSupplies();
        
        $array = array('0'=>'Seleccionar una opcion...');        
        foreach($productos as $producto){       
            $array[$producto['id']] = $producto['description']." (".$producto['code'].")";
        }
        
        $list= array();
        foreach ($array as $key => $value) {
            $list[$key] = $value;
        }
        return $list;
    }
    
    
    public function populate($data) { 
        parent::populate($data);
    } 
}