<?php
/**
 * Description of NivelForm
 *
 * @author carlos
 */

class MarcaForm extends Form {

    public function __construct() {
        $this->setActionForm('Brand.php');
        $this->setClass('marca');
        $this->setMethod('post');
        $this->setDefaultFormElementsColSize('8');
        $this->setDefaultFormLabelsColSize('4');
        parent::__construct();
        $this->init();
    }

    public function init() {
        $this->addElement(array(
            'type' => 'text',
            'name' => 'descripcion',
            'label'=>'Descripcion',
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'send',
            'value'=> $this->_getTranslation('Terminar'),
            'optionals'=>array(
                'onclick'=>"submit()"),
            'class'=>'btn btn-primary m-t-1 m-b-1'
        ));
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'cancelar',
            'value'=> $this->_getTranslation('Cancelar'),
            'optionals'=>array(
                'onclick'=>"document.location = '".ROOT_HOST."/Controller/Brand.php'"),
            'class'=>'btn btn-danger m-t-1 m-b-1'
        ));
    }
    
    public function populate($data){
        parent::populate($data);
    }
}