<?php
/**
 * Description of LoginForm
 *
 * @author carlos augusto vazquez lara
 */
class GenericForm extends Form {
    public function __construct() {
        $this->setName('generic');
        $this->init();
        parent::__construct();
    }
    public function init() {        
        //$attributes_wrapper_append_date = array('id'=>'fiDatePicker','data-provide'=>'datepicker');
        //$append = "<span class = 'btn input-group-addon'><i class='fa fa-calendar'></i></span>";
        $this->addElement(array(
            'type' => 'text',
            'name' => 'fechaInicio',
            'optionals'=>array('placeholder'=>'Fecha Inicio'),
            'required'=>false,            
            'col-size-element'=>'12',
            //'append'=>$append,
            //'wrapper_attributes'=>$attributes_wrapper_append_date
        ));
        
        //$attributes_wrapper_append_date = array('id'=>'ffDatePicker');
        //$append = "<span class = 'btn input-group-addon'><i class='fa fa-calendar'></i></span>";
        $this->addElement(array(
            'type' => 'text',
            'name' => 'fechaFin',
            'optionals'=>array('placeholder'=>'Fecha Fin'),
            'required'=>false,            
            'col-size-element'=>'12',
            //'append'=>$append,
            //'wrapper_attributes'=>$attributes_wrapper_append_date
        ));
        
        #Para reporte inventario_en_sucursales
        $this->addElement(array(
            'type' => 'select multiple',
            'name' => 'days',
            'label'=>'Dias',
            'multiOptions'=>$this->getListDays(),
            'value'=>date('N'),
            //'optionals'=>array('onchange'=>"$('form[name=generic]').submit()"),
            'required'=>true,
            'col-size-element'=>'8 pull-right',
        ));
        
        $attributes_wrapper_append_date = array('class'=>'date','id'=>'fechaDatePicker');
        $append = "<span class = 'btn input-group-addon'><i class='fa fa-calendar'></i></span>";
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'date',
            'label'=>'Fecha',
            'required'=>false,
            'append'=>$append,
            'wrapper_attributes'=>$attributes_wrapper_append_date
        ));
        
         $this->addElement(array(
            'type' => 'text',
            'name' => 'start_date',
            'label'=>'Fecha inicio',
            'required'=> false
        ));                
        $this->addElement(array(
            'type' => 'text',
            'name' => 'end_date',
            'label'=>'Fecha fin',
            'required'=> false
        ));
        
        $this->addElement(array(
            'type' => 'submit',
            'name' => 'search',
            'value'=> 'Buscar',
            'optionals'=>array(
                'onclick'=>"submit()"),
            'class'=>'btn btn-primary'
        ));
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'cerrar',
            'value'=> 'Cerrar',
            'class'=>'btn btn-default',
            'optionals'=>array(
                'data-dismiss'=>'modal',
                'aria-hidden'=>'true',
                )
        ));
    }
    
    public function getListDays(){
        $repository = new SucursalRepository();
        $result = $repository->getListDays();
        
        $array = array();
        if ($result) {
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
        }
        return $array;
    }
    
    public function populate($data){
        if(isset($data['days']) && $data['days']!=null && is_array($data['days'])){
            $days = array();
            foreach($data['days'] as $colegio){$days[$colegio] = $colegio;}
            $data['days'] = $days;
        }
        
        parent::populate($data);
    }
}