<?php
/**
 * Description of NivelForm
 *
 * @author carlos
 */

class AperturaCierreCajaForm extends Form {

    public function __construct() {
        $this->setActionForm('Register.php');
        $this->setClass('form-horizontal');
        $this->setMethod('post');
        parent::__construct();
        $this->init();
    }

    public function init() {         
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'creado_por',
            'required'=> false
        )); 
        
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'status',
            'required'=> false
        )); 
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'idCaja',
            'label'=>'Caja',
            'multiOptions'=>$this->getListCajas(),
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'efectivoInicial',
            'label'=>'Efectivo inicial',
            'required'=> true,
            'optionals'=>array(
                'readOnly'=>'readOnly',
                'onclick'=>"$('#modalDenominaciones').modal('show');$('form[name=denominaciones] #elementId').val(this.id)")
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'efectivoFinal',
            'label'=>'Efectivo final',
            'required'=> true,
            'optionals'=>array(
                'readOnly'=>'readOnly',
                'onclick'=>"$('#modalDenominaciones').modal('show');$('form[name=denominaciones] #elementId').val(this.id)")
        ));
              
        $this->addElement(array(
            'type' => 'text',
            'name' => 'tarjetasFinal',
            'label'=>'Tarjetas final',
            'required'=> true
        ));      
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'electronicoFinal',
            'label'=>'Transferencias final',
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'chequesFinal',
            'label'=>'Cheques final',
            'required'=> true
        )); 
        
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'devoluciones',
            'required'=> false
        )); 
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'autorizacion_usuario',
            'label'=>'Autorizacion usuario',
            'required'=> true
        )); 
        
        $this->addElement(array(
            'type' => 'password',
            'name' => 'autorizacion_password',
            'label'=>'Autorizacion contrasena',
            'required'=> true
        ));     
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'send',
            'value'=> $this->_getTranslation('Terminar'),
            'optionals'=>array(
                'onclick'=>"submit()"),
            'class'=>'btn btn-primary m-t-1 m-b-1'
        ));
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'cancelar',
            'value'=> $this->_getTranslation('Cancelar'),
            'optionals'=>array(
            'onclick'=>"document.location = '".ROOT_HOST."/Controller/Register.php'"),
            'class'=>'btn btn-danger m-t-1 m-b-1'
        ));

    }
    
    public function getListCajas(){
        $repository = new AperturaCierreCajaRepository();
        $list = $repository->getListEstacionesCajas($this->getId());
         
        $array = array('0'=>'Seleccionar una opcion...');
        foreach($list as $key => $value){
            $array[$key] = $value;
        }
        return $array;        
    }
    
    public function getListStatus(){
        $repository = new EstacionRepository();
        $list = $repository->getListStatus();
         
        $array = array(null=>'Seleccionar una opcion...');
        foreach($list as $key => $value){
            $array[$key] = $value;
        }
        return $array;        
    }
    
    public function getListTipos(){
        return array(
            '1'=>'Caja',
        );
    }
    
    public function populate($data){
        parent::populate($data);
    }
    
    public function isValid() {
        $element = 'idCaja';
        $propiedades = $this->getElement($element);        
        if(trim($propiedades['value'],' ') == '0'){ 
            $this->setErrorToElement(true, $element); 
            if(isset($propiedades['label'])){
                $this->errorRequeridos[] = $propiedades['label'];
            }
            
            $flashmessenger = new FlashMessenger();
            $flashmessenger->addMessage(array('danger'=>'Oops !! todos los campos marcados con <strong>X</strong> son requeridos.'));
            return null;
        }
        
        $result = parent::isValid();
        
        if($result){
            $entity = new AperturaCierreCajaRepository();
            if($entity->cajaAbiertaById($this->getId())){
                $flashmessenger = new FlashMessenger();
                $flashmessenger->addMessage(array('info'=>'Esta caja ya esta abierta.'));
            }
        }
        return $result;
    }
}