<?php
class SliceEntity extends SliceRepository{
    private $options = array (
        'id'=>null,
        'category' => null,
        'size' => null,
        'flavor'=>null,
        'price'=>null,
        'comments'=>null,
        'status'=>null);
    
    private $options_aux = array(
        'categoryName'=>null,
        'sizeName'=>null,
        'userName'=>null,
        'statusName'=>null
    );
    
    public function setOptions($data){
        foreach ($this->options as $option => $value){
            if(isset($data[$option])){
              $this->options[$option] = $data[$option];
            }
        }
        
        foreach ($this->options_aux as $option => $value){
            if(isset($data[$option])){
              $this->options_aux[$option] = $data[$option];
            }
        }
    }
    
    public function getCategoryName(){        
        return $this->options_aux['categoryName'];
    }
    
    public function getSizeName(){        
        return $this->options_aux['sizeName'];
    }
    
    public function getUserName(){        
        return $this->options_aux['userName'];
    }
    
    public function getStatusName(){        
        return $this->options_aux['statusName'];
    }
    
    public function getFlavor(){
        return $this->options['flavor'];
    }
    
    public function getStatus(){
        return $this->options['status'];
    }

    public function getOptions(){
        return $this->options;
    }
    
    public function getId() {
       return $this->options['id'];
    }
    
    public function resultSearchToExcel($options){
    $result = $this->paginationExcel($options);

    $reporte = new ReportFinanzasEntity();
    $reporte->setReporte($result);
    $reporte->setNombreReporteManual($this->_getTranslation('Partes del pastel'));
    $startDate = $options['startDate'];
    $endDate = $options['endDate'];
    if(trim($startDate)=='' && trim($endDate)==''){
            $startDate = $this->_getTranslation("Desde el inicio de los tiempos");
            $endDate = strftime('%B %d, %Y',strtotime('now'));
        }elseif(trim($startDate)=='' && trim($endDate)!=''){
            $startDate = $endDate;
        }elseif(trim($startDate)!='' && trim($endDate)==''){
            $endDate = $startDate;
        }
    $empresa = new EmpresaEntity();
    $empresa = $empresa->getById(1);
    $reporte->setHeaderExcelReportManual($empresa['name']."\n".$this->_getTranslation('Partes del pastel')."\n".$startDate." - ".$endDate);
    $reporte->getReporteOnFile();
  }
  
      public function paginationExcel($options){
      $category = null;
      $status = "";
      
      if(isset($options['category']) && $options['category']!='' && $options['category']!= null ){$category = "AND c.category = '".$options['category']."'";}
      if(isset($options['showCancel'])){$status = null;}
          
      $query = "SELECT c.id as '".$this->_getTranslation('#Entrada')."',                   
                fxGetVendorName(c.vendor) as '".$this->_getTranslation('proveedor')."',
                c.reference as '".$this->_getTranslation('Referencia')."',
                fxGetStatusName(c.`status`,'status','storeIn')as '".$this->_getTranslation('status')."'               
                FROM store_in c
                LEFT JOIN store_in_detalle d ON c.id = d.id_store_in
                WHERE  1=1
                $category
                $status" 
              . "GROUP BY c.id "
              . "ORDER BY c.id DESC ";

      $result = $this->query($query);
      if($result->num_rows > 0){
          return $this->resultToArray($result);
      }

      return null;   
  }
}