<?php
class RequisitionRepository extends EntityRepository {

    private $table = 'requisitions';
    public $flashmessenger = null;
    
    public function __construct() {
        if(!$this->flashmessenger instanceof FlashMessenger){
            $this->flashmessenger = new FlashMessenger();
        }
    }
  
    public function _getTranslation($text){
        return $this->flashmessenger->_getTranslation($text);
    }

    public function save(array $data, $table = null) {             
        $tools = new Tools();
        $login = new Login();
        $data['date'] = $tools->setFormatDateToDB($data['date']);
        $data['status'] = '1';        
        $data['status_baked'] = '1';        
        $data['creado_por'] = $login->getId();
        $data['creado_fecha'] = date('Y-m-d H:i:s');
        
        $this->startTransaction();        
        parent::save($data, $this->table);        
        
        $storeInDetailsTemp = new RequisitionDetailsTempRepository();
        $idRequisition = $this->getInsertId();
        $this->setLastInsertId($idRequisition);//Para utilizarlo en el Controller action insert
        
        $reqNumber = $this->createReqNumber($idRequisition);
        $this->updateString(array('req_number'=>$reqNumber), " id = '$idRequisition' ");
        
        if($storeInDetailsTemp->saveDetalles($idRequisition,$reqNumber)){   
            $this->commit();
            $storeInDetailsTemp->drop();

            return true;
        }
        
        $this->rollback();    
        $this->flashmessenger->addMessage(array(
            'error'=>$this->_getTranslation('Error. Intenta nuevamente o contacta a tu proveedor de sistemas.')));
        return null;        
    }
    
    public function delete($id, $table = null) {
        //return parent::delete($id, $this->table);
        return parent::update($id, array('status'=>'3'), $this->table);
    }
    
    public function update($id, $data, $table = null) {              
        $tools = new Tools();
        $login = new Login();
        $data['date'] = $tools->setFormatDateToDB($data['date']);
        $data['ultima_mod_por'] = $login->getId();
        $data['ultima_mod_fecha'] = date('Y-m-d H:i:s');
        $reqNumber = $data['req_number'];
        
        if(trim($data['status']) == ''){unset($data['status']);}      
        unset($data['req_number'],$data['status_baked']);
        
        $this->startTransaction();

        $result = parent::update($id, $data, $this->table);
        
        if($result){
            $repository = new RequisitionDetailsTempRepository();
            if($repository->updateDetalles($id,$reqNumber)){                                
                $this->commit();
                $repository->drop();   
                return true;
            }
        }
        
        $this->rollback();
        return null;
    }
    
     public function updateStatusRequisition($req_number){
        $query = "SELECT SUM(d.quantity)as quantity,SUM(d.delivery)as delivery "
               . "FROM requisitions_details_supplies d "
               . "WHERE d.req_number = '$req_number' "
               . "GROUP BY id_supplie";
        
        $result = $this->query($query);
        
        if($result){           
            $result = $this->resultToArray($result);
            $status = '2'; #Entregado
            $delivery = 0;
            foreach($result as $row){                
                $delivery += $row['delivery'];
                if($row['delivery'] < $row['quantity']){$status = '4';} #Parcial
            }
            
            if($delivery == 0){$status = '1'; }#Pendiente
            
            return $this->updateString(array('status'=>$status), " req_number = '$req_number' ");
        }
        return null;
    }
    
    public function updateString($fields, $where, $table = null) {
        return parent::updateString($fields, $where, $this->table);
    }

    public function getById($id, $table = null,$selectAux = null) {
        $select = "SELECT *,"
                . "DATE_FORMAT(date,'%d/%m/%Y')as dateFormated,"
                . "fxGetUserName(creado_por)as userName,"
                . "fxGetStatusName(status,'status','requisition')as statusName "
                . "FROM $this->table "
                . "WHERE id = '$id'";
        $result = $this->query($select);

        if ($result->num_rows>0) {
            $set = $this->resultToArray($result);
            return $set[0];
        }

        return false;
    }
    
    public function getByReqNumber($id, $table = null,$selectAux = null) {
        $select = "SELECT *,"
                . "DATE_FORMAT(date,'%d/%m/%Y')as dateFormated,"
                . "fxGetUserName(creado_por)as userName,"
                . "fxGetStatusName(status,'status','requisition')as statusName, "
                . "fxGetStatusName(status,'status_delivery','Special-requisition')as deliveryStatusName "
                . "FROM $this->table "
                . "WHERE req_number = '$id'";
        $result = $this->query($select);

        if ($result->num_rows>0) {
            $set = $this->resultToArray($result);
            return $set[0];
        }

        return false;
    }

    public function isUsedInRecord($id, array $buscarEn = null,$andWhere = null) {
        return null;
        return parent::isUsedInRecord($id, array('store-out' => 'requisition'));
    }
    
    public function crearTablaDetallesForUser(){
        $login = new Login();
        $query = "DROP TABLE IF EXISTS requisitions_details_".$login->getId();
        $this->query($query);
        
        $query = "CREATE TABLE IF NOT EXISTS requisitions_details_".$login->getId()." 
                 (  `id` int(11) NOT NULL AUTO_INCREMENT,
                    `id_detail` int(11) NULL,
                    `id_requisition` int(11) NULL,
                    `id_product` int(11) NOT NULL,
                    `quantity` double NOT NULL,
                    `produced` double NULL,
                    PRIMARY KEY (`id`)
                 )ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        
       $result = $this->query($query);
    }
    
    public function insertDetalle($data){
        $storeInDetailsTemp = new RequisitionDetailsTempRepository();
        
        return $storeInDetailsTemp->save($data);
    }
    
    public function getRequisitionDetailsSupplies($reqNumber){
        $query = "SELECT v.*,
                    fxGetCategoryDescription(slice_category)as slice_category,
                    CONCAT(id_supplie,'-',slice_category)as id_supplie,
                    v.id as idDetailTemp,
                    p.id as product,
                    p.code,
                    p.description,
                    fxGetUMDescription(p.unit_of_measurement)as um
                  FROM requisitions_details_supplies v LEFT JOIN supplies p
                  ON v.id_supplie = p.id
                  WHERE v.req_number = '$reqNumber'
                  ORDER BY fxGetCategoryDescription(slice_category) ";
        $result = $this->query($query);
        
        if($result){
            $result = $this->resultToArray($result);
            return $result;
        }
        
        return null;
    }
    
      public function getRequisitionDetails(){
        $login = new Login();
        $query = "SELECT v.*,
                    v.id as idDetailTemp,
                    p.id as product,
                    p.codigo as code,
                    p.descripcion as description,
                    fxGetCategoriaDescripcion(p.categoria)as category,
                    fxGetTamanoDescripcion(p.tamano)as size
                  FROM requisitions_details_".$login->getId()." v LEFT JOIN productos p
                  ON v.id_product = p.id
                  ORDER BY p.tamano ASC, p.descripcion ASC";
        $result = $this->query($query);
        
        if($result){
            $result = $this->resultToArray($result);
            return $result;
        }        
        return null;
    }
    
    /*
    public function getRequisitionDetailsSaved($id){
        $query = "SELECT c.*,
                    p.codigo as code,
                    p.descripcion as description,
                    fxGetTamanoDescripcion(p.tamano)as size
                    FROM requisitions_details c LEFT JOIN productos p ON c.id_product = p.id
                    WHERE c.id_requisition = '$id'";
        $result = $this->query($query);
        
        if($result){
            $result = $this->resultToArray($result);
            return $result;
        }
        
        return null;
    }*/
    
    public function getRequisitionDetailsSaved($id){
       $query = "SELECT c.*, 
                    p.codigo as code, 
                    IFNULL(s.id,10000000)AS slice_id,
                    IFNULL(s.flavor,'z')as flavor_name,
                    p.descripcion as description, 
                    fxGetTamanoDescripcion(p.tamano)as size 
                    FROM requisitions_details c 
                    LEFT JOIN productos p ON c.id_product = p.id 
                    LEFT JOIN products_details pd ON p.id = pd.id_product
                    LEFT JOIN slices s ON pd.id_slice = s.id 
                    WHERE c.id_requisition = '$id'
                    GROUP BY c.id 
                    ORDER BY flavor_name ASC,description ASC,p.tamano ASC  ";
        $result = $this->query($query);
        
        if($result){
            $result = $this->resultToArray($result);
            return $result;
        }
        
        return null;
    }
    
    public function setRequisitionDetailsById($idCompra){
        $repository = new RequisitionDetailsTempRepository();
        
        return $repository->setRequisitionDetailsById($idCompra);
    }
    
    public function truncateIfIsEditInfo(){
        $repository = new RequisitionDetailsTempRepository();
        $repository->truncateIfIsEditInfo();
        
    }
    
    public function getProductById($idProducto){
        $query = "SELECT * FROM productos WHERE id = '$idProducto' LIMIT 1";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $result = $this->resultToArray($result);
            return $result[0];
        }        
        return null;
    }
    
    public function getListRequisitions($options = null){              
        $store = null;
        $customer  = null;
        $home_service  = null;
        $status = null;
        $status_production = null;
        $date = null;
        $limit = null;
        
        if($options != null){
            $date = $this->createFilterFecha($options, 'date');      
            if(isset($options['store']) && $options['store']!='0'){$store = " AND store = '".$options['store']."'";}
            if(isset($options['customer']) && $options['customer']!=''){$customer = " AND customerName like '%".$options['customer']."%'";}
            if(isset($options['home_service']) && $options['home_service']!='0'){$home_service = " AND home_service = '".$options['home_service']."'";}
            if(isset($options['status']) && $options['status']!='0'){
                if($options['status'] == '2'){$options['status'] = '3';}
                $status = " AND r.status = '".$options['status']."'";                
            }
            if(isset($options['status_production']) && $options['status_production']!='0'){$status_production = " AND status_production = '".$options['status_production']."'";}         
        }else{
          $limit = " LIMIT 150";
          //return null;
        }
        
        #Estos campos no los contiene tblRequisitions
        #Si se esta tratando filtrar uno de estos campos para la busqueda en Horneado
        #No se tomata en cuenta esta tabla y se regresara null        
        if($store !== null || $customer !== null || $home_service !== null || $status_production !== null){
            return null;
        }        
        
        $query = "SELECT r.*,
                SUM(d.quantity)as quantity,
                DATE_FORMAT(r.date,'%m/%d/%Y')as date,
                DATE_FORMAT(r.date,'%m/%d/%Y')as date_american_format,
                fxGetStatusName(r.`status`,'status','Requisition')as statusName,
                fxGetUserName(r.creado_por) as user
                FROM requisitions r, requisitions_details d
                WHERE r.id = d.id_requisition
                $date "
              . "$status" 
              . "GROUP BY r.id "
              . "ORDER BY r.id DESC $limit ";

    
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            return $this->resultToArray($result);
        }        
        return null;
    }
    
    public function getListRequisitionsByIds($ids){          
        $query = "SELECT r.*,
                SUM(d.quantity)as quantity,
                DATE_FORMAT(r.date,'%d/%m/%Y')as date,
                fxGetStatusName(r.`status`,'status','Requisition')as statusName,
                fxGetUserName(r.creado_por) as user
                FROM requisitions r, requisitions_details d
                WHERE r.id = d.id_requisition 
                AND find_in_set(r.id,'$ids') " 
              . "GROUP BY r.id "
              . "ORDER BY r.id DESC ";

    
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            return $this->resultToArray($result);
        }        
        return null;
  }
  
   public function getListRequisitionsHorneado($options){     
       $store = null;
        $customer  = null;
        $home_service  = null;
        $status = null;
        $status_production = null;
        $date = null;
        $limit = null;

        if($options != null){
            $date = $this->createFilterFecha($options, 'date');      
            if(isset($options['store']) && $options['store']!='0'){$store = " AND store = '".$options['store']."'";}
            if(isset($options['customer']) && $options['customer']!=''){$customer = " AND customerName like '%".$options['customer']."%'";}
            if(isset($options['home_service']) && $options['home_service']!='0'){$home_service = " AND home_service = '".$options['home_service']."'";}
            if(isset($options['status']) && $options['status']!='0'){$status = " AND status = '".$options['status']."'";}
            if(isset($options['status_production']) && $options['status_production']!='0'){$status_production = " AND status_production = '".$options['status_production']."'";}         
        }else{
          $limit = " LIMIT 30";
          return null;
        }
        
        #Estos campos no los contiene tblRequisitions
        #Si se esta tratando filtrar uno de estos campos para la busqueda en Horneado
        #No se tomata en cuenta esta tabla y se regresara null        
        if($store !== null || $customer !== null || $home_service !== null || $status_production !== null){
            return null;
        }          
        
        $query = "SELECT r.*,
                SUM(d.quantity)as quantity,
                DATE_FORMAT(r.date,'%d/%m/%Y')as date,
                DATE_FORMAT(r.date,'%m/%d/%Y')as date_american_format,
                fxGetStatusName(r.`status`,'status','Requisition')as statusName,
                fxGetStatusName(r.`status_baked`,'status_baked','Special-requisition')as statusBakedName,
                fxGetUserName(r.creado_por) as user
                FROM requisitions r, requisitions_details d
                WHERE r.id = d.id_requisition AND status_baked = '2' 
                $date
                $status " 
              . "GROUP BY r.id "
              . "ORDER BY r.id DESC $limit";

    
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            return $this->resultToArray($result);
        }        
        return null;
  }
  
   public function getBakedPlan($idRequisitions){
        $query = "SELECT "
            . "SUM(srd.quantity * p.quantity)as quantity, "
            . "s.id as id_slice, "
            . "s.flavor, "
            . "fxGetSizeDescription(s.size)as sizeName "
            . "FROM $this->table sr, requisitions_details srd, products_details p, slices s "
            . "WHERE sr.id = srd.id_requisition "
            . "AND srd.id_product = p.id_product "
            . "AND p.id_slice = s.id "
            . "AND find_in_set(sr.id,'$idRequisitions') "
            . "AND sr.status = 1 "
            . "AND s.category = '1' "
            . "GROUP BY s.id";
        
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $result = $this->resultToArray($result);
            return $result;
        }
        return null;
    }
  
  public function setDeliveryQuantity($reqNumber,$entregados){
      if(!is_array($entregados)){
          return null;
      }

      $this->startTransaction();
      foreach($entregados as $idSupplie => $quantity){
           if(trim($quantity)==''){ $quantity = 0;}
           $query = "UPDATE requisitions_details_supplies SET delivery = '$quantity' "
                  . "WHERE req_number = '$reqNumber' "
                  . "AND CONCAT(id_supplie,'-',slice_category) = '$idSupplie' ";    

           $result = $this->query($query);
           if(!$result){
               $this->rollback();
               return null;
           }
      }

      $this->commit();
      return true;    
  }
  
  public function updateQuantityRequired($reqNumber,$requireds){
      if(!is_array($requireds)){
          return null;
      }
     
      $this->startTransaction();
      foreach($requireds as $idProduct => $quantity){
           if(trim($quantity)==''){ $quantity = 0;}
           $query = "UPDATE requisitions_details_supplies SET quantity = '$quantity' "
                  . "WHERE req_number = '$reqNumber' "
                  . "AND CONCAT(id_supplie,'-',slice_category) = '$idProduct' ";    

           $result = $this->query($query);
           if(!$result){
               $this->rollback();
               return null;
           }
      }

      $this->commit();
      return true;    
  }
  
  public function clearDeliveryQuantity($reqNumber){
      $query = "UPDATE requisitions_details_supplies SET delivery = '0' WHERE req_number = '$reqNumber'";
      $result = $this->query($query);
      
      if($result){
          return true;
      }
      return null;
  }
  
  public function setReturnedQuantity($reqNumber,$returned){
      if(!is_array($returned)){
          return null;
      }

      //$this->startTransaction();
      foreach($returned as $idProduct => $quantity){
           if(trim($quantity)==''){ $quantity = 0;}
           $query = "UPDATE requisitions_details_supplies SET returned = '$quantity' "
                  . "WHERE req_number = '$reqNumber' "
                  . "AND CONCAT(id_supplie,'-',slice_category) = '$idProduct' ";    

           $result = $this->query($query);
           if(!$result){
               $this->rollback();
               return null;
           }
      }

      //$this->commit();
      return true; 
  }
  
  public function clearReturnedQuantity($req_number){
      $query = "UPDATE requisitions_details_supplies SET returned = '0' WHERE req_number = '$req_number'";
      $result = $this->query($query);
      
      if($result){
          return true;
      }
      return null;
  }
  
  public function getTotalRequiredAndProduced(){
      /* Se debe setear $this->setId para que este disponible en este query*/
      $query = "SELECT SUM(quantity)as totalRequired,SUM(produced)as totalProduced "
              . "FROM requisitions_details "
              . "WHERE id_requisition = '{$this->getId()}'";              
              
      $result = $this->query($query);
      
      if($result){
          $result = $result->fetch_object();
          return $result;
      }
      return null;
  }
  
    public function createReqNumber($idRequisition){
        return $this->getPrefixNumberRequisitionOfLine().str_pad($idRequisition, 7, '0', STR_PAD_LEFT);
    }
  
   public function getPrefixNumberRequisitionOfLine(){
      $settings = new SettingsEntity();
      $prefix = $settings->_get('prefix_for_line_requisition');
      if($prefix){
          return $prefix;
      }
      return '';
  }
    
    public function createFilterFecha($options,$campoFecha = null ){
        if(!isset($options['startDate']) && !isset($options['endDate'])){return null;}        
        $startDate = $options['startDate'];
        $endDate = $options['endDate'];
        $fecha = null;
        $tools = new Tools();
        if($startDate!=null){
            $startDate = $tools->setFormatDateToDB($startDate);
            if($endDate!=null){
                $endDate = $tools->setFormatDateToDB($endDate);
                $fecha .=" AND $campoFecha BETWEEN '{$startDate}' AND '{$endDate}' ";
            }else{
                $fecha .=" AND $campoFecha BETWEEN '{$startDate}' AND '{$startDate}' ";
            }
        }elseif($endDate!=null){
            $fecha .=" AND $campoFecha BETWEEN '{$endDate}' AND '{$endDate}' ";
        }
        
        return $fecha;
    }
}