<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

class EstacionRepository extends EntityRepository {

    private $table = 'estaciones';

    public function save(array $data, $table = null) {
        $login = new Login();
        $data['creado_fecha'] = date('Y-m-d');
        $data['creado_por'] = $login->getId();
        $data['status'] = 1;
        unset($data['modificaciones'],$data['habilitadaParaAbrir']);

        return parent::save($data, $this->table);
    }
    
    public function delete($id, $table = null) {        
        return parent::delete($id, $this->table);
    }

    public function update($id, $data, $table = null) {
        unset($data['creado_fecha'],$data['creado_por'],$data['status'],$data['modificaciones'],$data['habilitadaParaAbrir']);
        
        return parent::update($id, $data, $this->table);
    }

    public function getById($id, $table = null,$selectAux = null) {
        return parent::getById($id, $this->table,$selectAux);
    }
    
    public function getByToken($token){
        $query = "SELECT * FROM $this->table WHERE token = '$token'";
        $result = $this->query($query);
        
        if($result->num_rows > 0){            
            $result =  $this->resultToArray($result);
            return $result[0];
        }
        return null;
    }
    
    public function getTipoByToken($token) {
        $query = "SELECT tipo FROM $this->table WHERE token = '$token'";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $result = $result->fetch_object();
            return $result->tipo;
        }
        return null;
    }

    public function isUsedInRecord($id, array $buscarEn = null,$andWhere = null) {
        return parent::isUsedInRecord($id, array('productos' => 'marca'));
    }

    public function getListaSelectEstaciones() {
        $select = "SELECT * FROM $this->table ";
        $result = $this->query($select);

        if ($result) {
            $array = array();
            while ($row = $result->fetch_assoc()) {
                $array[$row['id']] = $row['nombre'];
            }
            return $array;
        }
        return null;
    }
    
     public function getListaEstaciones() {
        $select = "SELECT *,"
                . "fxGetStatusName(status,'status','estacion')as status,"
                . "fxGetTipoEstacionName(tipo)as tipo from $this->table ";
        $result = $this->query($select);

        if ($result) {
           return $this->resultToArray($result);
        }
        return null;
    }
    
    public function getListStatus(){
        $query = "SELECT * FROM codigo_status WHERE tipo = 'estacion'";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $array = array();
            foreach($result as $status){
                $array[$status['codigo']] = $status['descripcion'];
            }
            return $array;
        }
        return null;
    }
    
    public function existeNombre($nombre,$idEstacion = null){
        $nombre = strtolower(trim($nombre));
        if($nombre == ''){return null;}
        else{$nombre = " nombre = '$nombre' ";}
        if($idEstacion != null && trim($idEstacion)!=''){$idEstacion = " AND id != '$idEstacion' ";}
        
        $query = "SELECT id FROM estaciones WHERE $nombre $idEstacion LIMIT 1 ";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $result =  $this->resultToArray($result);
            return $result[0];
        }
        return null;
    }
    
    public function existeToken($token,$idEstacion = null){
        $token = strtolower(trim($token));
        if($token == ''){return null;}
        else{$token = " token = '$token' ";}
        if($idEstacion != null && trim($idEstacion)!=''){$idEstacion = " AND id != '$idEstacion' ";}
        
        $query = "SELECT nombre FROM estaciones WHERE $token $idEstacion LIMIT 1 ";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $result =  $this->resultToArray($result);
            return $result[0];
        }
        return null;
    }
    
    public function enableToOpen($id){
        return parent::update($id, array('habilitadaParaAbrir'=>'1'), $this->table);
    }
    
    public function disableToOpen($id){
        return parent::update($id, array('habilitadaParaAbrir'=>'0'), $this->table);
    }
}