<?php 
$controller = 'Production';
$action = '';
if(isset($_POST['action'])){
    $action = $_POST['action'];
    if (isset($_POST['id'])) {$id = $_POST['id'];}
}elseif(isset($_GET['action'])){
    $action = $_GET['action'];
    if (isset($_GET['id'])) {$id = $_GET['id'];}
}
include $_SERVER["DOCUMENT_ROOT"].'/app/include/bootstrap.php';
   
$_form = new ProductionForm();
$_production = new ProductionEntity();

switch($action){
    case 'insert':
        $_form->populate($_POST);
        if($_form->isValid()){
            $_production->setOptions($_POST);
            $result = $_production->save($_production->getOptions());
            if($result){
                $flashmessenger->addMessage(array('success'=>'El registro de produccion se registro correctamente.'));
                header('Location: Production.php');
            }else{
                $flashmessenger->addMessage(array('danger'=>'Error. Intenta nuevamente o contacta a tu proveedor de sistemas.'));
            }
        }else{
            $vista = 'Production.php';
            include $root.'/View/Template.php';
        }
        break;
   
    case 'edit':
        $loadLineDataTemp = $_production->getById($id);
        $_statusName = $loadLineDataTemp['statusName'];
        
        if($_GET){$_productionData = $_production->getById($id);}
        if($_POST){$_productionData = $_POST;}
        
        $_form->setActionController('edit');
        $_form->setId($id);
        $_form->populate($_productionData);
        
        if(isset($_POST['id'])){
            if($_form->isValid()){
                $_production->setOptions($_productionData);
                $result = $_production->update($id,$_production->getOptions()); //no tengo id porque viene de post
                if($result){
                    $flashmessenger->addMessage(array('success'=>'El registro de produccion se actualizo correctamente.'));
                    header("Location: Production.php?action=edit&id=$id");
                }else{
                    $flashmessenger->addMessage(array('danger'=>'Error. Intenta nuevamente o contacta a tu proveedor de sistemas.'));
                }       
            }else{
                $vista = 'Production.php';
                include $root . '/View/Template.php';
            }
        }else{
            $vista = 'Production.php';
            include $root . '/View/Template.php';
        }        
        break;
        
     case 'ajax':
        $loadLineAjax = new ProductionAjax();
        $json = $loadLineAjax->getResponse($_POST['request'],$_POST);
        
        echo json_encode($json);
        break;       
    
    case 'delete': 
        if(!$_production->isUsedInRecord($id)){
            if($_production->delete($id)){
                $flashmessenger->addMessage(array('success'=>'El registro de produccion fue eliminado correctamente.'));
            }
        }else{
            $message = 'Hola !! esta cantidad no puede ser eliminada, esta siendo utilizado en almenos un registro.';
            $flashmessenger->addMessage(array('info'=>$message));
        }
        header('Location: Production.php');
        break;
    
    default:      
        $template = "Template.php";
        $_form->setActionController('');        
        $idLoadLine = null;        
        $loadLinesActives = null;
        $loadLinesList = $_form->getElement('id_load_line');
        $loadLinesList = $loadLinesList['multiOptions'];

        if(count($loadLinesList)>0){
            $loadLinesActives = true;
        }   
        
        $_loadLineEntity = new LoadLineEntity();
        $_login = new Login();
        if($_login->getRole()=='3'){
            $template = "TemplateProduction.php";
            $_POST['id_load_line'] = $_loadLineEntity->getLoadLineByLine($_login->getLine());
            if($_POST['id_load_line']==null){
                unset($_POST['id_load_line']);
                $loadLinesActives = null;        
            }
        }      
       
        if(isset($_POST['id_load_line'])){
            $idLoadLine = $_POST['id_load_line'];     

            if($idLoadLine!== null && $idLoadLine!== '' ){
                $_form->setValueToElement($idLoadLine, 'id_load_line');                
                $_loadLineEntity->setOptions($_loadLineEntity->getById($idLoadLine));
                
                if($_loadLineEntity->getType() == 'Line'){
                    $_requisitionEntity = new RequisitionEntity();
                    $_form->setValueToElement('Line','type');
                }elseif($_loadLineEntity->getType() == 'Special'){
                    $_requisitionEntity = new SpecialRequisitionEntity();
                    $_form->setValueToElement('Special','type');
                }                
                
                $options = $_requisitionEntity->getByReqNumber($_loadLineEntity->getReqNumber());
                $_requisitionEntity->setOptions($options);
                $_requisitionEntity->setId($options['id']);
                
                $_form->setValueToElement($_requisitionEntity->getId(),'id_requisition');
                $_form->setValueToElement($_requisitionEntity->getReqNumber(),'req_number');                
                
                $_requisitionDetails = $_requisitionEntity->getRequisitionDetailsSaved($_requisitionEntity->getId(),true);

                $_requistionTotals = $_requisitionEntity->getTotalRequiredAndProduced();
                $_listProduction = $_production->getListProduction($idLoadLine);
            }       
        }
        
        $vista = 'Production.php';
        include $root."/View/$template";
}