<?php 
    $controller = 'Pos';
    $action = 'print';
    include $_SERVER["DOCUMENT_ROOT"].'/app/include/bootstrap.php';?>
<!DOCTYPE html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width,initial-scale=1.0,minimum-scale=1.0,maximum-scale=1.0,user-scalable=no">
    <link href="<?php echo ROOT_HOST?>/public/bootstrap/css/bootstrap.min.css" rel="stylesheet">     
</head>
<body>
     <iframe name="print_frame" width="0px" height="0px" frameborder="0" src="about:blank"></iframe>
    <?php
    # INFORMACION EMPRESA
    $empresa = new EmpresaEntity();
    $empresa->setOptions($empresa->getById(1)); 
    
    $nombreEmpresa  = $empresa->getNombre();
    $direccion      = $empresa->getDireccion();
    $ciudadEstadoZC = $empresa->getCiudad().', '.$empresa->getEstado().' '.$empresa->getCodigoPostal();
    $telefono       = $empresa->getTelefono();  
    $paginaWeb      = $empresa->getPaginaWeb();
    
    # INFORMACION VENTA
    $idVenta = $_GET['idVenta'];
    $entityVenta = new VentaEntity();
    $options = $entityVenta->getById($idVenta);
    
    if($options == null){ 
        $entityVenta->flashmessenger->addMessage(array('danger'=>'Uppss. Venta no registrada.'));
        $msg = $entityVenta->flashmessenger->getMessageString();
        echo "<script>window.parent.$('#flashmessenger').html(\"{$msg}\");fadeOutAlert();</script>";
        exit;
    }
       
    $entityVenta->setOptions($options);
    $entityVenta->setId($idVenta);    
    $numVenta = $entityVenta->getNumVenta();
    
    $sucursalRepo = new SucursalRepository();
    $sucursalData = $sucursalRepo->getById($options['idSucursal']);
    $nombreSucursal = $sucursalData['nombre'];
    
    $ventaData = $entityVenta->getOptions();
    $cajero = $entityVenta->getUsuarioName();
    $fechaCreacion = strftime('%d/%m/%y %H:%M:%S',strtotime($entityVenta->getFechaCreacion()));
    
    # INFORMACION VENTA DETALLES
    $productoEntity = new ProductoRepository();
    $detalles = $entityVenta->getVentaDetallesSaved($idVenta);
    $listDetalles = "";
    $subtotal = 0;
    $montoTotal = 0;
    $montoImpuestos = 0;
    $descuentoOrdenTotal = 0;
    $itemsTotal = 0;
    
    $repo = new ImpuestosRepository();
    $listaImpuestos = $repo->getInfoImpuestos();
    $impuestosAplicables = array();   
    
    foreach($detalles as $detalle){    
        $itemsTotal += $detalle['cantidad'];
     
        $total = $detalle['cantidad'] * $detalle['precio_sin_impuestos'];
        $subtotal += $total;
        $total -= $detalle['descuento_item_monto'];
        $total -= $detalle['descuento_orden_monto'];

        $descuentoOrdenTotal += $detalle['descuento_item_monto'];
        $descuentoOrdenTotal += $detalle['descuento_orden_monto'];          

        $montoTotal += $total;           
        $montoImpuestos += $detalle['impuestos_monto'];              
       
        $listDetalles .= "<tr>
                        <td class='text-center'>{$detalle['cantidad']}</td>
                        <td>"
                            .ucfirst($detalle['descripcion'].' '.$detalle['tamanoName'])."<br/>"
                            #. "<span style='font-size:12px'>".ucfirst($tamano)."</span>
                        ."</td>
                        <td style='text-align:right'>$".number_format($total,2)."</td>";
        $listDetalles .= "</tr>";
    }
    
    $subtotalMenosDescuento =  number_format(round($subtotal - $descuentoOrdenTotal,2,PHP_ROUND_HALF_UP),2); 
    $subtotal = number_format(round($subtotal,2,PHP_ROUND_HALF_UP),2);  
    
    $montoTotalSinFormato = round($montoTotal  + $montoImpuestos,2,PHP_ROUND_HALF_UP);
    $totalRecibido = $ventaData['total_recibido'];
    $cambio = number_format(round($totalRecibido  - $montoTotalSinFormato,2,PHP_ROUND_HALF_UP),2);
   
    $montoTotal = number_format($montoTotalSinFormato,2);
    $totalRecibido = number_format(round($totalRecibido,2,PHP_ROUND_HALF_UP),2);
    
    $descuentoOrdenTotal = number_format(round($descuentoOrdenTotal,2,PHP_ROUND_HALF_UP),2);    
    $montoImpuestos = number_format(round($montoImpuestos,2,PHP_ROUND_HALF_UP),2);    
    
    /*INFORMACION DETALLES PAGO*/
    $detallesPago = $entityVenta->getCobrosDetalleByIdVenta($idVenta);
    $pagos = array();     
    $cardPaymentFlag = NULL;
    
    foreach($detallesPago as $detalle){
        if($detalle['formaPago']==6 || $detalle['formaPago']==5){
            //Si es true significa que el pago fue realizado con tarjeta de debito y credito.
            $cardPaymentFlag = true;
        }
        $forma = $_translator->_getTranslation($detalle['formaPagoName']);
        $forma .= " ".$detalle['last_4'];
        $monto = number_format(round($detalle['monto'],2,PHP_ROUND_HALF_UP),2); 
        
        $pagos[] = array(
            'forma'=>$forma,
            'monto'=>$monto
        );
    }
    ?>
        <div id="printArea" style="margin:auto;width: 80mm;font-size: 14px">
        <div style="margin:auto;font-size: 10px;font-family: Arial,Helvetica Neue,Helvetica,sans-serif">
        <div style="text-align: center">
            <div style="margin: 30px;margin-bottom: 10px">
                <img src="../../public/img/logo_login.png" width="50%">
            </div>            
            <h4 style="margin-bottom:0px"><?php echo $nombreEmpresa;?></h4>  
            <p style="margin:0px;"><?php echo $direccion; ?></p>
            <p style="margin:0px;"><?php echo $ciudadEstadoZC; ?></p>
            <p style="margin:0px;"><?php echo $telefono;?></p>
            <br/>
            <h4 style="margin-bottom:0px">* * * *<?php echo $_translator->_getTranslation('Cancelada');?>* * * *</h4> 
            <br/>
        </div> 
        <div>    
            <p style="margin:0px;"><?php echo $_translator->_getTranslation('Venta')?> #: <?php echo $idVenta?></p>
            <p style="margin:0px;"><?php echo $_translator->_getTranslation('Fecha')?>: <?php echo $fechaCreacion;?></p>
            <p style="margin:0px;"><?php echo $_translator->_getTranslation('Sucursal')?>: <?php echo $nombreSucursal?></p>
            <p style="margin:0px;"><?php echo $_translator->_getTranslation('Cajero')?>: <?php echo $cajero?></p>            
            <p style="margin:0px;"><?php echo $_translator->_getTranslation('Items')?>: <?php echo $itemsTotal;?></p>
        </div> 
        <style>.table > tbody > tr > td, .table > tbody > tr > th, .table > tfoot > tr > td, .table > tfoot > tr > th, .table > thead > tr > td, .table > thead > tr > th{padding:2px; font-size: 12px}</style>
        <table class="m-t-1 table table-condensed tableTicket">
        <thead>
            <th style="width:10%"><?php echo $_translator->_getTranslation('Cant')?></th>
            <th style="width:65%"><?php echo $_translator->_getTranslation('Descripcion')?></th>
            <th style="width:25%;text-align: right">Total</th>
        </thead>
        <tbody>
        <?php echo $listDetalles;?>
        <tr style="border: 1px solid #f3f3f3"></tr>        
        <tr>
            <td colspan="2" style="border:0px;text-align: right;margin:0px;padding:0px"><?php echo $_translator->_getTranslation('Subtotal')?></td>
            <td style="border:0px;text-align: right;margin:0px;padding:0px">$ <?php echo $subtotal?></td>
        </tr>        
       <?php if($descuentoOrdenTotal != '0'){?>
        <tr>
            <td colspan="2" style="border:0px;text-align: right;margin:0px;padding:0px"><?php echo $_translator->_getTranslation('Descuento')?></td>
            <td style="border:0px;text-align: right;margin:0px;padding:0px">$ <?php echo $descuentoOrdenTotal?></td>
        </tr>
        <tr>
            <td colspan="2" style="border:0px;text-align: right;margin:0px;padding:0px"><?php echo $_translator->_getTranslation('Subtotal')?></td>
            <td style="border:0px;text-align: right;margin:0px;padding:0px">$ <?php echo $subtotalMenosDescuento; ?></td>
        </tr>
        <?php }?>
         <tr style="border:0px">
            <td colspan="2" style="border:0px;text-align: right;margin:0px;padding:0px"><?php echo $_translator->_getTranslation('Impuestos')?></td>
            <td style="border:0px;text-align: right;margin:0px;padding:0px">$ <?php echo number_format(round($montoImpuestos,2,PHP_ROUND_HALF_UP),2);?></td>
        </tr>
        
        <tr style="border:0px;">
            <td colspan="2" style="border:0px;text-align: right;margin:0px;padding:0px"><b><?php echo $_translator->_getTranslation('Total')?></b></td>
            <td style="border:0px;text-align: right;margin:0px;padding:0px"><b>$ <?php echo $montoTotal?></b></td>
        </tr>
        <tr style="border:0px;">
            <td colspan="2" style="border:0px;text-align: right;margin:0px;padding:0px"><b><?php echo $_translator->_getTranslation('Recibido')?></b></td>
            <td style="border:0px;text-align: right;margin:0px;padding:0px"><b>$ <?php echo $totalRecibido;?></b></td>
        </tr>
        <tr style="border:0px;">
            <td colspan="2" style="border:0px;text-align: right;margin:0px;padding:0px"><b><?php echo $_translator->_getTranslation('Cambio')?></b></td>
            <td style="border:0px;text-align: right;margin:0px;padding:0px"><b>$ <?php echo $cambio ?></b></td>
        </tr>
        <tr>
            <td colspan="2" style="border:0px;text-align: right;margin:0px;padding:0px"><?php echo $_translator->_getTranslation('Forma de pago')?></td>
        </tr>
        <?php
            foreach($pagos as $pago ){?>
        <tr>
            <td colspan="2" style="border:0px;text-align: right;margin:0px;padding:0px"><?php echo $_translator->_getTranslation($pago['forma']);?></td>
            <td style="border:0px;text-align: right;margin:0px;padding:0px">$ <?php echo $pago['monto'];?></td>
        </tr>
        <?php }?>
        </tbody>
    </table> 
    <div style="text-align: center">        
        <p style="margin:0px"><?php echo $_translator->_getTranslation('Gracias por su visita.')?></p>
        <p style="margin:0px"><?php echo $_translator->_getTranslation('Que tenga un excelente dia.')?></p>
    </div>           
    <br/>
    </div>
    </div>
<script type="text/javascript">  
        //printDivCSS = new String ();
        
        function print(ticket){
            window.frames["print_frame"].document.body.innerHTML = document.getElementById(ticket).innerHTML;
            window.frames["print_frame"].window.focus();
            window.frames["print_frame"].window.print();
        }
        
        print('printArea');
        //setTimeout("print('printArea')",1000);
    </script>
</body>
</html>