<?php 
    if($data != null){ 
        $requisitionsList = $data['requisitionsList'];
        foreach($requisitionsList as $row){
            $newRow = array(
                'req_number'=>$row['req_number'],
                'storeName'=>$row['storeName'],
                'delivery_date'=>$row['delivery_date'],
                'delivery_time'=>$row['delivery_time'],
            );
            $newData[] = $newRow;
        }
        
        $requisitionsList = $newData;
        $colTitulosTemp = $requisitionsList[0];    
        
        $requisitionsDetailsList = $data['requisitionsDetailsList'];        
        $details = array();
        foreach($requisitionsDetailsList as $detail){
            $details[$detail['req_number']][] = $detail;
        }       

        $fieldsToPrint = array(
            'req_number'=>'No',
            'storeName'=>'Sucursal',
            'delivery_date'=>'Fecha entrega',
            'delivery_time'=>'Hora entrega',
        );

        foreach($fieldsToPrint as $titulo => $value){
            if(key_exists($titulo, $colTitulosTemp)){            
                $colTitulos[] = $fieldsToPrint[$titulo];
            }
        }
        
        $colTitulos[] = 'Pan';

        $objPHPExcel = new PHPExcel();
        $objPHPExcel->getActiveSheet()->freezePane('A3');
        $col = count($colTitulos);
        $lastCol = $this->getColLetter($col-1);        
        
        foreach($objPHPExcel->getActiveSheet()->getRowDimensions() as $rd) { 
            $rd->setRowHeight(-1); 
        }

        $objPHPExcel->getActiveSheet()->mergeCells("A1:".$lastCol."1");            
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(50);
        $objPHPExcel->getActiveSheet()->getStyle("A1")->getFont()->setBold(true);
        $objPHPExcel->getActiveSheet()->setCellValue("A1", $this->headerExcelReport);
        $objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setWrapText(true);
        $objPHPExcel->getActiveSheet()->getStyle("A1")->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->getActiveSheet()->getStyle("A1")->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
        
        $objPHPExcel->getActiveSheet()->getStyle("A2:{$lastCol}2")->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->getActiveSheet()->getStyle("A2:{$lastCol}2")->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);                   

        $objPHPExcel->getActiveSheet()->fromArray($colTitulos,NULL,'A2');    

        $row=3;
        foreach ($requisitionsList as $key => $data) {                        
            $objPHPExcel->getActiveSheet()->getStyle("A$row:$lastCol$row")->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle("A$row:$lastCol$row")->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle("A$row:$lastCol$row")->getAlignment()->setWrapText(true);
            $i=0;     
            foreach ($data as $col => $value) {             
                if(key_exists($col, $fieldsToPrint)){ 
                    $col = $this->getColLetter($i);
                    $objPHPExcel->getActiveSheet()->setCellValue($col . $row, $value);
                    $i++;
                }
            }
            
            if(isset($details[$data['req_number']])){
                $panCategorias = array(1,3,4,5,6,7,8,9,32,33,34,35,36,37,38,39,40,41,42,43,44,46,48,49,50,51,52,53,54,55,56,57,58,59,61,62,63);
                #Imprimir columna de pan (category = 1)
                $string = '';                
                $detailsReq = $details[$data['req_number']];
                foreach($detailsReq as $detail){
                    if(in_array($detail['category'], $panCategorias)){
                        $string .= $detail['quantity']." ".$detail['categoryName']." ".$detail['flavor']." ".$detail['sizeName']."\n";
                    }                    
                }
                
                $col = $this->getColLetter($i);
                $objPHPExcel->getActiveSheet()->setCellValue($col . $row, $string);
                $objPHPExcel->getActiveSheet()->getStyle("$col$row")->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
                $i++;
            }
       
            $row++;
        }
        
        foreach(range('A',$lastCol) as $columnID) {
            $objPHPExcel->getActiveSheet()->getColumnDimension($columnID)
                ->setAutoSize(true);
        }

        $objPHPExcel->setActiveSheetIndex(0);   
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');

        if($this->saveFile == true){
            $objWriter->save($this->getTempFolder()."/".$this->getNombreArchivo().".xlsx");
        }else{                
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header("Content-Disposition: attachment;filename=".$this->getNombreArchivo().".xlsx");
            header('Cache-Control: max-age=0');
            $objWriter->save('php://output');
            exit;
        }
        unset($objWriter);
    }else{
        $this->flashmessenger->addMessage(array('info'=>'No se encontraron resultados con la seleccion.'));
    }