<?php
class RequisitionForm extends Form {    
    public function __construct() {
        $this->setName('requisition');
        $this->setActionForm('Requisition.php');
        $this->setClass('requisition form-horizontal');
        $this->setMethod('post');
        parent::__construct();
        $this->init();
    }

    public function init() {        
        $attributes_wrapper_append_select = array('class'=>'select2-bootstrap-append');
        
        $attributes_wrapper_append_date = array('class'=>'date','id'=>'dateDatePicker');
        $append = "<span class = 'btn input-group-addon'><i class='fa fa-calendar'></i></span>";
        $this->addElement(array(
            'type' => 'text',
            'name' => 'date',
            'label'=>'Fecha',
            'validators'=>array('date'),
            'required'=>true,
            'append'=>$append,
            'wrapper_attributes'=>$attributes_wrapper_append_date
        ));  
        
        $this->addElement(array(
            'type' => 'textarea',
            'name' => 'comments',
            'label'=>'Notas',
            'required'=>false
        ));          
                 
         /*Se utiliza para consulta si existe en la tabla de requisitions_details_X, si existe se actualiza registro.*/
         $this->addElement(array(
            'type' => 'hidden',
            'name' => 'idDetailTemp',
            'required'=>false
        )); 
         
        /*Num requisicion con prefijo*/
        $this->addElement(array(
            'type' => 'hidden',
            'name' => 'req_number',
            'required'=>false
        )); 
         
         $append = "<span class = 'btn input-group-addon' data-toggle='modal' data-target='#modalAgregarProducto'><i class='fa fa-plus'></i></span>";
         $this->addElement(array(
            'type' => 'select',
            'name' => 'product',
            'label'=>'Producto',
            'multiOptions'=>$this->getListProducts(),
            'col-size-label'=>'12',
            'col-size-element'=>'12',
            'append'=>$append

         ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'quantity',
            'label'=>'Cantidad',
            'required'=>false,
            'col-size-element'=>'12'
        ));
        
        $this->addElement(array(
            'type'=>'button',
            'name'=>'buscar',
            'value'=>$this->_getTranslation('Agregar'),
            'class'=>'btn btn-success',
            'optionals'=>array('onClick'=>'setRequisitionDetails()')
        ));
        
        $this->addElement(array(
            'type'=>'button',
            'name'=>'terminar',
            'value'=>$this->_getTranslation('Terminar'),
            'class'=>'btn btn-primary',
            'optionals'=>array("onClick"=>"submit('requisition')")
        ));        
    }
    
    public function getListProducts(){
        $repository = new ProductoRepository();
        #1 = status activo
        $productos = $repository->getListaProductos('producto');

        $array = array('0'=>'Seleccionar una opcion...');        
        foreach($productos as $producto){      
            $array[$producto['id']] = $producto['codigo']." - ".$producto['descripcion']." ".$producto['tamano'];
        }
        
        $list= array();
        foreach ($array as $key => $value) {
            $list[$key] = $value;
        }
        return $list;
    }
    
    
    public function populate($data) { 
        $tools = new Tools();
        if(isset($data['date']) && $tools->isValidaDateYYYMMDD($data['date'])){
            $data['date'] = $tools->setFormatDateToForm($data['date']);
        }
        parent::populate($data);
    } 
}