<?php
/**
 * Description of NivelForm
 *
 * @author carlos
 */

class ProductionForm extends Form {

    public function __construct() {
        $this->setActionForm('Production.php');
        $this->setClass('production');
        $this->setMethod('post');
        $this->setDefaultFormElementsColSize('8');
        $this->setDefaultFormLabelsColSize('4');
        parent::__construct();
        $this->init();
    }

    public function init() {
        $this->addElement(array(
            'type' => 'text',
            'name' => 'date',
            'label'=>'Fecha',
            'required'=> true,
            'value'=>date('m/d/Y'),
            'validators'=>array('date')
        ));
        
         $this->addElement(array(
            'type' => 'hidden',
            'name' => 'id_product',
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'product',
            'label'=>'Producto',
            'optionals'=>array('placeholder'=>'Teclea o escanea producto para venta')
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'quantity',
            'label'=>'Cantidad',
            'required'=> true,
            'validator'=>array('double')
        ));
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'send',
            'value'=> $this->_getTranslation('Terminar'),
            'optionals'=>array(
                'onclick'=>"submit()"),
            'class'=>'btn btn-primary m-t-1 m-b-1'
        ));
        
        $this->addElement(array(
            'type' => 'button',
            'name' => 'cancelar',
            'value'=> $this->_getTranslation('Cancelar'),
            'optionals'=>array(
                'onclick'=>"document.location = '".ROOT_HOST."/Controller/Brand.php'"),
            'class'=>'btn btn-danger m-t-1 m-b-1'
        ));
    }
    
    public function populate($data){
        $tools = new Tools();
        $data['date'] = $tools->setFormatDateToForm($data['date']);
        parent::populate($data);
    }
}