<?php
class VentaRepository extends EntityRepository {

    private $table = 'ventas';
    public $flashmessenger = null;
    
    public function __construct() {
        if(!$this->flashmessenger instanceof FlashMessenger){
            $this->flashmessenger = new FlashMessenger();
        }
    }
    
    public function _getTranslation($text){
        return $this->flashmessenger->_getTranslation($text);
    }

    public function savePos(array $data, $table = null) {
        $ventaDetallesTemp = new VentaDetallesTempRepository();
        
        if(!$ventaDetallesTemp->isThereItemsOnSale()){
            $this->flashmessenger->addMessage(array('danger'=>'Debe registrar un producto por lo menos, para guardar la venta.'));
            return null;
        }       
        
        $data['num_venta'] = $this->getNextSaleNum();
        
        /*La linea de abajo la habia puesto, para obtener el total de venta directamente de la tabla de ventasdetalles 
          Esto para evitar que se modificara usando una herramienta de debug en el navegador */
        $totalesVenta = $ventaDetallesTemp->getTotalesVenta();
        $data['importe'] = $totalesVenta['importe'];
        $data['descuento_items_monto'] = $totalesVenta['descuento_items_monto'];
        $data['descuento_orden_monto'] = $totalesVenta['descuento_orden_monto'];
        $data['subtotal'] = $totalesVenta['subtotal'];
        $data['total_impuestos'] = $totalesVenta['total_impuestos'];
        $data['total_venta'] = $totalesVenta['total_venta'];
        
        $login = new Login();
        $data['idCaja']= $login->getIdCaja();
        $data['idSucursal']= $login->getSucursal();
        $data['creado_por'] = $login->getId();
        $data['creado_fecha'] = date('Y-m-d H:i:s');        
        $data['status'] = '2';        
        $tools = new Tools();
        $data['fecha'] = $tools->setFormatDateToDB($data['fecha']);
        $data['ticket'] = $tools->uniqidReal();
        
        if($data['id']==null || $data['id']==''){unset($data['id']);}
        
        foreach($data as $key => $value){
            if($value == '' || $value === null ){
                $data[$key] = array('key'=>$key,'value'=>'NULL');                
            }
        }       
        
        $cambio = $data['cambio'];
        unset($data['cambio']);
        //echo "<pre>";var_dump($data);echo "</pre>";exit;
        $this->startTransaction();
        parent::save($data, $this->table);      
        
        $idVenta = $this->getInsertId();
        $this->setLastInsertId($idVenta); // para mostrar id en link de impresion despues de guardar venta
        
        if($ventaDetallesTemp->saveDetalles($idVenta,$data['ticket'])){
            $repositoryCobro = new CobroTempRepository();
            
            if(!$repositoryCobro->saveCobros($idVenta,$data['total_venta'],$cambio)){
                $this->rollback();
                return null;
            }           
            
            #Es pago de specialRequisition
            if($data['id_special_requisition']!='0'){
                if(!$this->setAmmountPaymentsOfSpecialRequisition($data['id_special_requisition'])){
                    $this->rollback();
                    return null;
                }
            }
            
            $ventaDetallesTemp->clearDetalles();
            $repositoryCobro->clearDetalles();
            $this->commit();        
            
            return true;
        }
        
        $this->rollback();        
        return null;
    }
    
    public function suspenderVenta($data){
        $ventaDetallesTemp = new VentaDetallesTempRepository();
        
        if(!$ventaDetallesTemp->isThereItemsOnSale()){
            $this->flashmessenger->addMessage(array('danger'=>'Debe registrar un producto por lo menos, para guardar la venta.'));
            return null;
        }        
        
        $login = new Login(); 
        $data['creado_por'] = $login->getId();        
        $data['creado_fecha'] = date('Y-m-d H:i:s');
        $data['idCaja'] = $login->getIdCaja();
        $data['idSucursal'] = $login->getSucursal();
               
        $data['fecha'] = date('Y-m-d');
        $data['metodo_pago'] = 1;       
        $data['status'] = '1';        
        
        $tools = new Tools();
        $data['fecha'] = $tools->setFormatDateToDB($data['fecha']);
        unset($data['cambio'],$data['id_special_requisition']);
        
        if($data['id']==null || $data['id']==''){unset($data['id']);}
        
        foreach($data as $key => $value){
            if($value == '' || $value === null ){
                $data[$key] = array('key'=>$key,'value'=>'NULL');                
            }
        }       
        
        $this->startTransaction();
        parent::save($data, 'ventas_suspendidas');      
        
        $idVenta = $this->getInsertId();
        $this->setLastInsertId($idVenta); // para mostrar id en link de impresion despues de guardar venta
        
        if($ventaDetallesTemp->saveDetallesVentaSuspendida($idVenta)){  
            $this->commit();                       
            return true;
        }
        
        $this->rollback();        
        return null;        
    }
    
    public function delete($id, $table = null) {
        $currentData = $this->getById($id);
        if($currentData['status']== '3'){return true;}
        
        $this->startTransaction();
        $result = parent::update($id, array('status'=>'3'), $this->table);        
        
        if($result){
            $data = $this->getById($id);
            #IF id_special_requisition !=0; Es un pago de specialRequisition el que se esta eliminando
            if($data['id_special_requisition']!='0'){
                if(!$this->setAmmountPaymentsOfSpecialRequisition($data['id_special_requisition'])){
                    $this->rollback();
                    return null;
                }
            }else{
                $detallesAfectados = $this->getVentaDetallesSaved($id);
                if(!$this->addInventoryFromVentasDetalles($detallesAfectados)){
                    $this->rollback();
                    return null;
                }
            }
        }
        $this->commit();
        return true;
    }

    public function getById($id, $table = null, $selectAux = null) {
       $select = "SELECT *,"
               . "fxGetClienteName(cliente)as clienteName,"
               . "fxGetUserName(creado_por)as usuarioName,"
               . "fxGetFormaPagoName(metodo_pago)as FormaPagoName,"
               . "fxGetStatusName(status,'status','venta')as statusName "
               . "FROM $this->table "
               . "WHERE id = '$id'";
        $result = $this->query($select);
        
        if ($result->num_rows > 0) {
            $set = $this->resultToArray($result);
            return $set[0];
        }

        return false;
    }
    
     public function getByNumVentaAndStoreId($numVenta,$storeId) {
       $select = "SELECT *,"
               . "fxGetClienteName(cliente)as clienteName,"
               . "fxGetUserName(creado_por)as usuarioName,"
               . "fxGetFormaPagoName(metodo_pago)as FormaPagoName,"
               . "fxGetStatusName(status,'status','venta')as statusName "
               . "FROM $this->table "
               . "WHERE num_venta = '$numVenta' AND idSucursal = '$storeId'";
        $result = $this->query($select);

        if ($result->num_rows > 0) {
            $set = $this->resultToArray($result);
            return $set[0];
        }

        return false;
    }

    public function isUsedInRecord($id, array $buscarEn = null,$andWhere = null) {
        return parent::isUsedInRecord($id, array('pfa' => 'usuario'));
    }
    
     public function activarVentaSuspendida($idVentaSuspendida){       
        $query = "SELECT * FROM ventas_suspendidas WHERE id = '$idVentaSuspendida'";
        $result = $this->query($query);
        
        if($result){            
            $repository = new VentaDetallesTempRepository();
            $repository->activarVentaSuspendida($idVentaSuspendida);
            
            parent::delete($idVentaSuspendida, 'ventas_suspendidas');
            
            $result = $this->resultToArray($result);
            return $result[0];
        }
        
        return null;
    }
    
    public function hasSaldoPendiente($id){
        $query = "SELECT saldoPendiente FROM view_saldo_pendientes_ventas WHERE idVenta = '$id'";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $result = $result->fetch_object();
            return $result->saldoPendiente;
        }
        
        return null;
    }
    
    public function crearTablaDetallesForUser(){
        $login = new Login();        
        $query = "CREATE TABLE IF NOT EXISTS ventasdetalles_".$login->getId()." 
                 (  `id` int(11) NOT NULL AUTO_INCREMENT,
                    `idVenta` int(11) NULL,
                    `idProducto` int(11) NOT NULL,
                    `descripcion` varchar(255) NOT NULL,
                    `cantidad` double NOT NULL,
                    `precio` double NOT NULL,
                    `precio_sin_impuestos` double NOT NULL,
                    `descuento_item_tipo` CHAR(50)  NULL,
                    `descuento_item_valor` double NULL,
                    `descuento_item_monto` double NULL,
                    `descuento_orden_monto` double NULL,
                    `impuestos` varchar(50) NULL,
                    `impuestos_tasa` double NULL,
                    `impuestos_monto` double NULL,
                    `impuestos_incluidos` CHAR(5)  NULL,
                    `status` int(11) NOT NULL,
                    PRIMARY KEY (`id`)
                 )ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        
       $result = $this->query($query);
    }
    
    public function insertDetalle($data){
        $ventasDetallesTemp = new VentaDetallesTempRepository();        
        return $ventasDetallesTemp->save($data);
    }
    
    public function setDescuentoOrden($data){
        $ventasDetallesTemp = new VentaDetallesTempRepository();        
        return $ventasDetallesTemp->setDescuentoOrden($data);
    }
    
    public function getVentaDetalles(){
        $login = new Login();
        $query = "SELECT v.*,
                    v.cantidad as cantidadOrigen,
                    v.id as idDetalleTemp,                    
                    IF(idProducto != 0,v.idProducto,v.descripcion)as producto,
                    fxGetTamanoDescripcion(p.tamano) as tamanoName,
                    fxGetImpuestosTasa(v.impuestos) as impuestosTasa,
                    p.impuestos_incluidos
                  FROM ventasdetalles_".$login->getId()." v LEFT JOIN  productos p ON v.idProducto = p.id
                  WHERE v.status = '1'
                  ORDER BY v.id";
        $result = $this->query($query);
        
        if($result){
            $result = $this->resultToArray($result);
            return $result;
        }
        
        return null;
    }
    
    public function getVentasSuspendidas(){
        $login = new Login();
        $query = "SELECT *
                  FROM ventas_suspendidas
                  WHERE status = '1'    
                  AND idSucursal = '{$login->getSucursal()}'
                  ORDER BY id";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $result = $this->resultToArray($result);
            return $result;
        }
        
        return null;
    }
    
    public function getVentaDetallesSaved($id){
        $query = "SELECT vd.*,"
                . "fxGetTamanoDescripcion(p.tamano)as tamanoName,"
                . "idSucursal "
                . "FROM ventasdetalles vd "
                . "LEFT JOIN ventas v ON v.id = vd.idVenta "
                . "LEFT JOIN  productos p ON vd.idProducto = p.id "
                . "WHERE vd.idVenta = '$id'";
        $result = $this->query($query);
        
        if($result){
            $result = $this->resultToArray($result);
            return $result;
        }
        
        return null;
    }
    
    public function setVentaDetallesById($idVenta){
        $repository = new VentaDetallesTempRepository();
        
        return $repository->setVentaDetallesById($idVenta);
    }   
    
    public function setAmmountPaymentsOfSpecialRequisition($idReq){
        #Setear monto de pagos de SpecialRequisition
        $query = "SELECT *,"
                . "IFNULL(SUM(total_venta),0)as monto "
                . "FROM ventas "
                . "WHERE id_special_requisition = '$idReq' "
                . "AND status != 3 ";
        
        $result = $this->query($query);
        
        if($result){
            $result = $result->fetch_object();
            $repo = new SpecialRequisitionRepository();            
            $repo->updateString(array('ammount_payments'=>$result->monto), " id = '$idReq'");
            
            $data = $repo->getById($idReq);
            $balance = $data['ammount'] - $result->monto;
            if($balance > 0){$status = '1';}else{$status = '2';}
            $repo->updateString(array('status_payment'=>$status), " id = '$idReq'");
            
            return true;
        }        
        return null;
    }
    
    public function getPaymentsByIdSpecialRequisition($idReq){
        $query = "SELECT *,fxGetStatusName(status,'status','venta')as statusName FROM $this->table WHERE id_special_requisition = '$idReq'";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            return $this->resultToArray($result);
        }
        return null;
    }
    
    
    public function truncateIfIsEditInfo(){
        $repository = new VentaDetallesTempRepository();
        $repository->truncateIfIsEditInfo();
    }
    
    public function clearDetalles(){
        /* Elimina detalles que esten activos status = 1 */
        $repository = new VentaDetallesTempRepository();
        $repository->clearDetalles();
    }
    
    public function getProductoById($idProducto){
        $repo = new ProductoRepository();
        return $repo->getById($idProducto);
    }
    
    public function getProductoByCode($code){
        $repo = new ProductoRepository();
        return $repo->getByCode($code);
    }
  
   public function getVentasByCliente($id){
       $query = "SELECT id, fxGetStatusName(status,'status','venta') as status "
                . "FROM ventas "
                . "WHERE cliente = '$id' "
                . "AND status != 3";
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            return $this->resultToArray($result);
        }
        
        return null;
   }
   
    public function getCobrosByIdVenta($idVenta){
        $query = "SELECT fxGetMontoCobros('$idVenta')as cobros";
        $result = $this->query($query);
        
        if($result){
            $result = $result->fetch_object();
            return $result->cobros;
        }
        
        return null;
    }
   
    public function getCobrosDetalleByIdVenta($idVenta){
        $query = "SELECT *,SUM(monto)as monto,"
                . "fxGetFormaPagoName(formaPago)as formaPagoName "
                . "FROM cobros "
                . "WHERE idVenta = '$idVenta' "
                . "AND status != 2 "
                . "GROUP BY formaPago,numDocumento";
        $result = $this->query($query);
        
        if($result){
           return $this->resultToArray($result);
        }
        
        return null;
    }
   
   public function cajaAbierta($caja){
       $query = "SELECT acc.id "
               . "FROM apertura_cierre_cajas acc,estaciones e "
               . "WHERE acc.idCaja = e.id "
               . "AND token = '$caja' AND acc.status = '1'";
       $result = $this->query($query);
       
       if($result->num_rows > 0){
           return true;
       }
       return null;
   }
   
    public function getNextSaleNum(){
        $login = new Login();
        $query = "SELECT num_venta FROM ventas WHERE idSucursal = '{$login->getSucursal()}}' ORDER BY num_venta DESC LIMIT 1";        
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $result = $result->fetch_object();
            $numVenta = $result->num_venta;
            $numVenta = $numVenta + 1;
            return $numVenta;
        }else{
            return 1;
        }
    }
    
     public function createFilterFecha($options,$campoFecha = null ){
        if(!isset($options['fechaInicio']) && !isset($options['fechaFin'])){return null;}        
        $fechaInicio = $options['fechaInicio'];
        $fechaFin = $options['fechaFin'];
        $fecha = null;
        $tools = new Tools();
        if($fechaInicio!=null){
            $fechaInicio = $tools->setFormatDateToDB($fechaInicio);
            if($fechaFin!=null){
                $fechaFin = $tools->setFormatDateToDB($fechaFin);
                $fecha .=" AND $campoFecha BETWEEN '{$fechaInicio}' AND '{$fechaFin}' ";
            }else{
                $fecha .=" AND $campoFecha BETWEEN '{$fechaInicio}' AND '{$fechaInicio}' ";
            }
        }elseif($fechaFin!=null){
            $fecha .=" AND $campoFecha BETWEEN '{$fechaFin}' AND '{$fechaFin}' ";
        }
        
        return $fecha;
    }
    
    public function getCierreCaja($id){
        $repo = new AperturaCierreCajaRepository();
        $data = $repo->getById($id);
        
        $query = "SELECT formaPago,SUM(c.monto)as monto "
               . "FROM cobros c,ventas v "
               . "WHERE c.idVenta = v.id "
               . "AND idCaja = '{$data['idCaja']}'"
               . "AND c.creado_fecha >= '{$data['fechaApertura']}'"
               . "AND v.status != 3 "
               . "GROUP BY formaPago";   
        
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $array = array();
            foreach($result as $row){
                $array[$row['formaPago']] = $row['monto'];
            }
            return $array;
        }
        return null;
    }
    
    public function getDataVentaParaArqueo($id){
        $repo = new AperturaCierreCajaRepository();
        $data = $repo->getById($id);
        
        $query = "SELECT fxGetFormaPagoName(formaPago)as formaPago,SUM(c.monto)as monto "
               . "FROM cobros c,ventas v "
               . "WHERE c.idVenta = v.id "
               . "AND idCaja = '{$data['idCaja']}'"
               . "AND c.creado_fecha BETWEEN '{$data['fechaApertura']}' AND '{$data['fechaCierre']}'"
               . "AND v.status != 3 "
               . "GROUP BY formaPago ORDER BY formaPago ASC";   
        
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            return $this->resultToArray($result);
        }
        return null;
    }
    
    public function getDataVentaParaResumen($id){
        $repo = new AperturaCierreCajaRepository();
        $data = $repo->getById($id);
        
        $query = "SELECT fxGetFormaPagoName(formaPago)as formaPago,SUM(c.monto)as monto "
               . "FROM cobros c,ventas v "
               . "WHERE c.idVenta = v.id "
               . "AND idCaja = '{$data['idCaja']}'"
               . "AND c.creado_fecha BETWEEN '{$data['fechaApertura']}' AND NOW()"
               . "AND v.status != 3 "
               . "GROUP BY formaPago ORDER BY formaPago ASC";   
        
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            return $this->resultToArray($result);
        }
        return null;
    } 
    
     public function getTotalVentasByIdApertura($id){
        $repo = new AperturaCierreCajaRepository();
        $data = $repo->getById($id);
        
        $query = "SELECT SUM(c.monto)as monto "
               . "FROM cobros c,ventas v "
               . "WHERE c.idVenta = v.id "
               . "AND idCaja = '{$data['idCaja']}'"
               . "AND c.creado_fecha BETWEEN '{$data['fechaApertura']}' AND '{$data['fechaCierre']}'"
               . "AND v.status != 3 ";   
        
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            $result = $result->fetch_object();
            return $result->monto;
        }
        return null;
    }
    
    public function getVentasCanceladasByIdApertura($id){
        $repo = new AperturaCierreCajaRepository();
        $data = $repo->getById($id);
        
        $query = "SELECT * "
               . "FROM ventas "
               . "WHERE idCaja = '{$data['idCaja']}' "
               . "AND creado_fecha BETWEEN '{$data['fechaApertura']}' AND '{$data['fechaCierre']}' "
               . "AND status = 3 ";   
        
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            return $this->resultToArray($result);
        }
        return null;
    }
    
    public function getSalesTodayByIdCaja($idCaja = null){        
        if($idCaja == null){
            $login = new Login();
            $idCaja = $login->getIdCaja();
        }     
        
        $fecha = $this->createFilterFecha(array('fechaInicio'=>date('Y-m-d'),'fechaFin'=>date('Y-m-d')), 'fecha');
        $query =  "SELECT *,"
                . "fxGetStatusName(status,'status','venta')as statusName "
                . "FROM ventas "
                . "WHERE 1 = 1 "
                . "$fecha "
                . "AND idCaja = '$idCaja'"
                . "ORDER BY id DESC ";
        
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            return $this->resultToArray($result);
        }
        return null;
    }
    
    public function getSalesTodayByIdStore($idStore = null){        
        if($idStore == null){
            $login = new Login();
            $idStore = $login->getSucursal();
        }     
        
        $fecha = $this->createFilterFecha(array('fechaInicio'=>date('Y-m-d'),'fechaFin'=>date('Y-m-d')), 'fecha');
        $query =  "SELECT *,"
                . "fxGetStatusName(status,'status','venta')as statusName "
                . "FROM ventas "
                . "WHERE 1 = 1 "
                . "$fecha "
                . "AND idSucursal = '$idStore'"
                . "ORDER BY id DESC ";
        
        $result = $this->query($query);
        
        if($result->num_rows > 0){
            return $this->resultToArray($result);
        }
        return null;
    }
    
     public function getDevolucionesTodayByIdCaja($idCaja = null){
        $options = array(
            'reporte'=>'devolucionesPorFecha',
            'fechaInicio'=>date('Y-m-d'),
            'fechaFin'=>date('Y-m-d'),
            'idCaja'=>$idCaja
        );
        
        if($idCaja == null){
            $login = new Login();
            $options['idCaja'] = $login->getIdCaja();
        }
        
        $repo = new ReportListasEntity();
        return $repo->getDevolucionesPorFecha($options);        
    }


    public function crearTablaCobrosForUser(){
       $repo = new CobroTempRepository();
       $repo->crearTablaCobrosForUser();
    }
    
    /*PARA CONTROL DE INVENTARIOS*/
  public function addInventoryFromVentasDetalles($detallesAfectados){
        $repoInventario = new InventarioRepository();         
        
        $array = array();
        foreach($detallesAfectados as $detalle){         
            $row = array(
                        'id_product'=>$detalle['idProducto'],
                        'quantity'=>$detalle['cantidad'],
                        'sucursal'=>$detalle['idSucursal'],
                        'controller'=>'Venta-eliminar '.$detalle['idVenta']
                    );
            $array[] = $row;
        }

        return $repoInventario->deleteSubInventory($array);
    }
    
    
    //  Dashboard Ventas
    public function getSalesByDateRange($start,$end,$group = null,$orderBy = null){       
        if(is_null($group)){$group = " GROUP BY idSucursal";}else{$group = " GROUP BY $group";}
        if(is_null($orderBy)){$orderBy = " ORDER BY total_sales DESC";}else{$orderBy = " ORDER BY $orderBy";}
        
        $date = $this->createFilterFecha(array('fechaInicio'=>$start,'fechaFin'=>$end),'fecha');
        $query = "SELECT "
                . "DATE_FORMAT(fecha,'%m/%d/%Y %h:%i %p')as formated_date,"   
                . "fxGetStoreName(idSucursal)as store_name, "
                . "SUM(total_venta)as total_sales "
                . "FROM $this->table "
                . "WHERE 1 = 1 AND status != 3 $date $group $orderBy ";
        
        $result = $this->query($query);
        if($result->num_rows > 0){
            return $this->resultToArray($result);
        }
        return null;
    }
    
    public function getSalesByStoreIdByDateRange($start,$end,$group = null,$orderBy = null){       
        $login = new Login();
        $store_id = $login->getStoreId();
        if(is_null($group)){$group = " GROUP BY DATE(fecha)";}else{$group = " GROUP BY $group";}
        if(is_null($orderBy)){$orderBy = " ORDER BY DATE(fecha) DESC";}else{$orderBy = " ORDER BY $orderBy";}
        
        $date = $this->createFilterFecha(array('startDate'=>$start,'endDate'=>$end),'DATE(date)');
        $query = "SELECT "
                . "DATE_FORMAT(fecha,'%m/%d/%Y')as date," 
                . "DAYNAME(fecha)as dayname,"
                . "fxGetStoreName(idSucursal)as store_name, "
                . "SUM(total_venta )as total_sales "
                . "FROM $this->table "
                . "WHERE 1 = 1 AND status != 3 AND idSucursal = '$store_id' $date $group $orderBy ";
        
        $result = $this->query($query);
        if($result->num_rows > 0){
            return $this->resultToArray($result);
        }
        return null;
    }
}