<?php
/**
 * Description of Cliente
 *
 * @author carlos
 */

class ProveedorEntity extends ProveedorRepository{
    private $options = array (
        'nombre' => null,
        'calle' => null,
        'estado' => null,
        'ciudad' => null,
        'codigopostal' => null,
        'contacto' => null,
        'correo' => null,
        'telefono' => null,
        'fax'=>null,
        'metodoPago'=>null,
        'diasCredito'=>null,
        'comentarios'=>null,
        'creado_por'=>null,
        'creado_fecha'=>null,
        'modificaciones'=>null
     );
    
  public function setOptions($data){
      foreach ($this->options as $option => $value){
          if(isset($data[$option])){
            $this->options[$option] = $data[$option];
          }
      }
  }
  
  public function getOptions(){
      return $this->options;
  }
    
    public function setNombre($nombre){
        $this->nombre = $nombre;
    }
    
    public function setCalle($calle){
        $this->calle = $calle;
    }
    
    public function setNumero($numero){
        $this->numero = $numero;
    }
    
    public function setEstado($estado){
        $this->estado = $estado;
    }
    
    public function setCiudad($ciudad){
        $this->ciudad = $ciudad;
    }
    
    public function setCodigopostal($codigoPostal){
        $this->codigoPostal = $codigoPostal;
    }
    
    public function setContacto($contacto){
        $this->contacto = $contacto;
    }
    
    public function setCorreo($correo){
        $this->correo = $correo;
    }
    
    public function setTelefono($telefono){
        $this->telefono = $telefono;
    }
    
    public function setTable($table){
        $this->table = $table;
    }

    public function getNombre(){
        return $this->options['nombre'];
    }
    
    public function getDireccion(){
        return $this->options['calle'];
    }
    
    public function getNumero(){
        return $this->options['numero'];
    }
    
    public function getEstado(){
        return $this->options['estado'];
    }
    
    public function getCiudad(){
        return $this->options['ciudad'];
    }
    
    public function getCodigopostal(){
        return $this->options['codigopostal'];
    }
    
    public function getContacto(){
        return $this->options['contacto'];
    }
    
     public function getTelefono(){
        $telefono = '';
        if(trim($this->options['telefono'])!=''){$telefono .= 'Phone. '.$this->options['telefono'];}    
       
        return $telefono;
    }
    
    public function getCorreo(){
        $email = '';
        if(trim($this->options['correo'])!=''){$email .= 'E-mail. '.$this->options['correo'];}    
       
        return $email;
    }
    
    public function getSaldoPendiente(array $options = null,$onlyInovice = null){
        if($options==null){$options['idProveedor'] = $this->getId();}
        return parent::getSaldoPendiente($options,$onlyInovice);
    }
    
    public function getOpenInvoices($proveedor = null,$rangoFecha = null) {
        if($proveedor == null){$proveedor = $this->getId();}
        return parent::getOpenInvoices($proveedor,$rangoFecha);
    }
    
    public function getTable(){
        return $this->table;
    }  
  
}