<?php
/**
 * Description of Ciclo
 *
 * @author carlos
 */
class AperturaCierreCajaEntity Extends AperturaCierreCajaRepository{
    private $options = array(
        'fechaApertura'=>null,
        'idCaja'=>null,
        'efectivoInicial'=>null, 
        'fechaCierre'=>null,
        'efectivoFinal'=>null,
        'chequesFinal'=>null,
        'tarjetasFinal'=>null,
        'electronicoFinal'=>null,
        'devoluciones'=>null,
        'creado_fecha'=>null,
        'creado_por'=>null,
        'modificaciones'=>null,
        'status'=>null,
        'autorizacion_usuario'=>null,
        'autorizacion_password'=>null
    );
    
     private $options_aux = array(
        'cajaName'=>null,
        'usuarioName'=>null
    );
    
    public function setOptions($data){
      if(!isset($data['autorizacion_usuario'])){unset($this->options['autorizacion_usuario']);}
      if(!isset($data['autorizacion_password'])){unset($this->options['autorizacion_password']);}
      foreach ($this->options as $option => $value){
          if(isset($data[$option])){
            $this->options[$option] = $data[$option];
          }
      }
      
    foreach ($this->options_aux as $option => $value){
        if(isset($data[$option])){
          $this->options_aux[$option] = $data[$option];
        }
      }
    }
  
    public function getOptions(){
        return $this->options;
    }
    
    public function getCajaName(){        
        return $this->options_aux['cajaName'];
    }
    
    public function getUsuarioName(){        
        return $this->options_aux['usuarioName'];
    }
    
    public function getFechaCreacion(){
       return $this->options['creado_fecha'];
    }
    
    public function getFechaCierre(){
       return $this->options['fechaCierre'];
    }
    
    public function getEfectivoInicial(){
       return $this->options['efectivoInicial'];
    }
    
    public function getEfectivoFinal() {
       return $this->options['efectivoFinal'];
    }
    
    public function getChequesFinal() {
       return $this->options['chequesFinal'];
    }
    
    public function getTarjetasFinal() {
       return $this->options['tarjetasFinal'];
    }
    
    public function getElectronicoFinal() {
       return $this->options['electronicoFinal'];
    }
    
    public function getDevoluciones() {
       return $this->options['devoluciones'];
    }
    
    public function getMontoCierre(){
        /*EfectivoInicial no se suma porque ya va dentro de efectivoFinal cuando se suma el dinero de caja*/
        return $this->options['efectivoFinal'] + $this->options['chequesFinal'] + $this->options['tarjetasFinal'] + $this->options['electronicoFinal'] + $this->options['devoluciones'];
    }
    
    public function getMontoCierreMenosInicial(){
        return $this->getMontoCierre() - $this->getEfectivoInicial();
        
    }
    
    public function getMontoCierreMenosInicialMasRetiros(){
        return $this->getMontoCierreMenosInicial();
        
    }
    
    public function getTable(){
        return $this->table;
    }
}
