<?php 
$controller = 'Store-request';
$action = '';
if(isset($_POST['action'])){
    $action = $_POST['action'];
    if (isset($_POST['id'])) {$id = $_POST['id'];}
}elseif(isset($_GET['action'])){
    $action = $_GET['action'];
    if (isset($_GET['id'])) {$id = $_GET['id'];}
}

include $_SERVER["DOCUMENT_ROOT"].'/app/include/bootstrap.php';

$_form = new StoreRequestForm();
$_storeRequest = new StoreRequestRepository();

switch($action){
    case 'insert':        
        $_form->setTokenForm($_POST['token_form']);
        $_form->populate($_POST);  
        $_storeRequest->setOptions($_POST);
        if ($_form->isValid()) {             
            if ($_storeRequest->save($_storeRequest->getOptions())) {                
                $_storeRequestNo = $_storeRequest->getLastInsertId();
                $printStoreRequest = "<a href=\"\" onclick=\"javascript: void window.open('/Controller/StoreRequest.php?action=export&format=pdf&flag=in&id=$_storeRequestNo','','width=700,height=500,status=1,scrollbars=1,resizable=1')\">".$_translator->_getTranslation('Imprimir')."</a>";  
                $flashmessenger->addMessage(array(
                    "success"=>$_translator->_getTranslation("Pedido de sucursal")." #$_storeRequestNo ".$_translator->_getTranslation("se ha registrado exitosamente.")));
                
                header("Location: Store-request.php?action=edit&id=$_storeRequestNo");
            }else{                
                $vista = 'StoreRequest.php';
                include $root . '/View/Template.php';                
            }
        } else {
            $vista = 'StoreRequest.php';
            include $root . '/View/Template.php';
        }
        break;
        
    case 'list':          
        $searchFilter = null;
        if(isset($_POST['search'])){$searchFilter = $_POST;}
        $_listStoreRequests = $_storeRequest->getListStoreRequest($searchFilter);
        
        $vista = 'StoreRequestList.php';
        include $root . '/View/Template.php';
    break;
        
    case 'import':
        switch($_GET['format']){
            case 'excel':
                switch($_GET['flag']){
                    case 'search':
                        $_storeRequest->resultSearchToExcel($_GET);
                        break;
                }       
                break;
            
            case 'pdf':
                switch($_GET['flag']){
                    case 'store_request':
                        $pdf = new StoreRequestPDF($id);
                        break;
                    }   
                break;
        }
         
        break;
    
    case 'edit': 
        $login = new Login();
        
        if($_GET){
            $_storeRequestData = $_storeRequest->getById($id);
            
            /*Si es usuario Sucursal y esta intentado editar un StoreRequest que no es de su sucursal ; lo envia a listado*/
            if($login->getRole() == '14' && $_storeRequestData['store_id'] !== $login->getStoreId()){
                header("Location: Store-request.php?action=list");
            }
            
            $_storeRequest->crearTablaDetallesForUser();
            $_storeRequest->setStoreRequestDetallesById($id,$_form->getTokenForm());            
        }
        
        if($_POST){            
            $_form->setTokenForm($_POST['token_form']);
            $_storeRequestData = $_POST;
        }
        
        $_form->setActionController('edit');
        $_form->setId($id);
        $_form->populate($_storeRequestData);        
        $_disabled = null;
        
        if($_storeRequestData['status'] == '2'){
            $_disabled = true;
            $_form->disabledAllElements();
        }
        
        $_storeRequest->setOptions($_storeRequestData);
        if(isset($_POST['id'])){
            if($_form->isValid()){                
                $result = $_storeRequest->update($id,$_storeRequest->getOptions()); //no tengo id porque viene de post
                if($result){
                    $flashmessenger->addMessage(array('success'=>'Pedido de sucursal se actualizo exitosamente.'));
                    header("Location: Store-request.php?action=edit&id=$id");
                }else{
                     $vista = 'StoreRequest.php';
                    include $root . '/View/Template.php';                    
                }       
            }else{
                $vista = 'StoreRequest.php';
                include $root . '/View/Template.php';
            }
        }else{
            $vista = 'StoreRequest.php';
            include $root . '/View/Template.php';
        }        
        break;
    
    case 'delete':
        /*Si es usuario Sucursal y esta intentado eliminar un StoreRequest que no es de su sucursal ; lo envia a listado*/
        $_storeRequestData = $_storeRequest->getById($id);
        if($login->getRole() == '14' && $_storeRequestData['store_id'] !== $login->getStoreId()){
            header("Location: Store-request.php?action=list");
        }
        
        if($_storeRequest->delete($id)){
            $flashmessenger->addMessage(array('success'=>'Pedido de sucursal se cancelo exitosamente.'));
        }
            
        header('Location: Store-request.php?action=list');
        break;
        
    case 'ajax':
        $ajaxStoreRequest = new StoreRequestAjax();
        $json = $ajaxStoreRequest->getResponse($_POST['request'],$_POST);
        
        echo json_encode($json);
        break;       
    
    default:      
        $_storeRequest->crearTablaDetallesForUser();
        $repo = new StoreRequestDetailsTempRepository();
        $repo->setStoreRequestDetallesForNewStoreRequest($_form->getTokenForm());
        
        $vista = 'StoreRequest.php';
        include $root.'/View/Template.php';
        break;
}