<?php 
$controller = 'Product';
$action = '';
if(isset($_POST['action'])){
    $action = $_POST['action'];
    if (isset($_POST['id'])) {$id = $_POST['id'];}
}elseif(isset($_GET['action'])){
    $action = $_GET['action'];
    if (isset($_GET['id'])) {$id = $_GET['id'];}
}

include $_SERVER["DOCUMENT_ROOT"].'/app/include/bootstrap.php';

$_form = new ProductoForm();
$_form->deleteElement('cancelar');
$_form->deleteElement('agregar');
$producto = new ProductoEntity();
$_listaProductos = $producto->getListaProductos();

switch($action){
    case 'insert':
        $_form->populate($_POST);
        if ($_form->isValid()) {
            $producto->setOptions($_POST);
            $producto->setImage($_FILES['imagen']);
            $result = $producto->save($producto->getOptions());
            if ($result) {
                $flashmessenger->addMessage(array('success'=>'Producto registrado exitosamente.'));
                header("Location: Product.php");
            }else{
                $flashmessenger->addMessage(array('danger'=>'Error. Intenta nuevamente o contacta a tu proveedor de sistemas.'));
                $vista = 'Producto.php';
                include $root.'/View/Template.php';                     
            }
        } else {
            $vista = 'Producto.php';
            include $root . '/View/Template.php';
        }
        break;
    
    case 'pagination':
       $_form = new ProductoBuscarForm();
       $_form->populate($_GET);
       if(isset($_GET['send'])){
            if(!isset($_GET['pag'])){$_GET['pag'] = null;}
            $pagObj = $producto->pagination($_GET['pag'],$_GET);
            $productoPag = $pagObj->getResultSetQueryString();
        }
        
        $vista = 'ProductoPagination.php';
        include $root . '/View/Template.php';
        break;
    
    case 'edit':
        if($_GET){
            $productoData = $producto->getById($id);
            $producto->crearTablaDetallesForUser();
            $producto->setProductDetailsById($id);                   
        }
        if($_POST){$productoData = $_POST;}
        $_form->setActionController('edit');
        $_form->setId($id);
        $_form->populate($productoData);
        
        $producto->setOptions($_POST);
        if(isset($_POST['id'])){
            if($_form->isValid()){                
                $producto->setImage($_FILES['imagen']);
                $result = $producto->update($id,$producto->getOptions()); 
                if($result){
                    $flashmessenger->addMessage(array('success'=>'Producto actualizado exitosamente.'));
                    //header("Location: Producto.php?action=edit&id=$id");
                    echo "<script>document.location = 'Product.php?action=edit&id=$id'</script>";
                }else{
                    $flashmessenger->addMessage(array('danger'=>'Error. Intenta nuevamente o contacta a tu proveedor de sistemas.'));
                }       
            }else{
                $vista = 'Producto.php';
                include $root . '/View/Template.php';
            }
        }else{
            $vista = 'Producto.php';
            include $root . '/View/Template.php';
        }        
        break;
    
    case 'delete': 
        if(!$producto->isUsedInRecord($id)){
            if($producto->delete($id)){
                $flashmessenger->addMessage(array('success'=>'Hecho !! El Producto fue eliminado satisfactoriamente.')); 
            }
        }else{
            $message = 'Hola !! este Producto no puede ser eliminado, esta siendo utilizado en almenos un registro.';
            $flashmessenger->addMessage(array('info'=>$message));
        }
        
        header("Location: Product.php");
        break;    
        
    case 'ajax':
        $ajaxProduct = new ProductAjax();
        $json = $ajaxProduct->getResponse($_POST['request'],$_POST);
        
        echo json_encode($json);
        break;     
    
    default:
        $producto->crearTablaDetallesForUser();
        $vista = 'Producto.php';
        include $root.'/View/Template.php';
}