<?php
class SliceAjax extends SliceRepository {
    public $formProduct = null;
    public $formStoreIn = null;
    
    public function __construct() {
        parent::__construct();
    }

    public function getResponse($request, $options) {
        return $this->$request($options);
    }

    public function setSliceDetails(array $options) {
        $data = array();
        foreach($options['options'] as $row){
            $data[$row['name']] = $row['value'];
        }

        $options = $data;
        
        $supplie = $this->getSupplieById($options['id_supplie']);
        if($supplie){
            $data = array(
                'idDetailTemp'=>$options['idDetailTemp'],
                'id_supplie'=>$supplie['id'],
                'quantity'=>$options['quantity']); /*Para cuenta de inventario*/
            
            $this->insertDetalle($data);
            $sliceDetails = $this->getSliceDetails();
            $detalles = $this->listSliceDetails($sliceDetails);

            $json = array(
                'response' => true,
                'sliceDetails' => $detalles['listDetails'],
                'totalItems'=>number_format($detalles['totalItems'],2)
            );
            
            return $json;
        }else{
            $this->flashmessenger->addMessage(array('info'=>$this->_getTranslation('Producto no registrado.')));
            return $json = array(
                'response'=>null,
                'message'=>$this->flashmessenger->getMessageString());
        }
    }
    
    public function listSliceDetails($detalles){
        $listDetalles = "";
        $cantidadItems = 0;
        
        foreach($detalles as $detalle){
            $array = json_encode($detalle);
            $cantidadItems += $detalle['quantity'];

            $id = $detalle['id'];
            $listDetalles .= "<tr>  
                <td class='text-center'>                       
                    <a class='btn btn-sm btn-primary' onclick='setDetailSliceToEdit($array);'><i class='fa fa-pencil'></i></a>
                    <a class='btn btn-sm btn-danger' onclick='deleteSliceDetalles($id);'><i class='fa fa-trash'></i></a>
                </td>
                <td class='text-center'>".$detalle['code']."</td>
                <td>".$detalle['description']."</td>
                <td class='text-right'>".number_format($detalle['quantity'],2)."</td> 
                <td class='text-center'>".$detalle['unitMeasureName']."</td>
                </tr>";
        }
        
        return array('listDetails'=>$listDetalles,
                     'totalItems'=>$cantidadItems,
            );
    }
    
    public function getListSliceDetails(){
        $sliceDetails = $this->getSliceDetails();
        $detalles = $this->listSliceDetails($sliceDetails);

            $json = array(
                'response' => true,
                'sliceDetails' => $detalles['listDetails'],
                'totalItems'=>number_format($detalles['totalItems'],2)
            ); 
            
            return $json;
    }

    public function deleteDetalles(array $options){
        $id = $options['id'];
        $repository = new SliceDetailsTempRepository();
        
        if($repository->delete($id)){
            $response = true;
            $msj = 'Producto eliminado correctamente.';
        }else{
            $response = null;
            $msj = "No se pudo eliminar producto. Intente nuevamente.";
        }
        
        $sliceDetails = $this->getSliceDetails();
        $detalles = $this->listSliceDetails($sliceDetails);

        $json = array(
                'response' => true,
                'listDetails' => $detalles['listDetails'],
                'totalItems'=>number_format($detalles['totalItems'],2),
            ); 
            return $json;
    }
    
    public function getUnitMeasure($options){
        $repo = new SupplieRepository();
        $data = $repo->getById($options['supplie']);
        
        return array(
            'response'=>true,
            'unitMeasure'=>$data['unitMeasureName']
        );
    }
}