<?php
/**
 * Description of Login
 *
 * @author carlos
 */
class Login extends LoginRepository {
    private $user = array();
    private $isLogged = null;
    
    public function __construct($options = null) {
        if(null === $options){
            if(isset($_SESSION['usuario'])){ 
                $this->user = $_SESSION['usuario'];
                $this->isLogged = true;
            }
        }else{
            $this->isLoginCorrect($options['usuario'], $_POST['contrasena']);
        }
    } 
       
    public function isLoginCorrect($user, $password) {
        $data = parent::isLoginCorrect($user, $password);
        #Get sucursal
        if($data){                        
            $repoRegister = new EstacionRepository();
            //$data['token'] = $this->getClientIP();            
            $data['token'] = 1;            
            //$caja = $repoRegister->getByToken($data['token']);
            $caja = $repoRegister->getByToken(1);
            
            
            
            $data['tipoEstacion'] = $caja['tipo'];             
            $data['idCaja'] = $caja['id'];                 
            $data['cajaNombre'] = $caja['nombre'];
            
            $repoSucursal = new SucursalRepository();
            //$sucursal = $repoSucursal->getByToken($data['token']);
            $sucursal = $repoSucursal->getById($data['sucursal']);
            $data['idSucursal'] = $sucursal['id'];  
            $data['sucursalNombre'] = $sucursal['nombre'];
            
            $this->setUser($data);
            $this->isLogged = true;
        }
         return null;
    }
    
    public function getTipoEstacion(){
        return $this->user['tipoEstacion'];
    }
    
    public function isRegister(){
        if($this->user['tipoEstacion']=='1'){
            return true;
        }
        return null;
    }
    
    public function setUser($data){
        $this->user = $data;
        $_SESSION['usuario'] = $this->user;
    }
    
    public function getId(){
        return $this->user['id'];
    }
    
    public function getUusario(){
        return $this->user['usuario'];
    }
    
    public function getNombreCompleto(){
        return $this->user['nombre']." ".$this->user['apellido'];
    }
    
    public function getToken(){
        return $this->user['token'];
    }
    
    public function getSucursal(){
        return $this->user['idSucursal'];
    }
    
    public function getSucursalNombre(){
        if(trim($this->user['sucursalNombre']) === null || trim($this->user['sucursalNombre']) === ''){
            $translator = new Translator();
            return $translator->_getTranslation('Desconcida');
        }
        return $this->user['sucursalNombre'];
    }
    
    public function getIdCaja(){
        return $this->user['idCaja'];
    }
    
    public function getCajaNombre(){
        return $this->user['cajaNombre'];
    }
    
    public function getRole(){
        return $this->user['role'];
    }
    
    public function isLogged(){
        return $this->isLogged;
    }
    
    public function getUnidad(){
        return $this->user['unidad'];
    }
    
    public function setCurrentController($controller){
        $_SESSION['usuario']['controller'] = $controller;
    }
    
    public function getCurrentController(){
        return $_SESSION['usuario']['controller'];
    }
    
    public function setCurrentAction($action){
         $_SESSION['usuario']['action'] = $action;
    }
    
    public function getCurrentAction(){
        return  $_SESSION['usuario']['action'];
    }
    
    function getClientIP() {    
        if (!empty($_SERVER['HTTP_CLIENT_IP']))
            return $_SERVER['HTTP_CLIENT_IP'];
       
        return $_SERVER['REMOTE_ADDR'];
    }
}