<?php    
    if(is_null($data['globalDetalles'])){
        $this->flashmessenger->addMessage(array('info'=>'No se encontraron resultados.'));
        header('location: '.ROOT_HOST.'/Controller/BakingPlan.php');
        exit;
    }
    
    //$objPHPExcel = new PHPExcel();    
    //echo "<pre>";var_dump($data);echo "</pre>";exit;
    $arrayData = $data['globalDetalles'];
    $requisitionDetalles = $data['requisitionsDetalles'];
    $specialRequisitionDetalles = $data['specialRequisitionsDetalles'];
    $colTitulosTemp = $arrayData[key(($arrayData))];
    
    $fieldsToPrint = array(
        'pan'=>'Pan',
        'sizeName'=>'Tamano'
    );
    
    foreach($colTitulosTemp as $titulo => $value){
        if(key_exists($titulo, $fieldsToPrint)){            
            $colTitulos[] = $fieldsToPrint[$titulo];
        }
    }
    
    $colTitulos[] = 'Linea';
    $colTitulos[] = 'Especial';
    $colTitulos[] = 'Total';
    $colTitulos[] = 'Stock';
    $colTitulos[] = 'Hornear';
    
    $objPHPExcel = new PHPExcel();
    $objPHPExcel->getActiveSheet()->freezePane('A3');
    $col = count($colTitulos);
    $lastCol = $this->getColLetter($col-1);
    
    $objPHPExcel->getActiveSheet()->mergeCells("A1:".$lastCol."1");            
    $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(50);
    $objPHPExcel->getActiveSheet()->getStyle("A1")->getFont()->setBold(true);
    $objPHPExcel->getActiveSheet()->setCellValue("A1", $this->headerExcelReport);
    $objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setWrapText(true);
    $objPHPExcel->getActiveSheet()->getStyle("A1")->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    $objPHPExcel->getActiveSheet()->getStyle("A1")->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);

    $objPHPExcel->getActiveSheet()->getStyle("A2:".$lastCol."2")->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID);
    $objPHPExcel->getActiveSheet()->getStyle("A2:".$lastCol."2")->getFill()->getStartColor()->setARGB('E0E0E0');      
    $objPHPExcel->getActiveSheet()->getStyle("A2:".$lastCol."2")->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    $objPHPExcel->getActiveSheet()->fromArray($colTitulos,NULL,'A2');  
    
    $row=3;
    foreach ($arrayData as $key => $data) {
        $i=0;     
        foreach ($data as $col => $value) {             
            if(key_exists($col, $fieldsToPrint)){ 
                $col = $this->getColLetter($i);
                $objPHPExcel->getActiveSheet()->setCellValue($col . $row, $value);
                $objPHPExcel->getActiveSheet()->getStyle("A$row:$lastCol$row")->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);                
                $i++;
            }           
        }    
        
        $quantity = 0;
        $specialQuantity = 0;
        if(key_exists($key, $requisitionDetalles)){$quantity = $requisitionDetalles[$key]['quantity'];}
        if(key_exists($key, $specialRequisitionDetalles)){$specialQuantity = $specialRequisitionDetalles[$key]['quantity'];}
        
        $col = $this->getColLetter($i);
        $objPHPExcel->getActiveSheet()->setCellValue($col . $row, $quantity);
        
        $i++;
        $col = $this->getColLetter($i);
        $objPHPExcel->getActiveSheet()->setCellValue($col . $row, $specialQuantity);
        
        $i++;        
        $col = $this->getColLetter($i);
        $objPHPExcel->getActiveSheet()->setCellValue($col.$row, "=C$row+D$row");
        
        $i += 2;        
        $col = $this->getColLetter($i);
        $objPHPExcel->getActiveSheet()->setCellValue($col.$row, "=E$row-F$row");
        
        $row++;
    }

    foreach(range('A',$lastCol) as $columnID) {
        $objPHPExcel->getActiveSheet()->getColumnDimension($columnID)
            ->setAutoSize(true);
    }

    $objPHPExcel->setActiveSheetIndex(0);   
    $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
    
    if($this->saveFile == true){
        $objWriter->save($this->getTempFolder()."/".$this->getNombreArchivo().".xlsx");
    }else{                
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header("Content-Disposition: attachment;filename=".$this->getNombreArchivo().".xlsx");
        header('Cache-Control: max-age=0');
        $objWriter->save('php://output');
        exit;
    }
    unset($objWriter);