<?php
/**
 * Description of ClienteForm
 *Buscar Facturas de Compras y Gastos, Filtrado por proveedor o # de Factura.
 * @author carlos
 */

class VentaBuscarForm extends Form {

    public function __construct() {
        $this->setActionForm('Venta.php');
        $this->setActionController('buscarv');
        $this->setClass('label-inline');
        $this->setMethod('get');
        parent::__construct();        
        $this->init();
    }

    public function init() {       
        $this->addElement(array(
            'type' => 'select',
            'name' => 'cliente',
            'label'=>'Cliente',
            'multiOptions'=>$this->fillListCliente(),
            'optionals'=>array('style'=>'width:180px'),
            'required'=> true
        ));

        $this->addElement(array(
            'type' => 'text',
            'name' => 'idVenta',
            'label'=>'# Venta',
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'lote',
            'label'=>'Lote #',
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'fechaInicio',
            'label'=>'Fecha inicio',
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'text',
            'name' => 'fechaFin',
            'label'=>'Fecha fin',
            'required'=> true
        ));
        
        $this->addElement(array(
            'type' => 'select',
            'name' => 'status',
            'label'=>'Status',
            'multiOptions'=>array('1'=>'Pendientes','2'=>'Pagadas','1-2'=>'Pendientes y pagadas','3'=>'Canceladas',''=>'Todas'),
            'optionals'=>array('style'=>'width:180px'),
            'required'=> true
        ));
        
        $this->addElement(array(
            'type'=>'submit',
            'name'=>'send',
            'label'=>'',
            'value'=>$this->_getTranslation('Buscar'),
            'class'=>'btn btn-primary'
        ));
    }
    
    public function fillListCliente(){
        $repository = new ClienteRepository();
        $result = $repository->getListClientes();
        if ($result) {
            $array = array(null => $this->_getTranslation('Seleccionar una opcion...'));
            foreach ($result as $key => $value) {
                $array[$key] = $value;
            }
            return $array;
        }
    }
}